'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'	addtopic.b	Adds a new topic to an existing conference
'			(C)opyright 1994 Morgan Davis Grop
'
' 09sep93 mwd 1.5	Total rewrite
'
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#define	IDENT_PROG "addtopic"
#define	IDENT_VERS "1.5"
#define	IDENT_DATE "9sep93"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <proline/proline.h>

#define	MAXFILES	52

	gosub AppInit
	if not SuperUser then 
		&print argv$[0]": cannot execute"
		goto ExitError
	endif

	indexFile$	= "i.."
	y$[FALSE]	= "No"
	y$[TRUE]	= "Yes"

	csRsrcFile$ = RSRC_PATH + "cs.rsrc"

	' Get location of the conference system

	fOPEN csRsrcFile$
	fREAD csRsrcFile$
	  & GET CS$
	fClose

	if right$(CS$,1) <> "/" then CS$ = CS$ + "/"

	if argc > 1 then goto Noninteractive

'
' Interactive mode
'
	
	& ioctl(ioClearScreen)
	print "The current conferences are:^M"
	F$ = CS$
	gosub List_Names
	print 
	& read "Add topic to which conference? ",confName$
	if confName$ = "" then goto Exit
	& lcase(confName$)

	F$ = CS$ + confName$ 
	& / F$,I$
	if I$ = "" then 
		print "No such conference."
		goto Exit
	endif
 
	& ioctl(ioClearScreen)
	print "Topics in "confName$" are:^M"
	gosub List_Names
	if count > 5 then 
		print "Six topics already exist, can't add another."
		goto Exit
	endif
	
	& read (15), "Name of new topic? ",topicName$
	if topicName$ = "" then goto ExitError

	print "Is " topicName$ " read-only";
	gosub GetYN_N
	readOnly% = y%
	print "Is " topicName$ " a networked topic";
	gosub GetYN_N
	if y% then 
		& read (-70),"     Posting address: ",netAddress$
		if netAddress$ = "" then goto ExitError
		& read (-70),"      Newsgroup name: ",group$
		print       "   Attach signatures";
		gosub GetYN_Y
		sig% = y%
	endif
	print 
	print "Creating " confName$ "/" topicName$ "...";
	gosub createTopic
	print "done"
goto Exit
	

createTopic:
	&lcase (topicName$)
	&lcase (confName$)
	confPath$ = CS$ + confName$ + "/"
	topicPath$ = confPath$ + topicName$ + "/"
	errMsg$ = ""
	if topicName$ = "info" or topicName$ = "i.." then
		errMsg$ = "is reserved"
	else
  		& / topicPath$,I$
		if i$ > "" then
			errMsg$ = "already exists"
		else
 			if ERR <> 7 then
 				errMsg$ = "is not a legal file name"
 			endif
 		endif
 	endif

	if errMsg$ > "" then
		& print argv$[0] ": '" topicName$ "' " errMsg$
		goto ExitError
	endif
 	
	if netAddress$ > "" then
		if group$ > "" then netAddress$ = netAddress$ + ";" + group$
		netAddress$ = ":" + netAddress$ + ":" + str$(sig%)
	endif		

	fOpen confPath$ indexFile$
	fRead confPath$ indexFile$
		& get moderator$
		input confStatus%, nt%
		for i = 1 to nt%
			& get topicInfo$[i]
			& get topicStats$[i]
		next 
	fClose

	if nt% > 5 then
		& print argv$[0] ": conference already has 6 topics"
		goto ExitError
	endif
	
	nt% = nt% + 1
	fCreate topicPath$
	topicInfo$[nt%] = topicName$ + netAddress$
	topicStats$[nt%]= str$(readOnly%) + ",0,0"

	fOpen confPath$ indexFile$
	fWrite confPath$ indexFile$
		print moderator$
		print confStatus% "," nt%
		for i = 1 to nt%
			print topicInfo$[i]
			print topicStats$[i]
		next 
	fClose
return


Noninteractive:
        options$ = "rsp:n:?"
        optchar$ = ""
        repeat
                gosub getopt
                if optchar$ = "r" then readOnly% = TRUE
                if optchar$ = "s" then sig% = TRUE
                if optchar$ = "p" then netAddress$ = optarg$
                if optchar$ = "n" then group$ = optarg$
                if optchar$ = "?" then goto showUsage
        until optchar$ = ""

        if nargc <> 2 then goto showUsage
	a$ = argv$[1]
	& pos(a$, "/"), p
	if not p then goto showUsage

	confName$ = left$(a$, p - 1)
	topicName$ = mid$(a$, p + 1)
	gosub createTopic
goto Exit

showUsage:
	print "Usage: " argv$[0] " conf/topic [-rs] [-p address [-n newsgroup]]"
goto Exit


List_Names: 
	dim n$[MAXFILES]
	& files(F$,n$,15),count		' Read the names into the list
	& sort(n$,count)		' Sort them
	for I = 1 to count
		& left$ (n$[I],19),A$
		& lcase(A$)
		print A$;
		if not mod(i, 4) then print
	next 
	& erase(n$)
	print 
	print 
return

GetYN_N:
	i = FALSE
	goto GetYN

GetYN_Y:
	i = TRUE

GetYN:
	print "? " left$ (y$[i],1)"^H";
	& clear 
	& rept
		get a$
		& ucase(a$)
		& pos ("^M" + "YN",a$),y%
	& until(y%)
	y% = (a$ = "Y")
	if a$ = "^M" then y% = i
	print y$[y%]
return 



#include <proline/proline.lib>
#include <proline/getopt.lib>
