' ==================================================
'
'	ModemWorks.h
'	MD-BASIC Interface to ModemWorks 3.1
'	Copyright (C) 1994 Morgan Davis Group
'	All Rights Reserved
'
' ==================================================

#pragma once

#define ModemWorks_ID	$776D

#reserve BEEP, BREAK, CARRIER, CHK, FAST, HANGUP, IOCTL
#reserve MSET, NULLS, PAGE, PICKUP, PUT, RCV
#reserve SLOT, SLOW, SND, TERM, TIMER, TSET

#define bps300		0	' &SPEED and &FN fnSpeed values
#define bps1200 	1
#define bps2400 	2
#define bps9600 	3
#define bps19200	4
#define bps38400	5
#define bps57600	6

#define fnOnline	0	' &FN function IDs returning numeric values
#define fnCarrier	0	' for compatibility with old sources
#define fnRing		1
#define fnSpeed 	2
#define fnMode		3
#define fnReserved4	4
#define fnPortInput	5
#define fnModemType	6
#define fnPortByte	7
#define fnPortSpeed	8
#define fnModemSpeed	9
#define fnScanInput	10
#define fnPortDCD	11
#define fnOutputMode	12
#define	fnInputMode	13

#define	fnConnectSpeed	128	' &FN function IDs returning strings

#define modeAns 	0	' &FN fnMode results and &PICKUP selectors
#define modeOrig	1
#define modeQuiet	2

#define noModem 	0	' & FN fnModemType results
#define intModem	1
#define extModem	2

#define ioModem 	0	' I/O direction selectors
#define ioNone		1
#define ioBoth		2
#define ioConsole	3

#define ioGotoXY	1	' &IOCTL functions
#define ioClearScreen	2
#define ioClearEOS	3
#define ioClearEOL	4
#define ioInsertLine	5
#define ioDeleteLine	6
#define ioInsertChar	7
#define ioDeleteChar	8
#define ioHome		9
#define ioBeep		10
#define ioCR		11
#define ioInverse	12
#define ioNormal	13
#define ioScrollUp	14
#define ioScrollDown	15
#define ioUp		16
#define ioDown		17
#define ioRight 	18
#define ioLeft		19
#define ioTab		20
#define ioTabSpace	21
#define ioEraseLine	22
#define ioInsertOn	23
#define ioInsertOff	24
#define ioULOn		25
#define ioULOff 	26
#define ioMTextOn	27
#define ioMTextOff	28

#define stdAppleIO	0	' & SCRN selectors
#define _40Columns	1
#define _80Columns	2
#define stdMWIO 	3
#define printerOff	4
#define printerOn	5

#define uSpkrOff	3	' & USR selectors
#define uSpkrTemp	4
#define uSpkrOn 	5
#define uResetModem	6
#define uForceCarrier	7
#define uNormalCarrier	8
#define uDTRLow 	9
#define uDTRHigh	10

#define wfcConnect	0	' & WAIT FOR CARRIER results
#define wfcCancelled	1
#define wfcNoConnect	2
#define wfcBusy 	3
#define wfcNoDialTone	4
#define wfcNoAnswer	5
#define wfcVoice	6

#define xferOK		0	' &SND and &RCV results, no errors
#define xferFail	1	' Failed due to errors / carrier loss
#define xferCancel	2	' Cancelled by console ESC or remote ^X

#define tUnprotected	0	' &TRACE selectors
#define tHangupReboot	1
#define tHangupOnly	2

#define stdBeepDur	21	' Standard beep duration
#define stdBeepPitch	65	' Standard beep pitch
