' **********************************************************************
' ***
' ***	basic.h 	BASIC functions not found in Applesoft
' ***			(C)opyright 1994 Morgan Davis Group
' ***

#pragma once

	' Modern BASIC functions simulated in Applesoft

#define ERL		(PEEK(218)+PEEK(219)*256)
#define ERR		PEEK(222)
#define ERROR(n)	POKE 222,n : CALL $f2eb
#define LOCATE(row,col) VTAB row : HTAB col
#define WIDTH(n)	POKE 33, n

	' Trigonometric and other math functions

#define ARCCSC(n)	ATN(1/SQR(n*n-1))
#define ARCCOS(n)	(1.5708-2*ATN(n/(1+SQR(1-n*n))))
#define ARCCOT(n)	ATN(1/n)
#define ARCSEC(n)	ATN(SQR(n*n-1))
#define ARCSIN(n)	(2*ATN(n/(1+SQR(1-n*n))))
#define CLG(n)		(LOG(n)*.4342945)
#define COSH(n) 	(.5*(EXP(n)+EXP(-n)))
#define COT(n)		(1/TAN(n))
#define CSC(n)		(1/SIN(n))
#define DIV(n,d)	INT(n/d)
#define FIX(n)		(SGN(n)*INT(ABS(n)))
#define FRAC(n) 	(n-(SGN(n)*INT(ABS(n))))
#define MAX(n1,n2)	((n1+n2+ABS(n1-n2))/2) 
#define MIN(n1,n2)	((n1+n2-ABS(n1-n2))/2) 
#define MOD(n1,n2)	INT(INT(n1+.5)-n2*INT(INT(n1+.5)/n2))
#define PERCENT(x,y,n)	INT(((n)-(x))/((y)-(x))*100)
#define PI		3.141592653
#define ROUND(n)	INT((n)+.5)
#define SEC(n)		(1/COS(n))
#define SINH(n) 	(.5*(EXP(n)-EXP(-n)))
#define TANH(n) 	(1-2*EXP(-n)/(EXP(n)+EXP(-n)))

	' Custom macros to help BASIC

#define LoByte(v)	(v-int(v/$100)*$100)
#define HiByte(v)	int(v/$100)
#define LoWord(v)	(v-int(v/$100)*$100+\
			(int(v-int(v/$10000)*$10000)/$100)*$100)
#define HiWord(v)	(int(v-int(v/$1000000)*$1000000)/$10000+\
			int(v/$1000000)*$100)

#define Peek16(l)	(peek(l)+peek(l+1)*$100)
#define Peek24(l)	(peek(l)+peek(l+1)*$100+peek(l+2)*$10000)
#define Peek32(l)	(peek(l)+peek(l+1)*$100+\
			peek(l+2)*$10000+peek(l+3)*$1000000)
#define Poke16(l,v)	poke l,v-int(v/$100)*$100:poke l+1,int(v/$100)
#define Poke24(l,v)	poke l,v-int(v/$100)*$100:\
			poke l+1,int(v-int(v/$10000)*$10000)/$100:\
			poke l+2,int(v/$10000)
#define Poke32(l,v)	poke l,v-int(v/$100)*$100:\
			poke l+1,int(v-int(v/$10000)*$10000)/$100:\
			poke l+2,int(v-int(v/$1000000)*$1000000)/$10000:\
			poke l+3,int(v/$1000000)
