' **********************************************************************
' ***
' ***	man.b		Manual displayer
' ***			(C)opyright 1994 Morgan Davis
' ***

#define	IDENT_PROG "man"
#define	IDENT_VERS "1.3"
#define	IDENT_DATE "25feb92"
#define	IDENT_NAME "Morgan_Davis"

#define	Man_ID	$6e6d
#reserve MAN

#include <omm.h>
#include <basic.h>
#include <proline/proline.h>

	gosub AppInit

	options$ = "?adl:pw:t:"
	optchar$ = ""
	repeat
		gosub getopt
		if optchar$ = "a" then all = TRUE
		if optchar$ = "d" then printerMode = TRUE
		if optchar$ = "l" then pageLen = val(optarg$)
		if optchar$ = "p" then progress = TRUE
		if optchar$ = "w" then pageWidth = val(optarg$)
		if optchar$ = "t" then CoverTitle$ = optarg$
		if optchar$ = "?" then usage = TRUE
	until optchar$ = ""

	if (nargc < 2) or usage then goto ShowUsage

	cm$ = "--.TH.DA.LM.RM.PP.CN.SP.RC.BR.AF.UC.NP.IF.IP.SH.TB"
	order$ = MAN_LIST
	if CoverTitle$ > "" then
		header$ = "ProLine " + CoverTitle$
	else
		header$ = "ProLine Reference Manual"
	endif
	
	if asc(nargv$[nargc-1]) = 62 then
		AccFile$ = mid$(nargv$[nargc-1],2)
		if asc(AccFile$) = 62 then
			& spc(AccFile$, 62), AccFile$
			AccMode = accWrite
		else
			& getinfo AccFile$, i$
			AccMode = accWrite + (accDelete * (i$ > ""))
		endif
		gosub CheckAccess
		if not AccOK then 
			print argv$[0]": cannot open " AccFile$
			goto Exit
		endif
		if AccMode = accWrite + accDelete then fDelete AccFile$
		nargc = nargc - 1
		outputFile$ = AccFile$
	endif

	argBegin = 1
	if nargv$[1] > "_" then
		a$ = RSRC_PATH + "man.rsrc"
		& getinfo a$, i$
		if i$ > "" then
			fOpen a$
			fRead a$
			& get order$
			fClose
		endif
	else
		if nargv$[1] = "*" then
			print argv$[0]": section not specified"
			goto Exit
		endif
		if nargc < 3 then goto ShowUsage
		order$ = nargv$[1]
		if nargv$[2] = "*" then
			& pos (order$, ":"), p
			if p then order$ = left$(order$, p - 1)
			manFile$ = MAN_PATH + "man." + order$
			& files(manFile$, nargv$),i,i
			if not i then goto Exit
			& erase (nargv$)
			nargc = i + 1
			dim nargv$[nargc]
			& files(manFile$, nargv$),i
			& sort(nargv$,i)
			star = TRUE
		else
			argBegin = 2
		endif
	endif
	orderLen = len(order$)
	
	gosub DumpTools
	& load get SysInfo$[plModulesDir] + "Man"

	& on hangup goto manHUP
	& on int goto manINT
	onerr goto manERR

	& man(manAddr)
		
	curArg = argBegin
	repeat
		theTitle$ = nargv$[curArg]
		gosub FindManual
		curArg = curArg + 1
	until curArg = nargc

	gosub DumpTools
goto Exit

ShowUsage:
	print "Usage: " argv$[0] " [-adp] [-l length] [-w width] [section] title ..."
goto Exit

FindManual:
	found = FALSE
	curDir = 1
	repeat
		& pos (curDir, order$, ":"), p
		if not p then p = orderLen + 1
		tag$ = "." + mid$(order$, curDir, p - curDir)
		curDir = p + 1
		manFile$ = MAN_PATH + "man" + tag$ + "/" + theTitle$
		if not star then manFile$ = manFile$ + tag$
		& getinfo manFile$, i$
		if i$ > "" then
			found = TRUE
			gosub ShowManual
			if not all then return
		endif
	until curDir > orderLen
	if found then return

	manFile$ = MAN_PATH + "index"
	fOpen manFile$
	fRead manFile$
	onerr goto indexEOF
	do
		& get a$
		if a$ > "" then
			& pos (a$, " "), p
			if theTitle$ = left$(a$, p - 1) then
				& spc (mid$(a$, p + 1)), theTitle$
				fClose manFile$
				goto FindManual
			endif
		endif
	loop
	indexEOF:
	& onerr
	fClose manFile$
	print argv$[0]": no entry for " theTitle$
return


ShowManual:
	if progress then
		& lcase(manFile$)
		& print argv$[0]": processing " manFile$
	endif

	title$ = "Untitled"
	date$ = "No Date"
	cp = 0
	ln = 0
	ti = 5
	sp = 0
	inp = 0
	uc = 95
	autoFill = TRUE

	if not pageWidth then pageWidth = 79
	if not pageLen then pageLen = 57

	if printerMode then
		lMargin = 10
		wd = pageWidth - 10
	else
		lMargin = 0
		wd = pageWidth
	endif
	mm = lMargin

	if not openedFile and outputFile$ > "" then 
		fAppend outputFile$
		openedFile = TRUE
	endif

	fFre
	fOpen manFile$
	onerr goto mfEOF

	do
		again:
		fRead manFile$
		repeat
			& get a$
		until a$ > ""
		if openedFile then fWrite outputFile$
		if asc(a$) <> 46 then
			gosub printString
			goto again
		endif

		& pos (cm$, left$ (a$,3)),p
		if not p then goto again

		a$ = mid$ (a$,5)
		i = val (a$)
		on p / 3 gosub cmdTH, cmdDA, cmdLM, \
			cmdRM, cmdPP, cmdCN, cmdSP, \
			cmdRC, cmdBR, cmdAF, cmdUC, cmdNP, \
			cmdIF, cmdIP, cmdSH, cmdTB
	loop

	mfEOF:
	onerr goto manERR
	& onerr e,l
	fClose manFile$
	if e <> 5 then goto manERR
	
	if openedFile then fWrite outputFile$

	if ln then
		if printerMode then 
			gosub cmdNP
		else
			ln = pageLen
			gosub doBreak
		endif
	endif
return


doHeader:
	for i = 1 to printerMode * 3
		print 
	next 
	ln = 2
	& left$ (title$, wd - len (title$) - mm - 1),i$
	i$ = i$ + title$
	& mid$ (i$, wd / 2 - len (header$) / 2 - mm / 2 + 1) = header$
	print spc(mm)i$
	ln = 2
	fFre
	if openedFile then fWrite outputFile$

doBreak:
	if ln then 
		print 
		ln = ln + 1
	endif
	if ln > pageLen then 
		pg = pg + 1
		& time(t$)
		& left$ ("Revised " + date$,wd - 17 - mm - 1),i$
		i$ = i$ + "Printed" + mid$ (t$,5,10)
		& mid$(i$,wd / 2 - len(str$(pg)) / 2 - mm / 2 + 1) = str$ (pg)
		print 
		print spc(mm)i$
		ln = 0
		i$ = "^M"
		repeatCount = 1 + 3 * printerMode
		gosub repeatChar
	endif
	cp = 0
	sp = 0
return 


printString:
	if not autoFill then 
		on not ln gosub doHeader
		gosub indentToMargin
		print a$;
		goto doBreak
	endif

displayLine:
	if not ln then gosub doHeader
	gosub indentToMargin

	while a$ > ""
		call manAddr, printerMode, openedFile, uc, wd, cp, sp, a$, \
			wf, cp, sp, a$
		if wf then 
			gosub doBreak
			nn = inp
			goto displayLine
		endif
	wend
return


indentToMargin:
	im = lMargin + ti + nn
	if cp < im then 
		print spc(im - cp)
		cp = im
		sp = 0
	endif
return 

	
' --------------------
' dot functions
' --------------------


cmdTH:
	& pos(a$, " "), q
	if not q then
		title$ = a$
	else
		title$ = left$(a$, q - 1) + "(" + mid$(a$, q + 1) + ")"
	endif
return

cmdDA:
	date$ = a$
return 

cmdLM:
	lMargin = lMargin + i
return 

cmdRM:
	wd = wd + i
return 

cmdPP:
	gosub cmdIF2
	nn = 0
	on cp > 0 gosub doBreak
	if a$ > "" then 
		gosub doBreak
		gosub displayLine
		if ip then 
			ip = 0
			nn = inp
			return 
		endif
	endif
goto doBreak


cmdCN:
	gosub indentToMargin
	i = wd / 2 + lMargin / 2 - len (a$) / 2 - cp
	print spc(i)a$;
goto doBreak

cmdSP:
	a$ = "  "
	if not i then i = 1
cmdRC:
	if not i then i = wd
	if cp + i > wd then i = wd - cp
	& pos (a$," "),p
	a$ = mid$ (a$,p + 1)
	gosub indentToMargin
	i$ = a$
	repeatCount = i
	gosub repeatChar
	cp = cp + i
	sp = 0
return 

cmdBR:
	for j = 1 to i
		gosub doBreak
	next 
return 

cmdAF:
	if a$ = "" then
		autoFill = not autoFill
	else
		autoFill = i
	endif
return 

cmdUC:
	uc = 0
	if a$ > "" then uc = asc (a$)
return 

cmdIF2:
	if 2 + ln >= pageLen then goto cmdNP
return

cmdIF:
	if i + ln < pageLen then return 

cmdNP:
	& rept
		gosub doBreak
	& until(not ln)
return 


cmdIP:
	gosub cmdIF2
	& pos (a$," "),ip
	if ip then 
		i = val ( left$ (a$,ip))
		a$ = mid$ (a$,ip + 1)
	else
		a$ = ""
	endif
	inp = i
	gosub cmdPP
	nn = inp
return 


cmdSH:
	it = ti
	ti = 0
	gosub cmdPP
	ti = it
return 


cmdTB:
	i = i + lMargin
	if i < cp then return
	print spc(i - cp)
	cp = i
return 


repeatChar:
	for j = 1 to repeatCount
		print i$;
	next 
return 

DumpTools:
	fClose
	& load fre Man_ID
return

manHUP:
	gosub DumpTools
goto Logout

manINT:
	gosub DumpTools
goto Interrupt

manERR:
	gosub DumpTools
goto HandleError


#include <proline/proline.lib>
#include <proline/access.lib>
#include <proline/getopt.lib>
