' **********************************************************************
' ***
' ***   uudecode.b      Decodes files mailed from remote systems
' ***                   (C)opyright 1994 Morgan Davis Group
' ***
' ***   Based on uudecode.c 5.1 (Berkeley) 7/2/83
' ***

#define IDENT_PROG "uudecode"
#define IDENT_VERS "3.0"
#define IDENT_DATE "20jan94"
#define	IDENT_NAME "Morgan_Davis"

#include <proline/proline.h>
#include <prodos.h>

#declare info$, inref, AccOK, AccFile$, AccMode, argc, argv$, SysInfo$
#declare p, q, outref, a$, newName$

#define	decode	$300

' ====================
' main
' ====================

        gosub AppInit

        if argc < 2 then
                print "Usage: " argv$[0] " infile"
                goto Exit
        endif

	AccFile$ = argv$[1]
	AccMode = accRead
	gosub CheckAccess
       	& getinfo argv$[1], info$
       	if info$ = "" or not AccOK then
       		print argv$[0] ": can't open " argv$[1]
		goto Exit
       	endif

	& poke decode, \
	    $20,$4C,$E7,$8E,$B7,$03,$20,$4C,$E7,$8E,$BF,$03,$20,$00,$BF,$CA,\
	    $B6,$03,$90,$03,$4C,$48,$03,$AD,$BC,$03,$C9,$03,$B0,$01,$60,$AD,\
	    $80,$02,$20,$B0,$03,$85,$03,$A0,$01,$A2,$00,$20,$4E,$03,$C8,$C8,\
	    $C8,$C8,$38,$A5,$03,$E9,$03,$30,$04,$85,$03,$D0,$EE,$8E,$C2,$03
	& poke decode + 64, \
	    $20,$00,$BF,$CB,$BE,$03,$90,$C4,$20,$8B,$BE,$4C,$09,$BE,$B9,$80,\
	    $02,$20,$B0,$03,$0A,$0A,$85,$00,$B9,$81,$02,$20,$B0,$03,$4A,$4A,\
	    $4A,$4A,$05,$00,$85,$00,$B9,$81,$02,$20,$B0,$03,$0A,$0A,$0A,$0A,\
	    $85,$01,$B9,$82,$02,$20,$B0,$03,$4A,$4A,$05,$01,$85,$01,$B9,$82
	& poke decode + 128, \
	    $02,$20,$B0,$03,$0A,$0A,$0A,$0A,$0A,$0A,$85,$02,$B9,$83,$02,$20,\
	    $B0,$03,$05,$02,$85,$02,$A5,$00,$38,$20,$A7,$03,$C9,$02,$A5,$01,\
	    $20,$A7,$03,$C9,$03,$A5,$02,$90,$04,$9D,$C0,$02,$E8,$A5,$03,$60,\
	    $38,$E9,$20,$29,$3F,$60,$04,$00,$80,$02,$40,$00,$00,$00,$04,$00
	& poke decode + 192, \
	    $C0,$02,$40,$00,$00,$00
  	
	fOpen argv$[1] ",T" asc(mid$(info$, 5, 1))
	inref = peek(_OREFNUM)
	fRead argv$[1]
	onerr goto uudEOF
	repeat
		& get a$
	until left$(a$, 6) = "begin "
	onerr goto HandleError
	goto uudgo

	uudEOF:
	onerr goto HandleError
	fClose
	print "No begin line"
	goto Exit

	uudgo:
	& pos (8, a$, " "), p
	& pos (p + 1, a$ + " ", " "), q
	AccFile$ = mid$(a$, p + 1, q - p - 1)
	newName$ = AccFile$
	gosub _FixName
	if newName$ <> AccFile$ then
		& print argv$[0]": " AccFile$ " -> " newName$
		AccFile$ = newName$
	endif
       	& getinfo AccFile$, info$
	AccMode = accWrite + (accDestroy * (info$ > ""))
	gosub CheckAccess
       	if not AccOK then
       		print argv$[0] ": can't create " AccFile$
		goto Exit
       	endif
       	if info$ > "" then fDelete AccFile$
       	fCreate AccFile$ ",T6"
       	fOpen AccFile$ ",T6"
       	outref = peek(_OREFNUM)
	call decode, inref, outref
	fClose AccFile$
	fRead argv$[1]
	& get a$
	if a$ <> "end" then print "No end line"
	fClose
goto Exit

#include <proline/proline.lib>
#include <proline/access.lib>
#include <proline/fixname.lib>

#if 0
*
* uudecode.c    5.1 (Berkeley) 7/2/83
*
* uudecode [input] output
*
* decode a file so it can be mailed to a remote system.
*

        longa   off
        longi   off
        copy    2/ainclude/mega2.equ
        mcopy   2/ainclude/handy.mac

        org     $300

uudec   start

len     equ     $03
inbuf   equ     $280
insize  equ     64
outbuf  equ     inbuf+insize
outsize equ     64

        jsr     combyte
        stx     inref
        jsr     combyte
        stx     outref

decode  domli   READ,readpb,goterr
        lda     n
        cmp     #3              ;end of data?
        bcs     dodec           ;not yet

decrts  rts

dodec   lda     inbuf
        jsr     dec
        sta     len

        ldy     #1
        ldx     #0
loop    jsr     outdec
        iny
        iny
        iny
        iny
        sec
        lda     len
        sbc     #3
        bmi     dowrt
        sta     len
        bne     loop

dowrt   stx     wrn
        dos     WRITE,writepb
        bcc     decode

goterr  jsr     $be8b   ;(badcall)
        jmp     errout

*
* output one group of 3 bytes, pointed at by p, on file f.
*

c1      equ     $00
c2      equ     $01
c3      equ     $02

; c1 = DEC(*p) << 2 | DEC(p[1]) >> 4;

outdec  lda     inbuf,y
        jsr     dec
        asl     a
        asl     a
        sta     c1
        lda     inbuf+1,y
        jsr     dec
        lsr     a
        lsr     a
        lsr     a
        lsr     a
        ora     c1
        sta     c1

; c2 = DEC(p[1]) << 4 | DEC(p[2]) >> 2;

        lda     inbuf+1,y
        jsr     dec
        asl     a
        asl     a
        asl     a
        asl     a
        sta     c2
        lda     inbuf+2,y
        jsr     dec
        lsr     a
        lsr     a
        ora     c2
        sta     c2
                
; c3 = DEC(p[2]) << 6 | DEC(p[3]);

        lda     inbuf+2,y
        jsr     dec
        asl     a
        asl     a
        asl     a
        asl     a
        asl     a
        asl     a
        sta     c3
        lda     inbuf+3,y
        jsr     dec
        ora     c3
        sta     c3

        lda     c1
        sec
        jsr     writeit
        cmp     #2
        lda     c2
        jsr     writeit
        cmp     #3
        lda     c3
writeit bcc     wirts
        sta     outbuf,x
        inx
wirts   lda     len
        rts

dec     sec
        sbc     #' '
        and     #$3f
        rts

readpb  dc      h'04'
inref   ds      1
        dc      i'inbuf'
        dc      i'insize'
n       ds      2

writepb dc      h'04'
outref  ds      1
        dc      i'outbuf'
wrn     dc      i'outsize'
        ds      2

        end
#endif
