' **********************************************************************
' ***
' ***	split.b		Splits files into pieces
' ***			(C)opyright 1994 Morgan Davis Group
' ***
' ***

#define IDENT_PROG "split"
#define IDENT_VERS "1.2"
#define IDENT_DATE "16may92"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <proline/proline.h>

	gosub AppInit
	if argc < 2 then
		print "Usage: " argv$[0] " [ -lines ] file [ name ]"
		goto Exit
	endif

	lines = val(argv$[1])
	if not lines
		optind = 1
		lines = 1000
	else
		optind = 2
		lines = abs(lines)
	endif

	src$ = argv$[optind]
	optind = optind + 1
	if optind = argc then
		name$ = "x"
	else
		name$ = argv$[optind]
	endif
	
	& GETINFO src$,i$
	if i$ = "" then 
		print argv$[0]": can't find " src$
		goto ExitError
	endif

	type = asc(mid$(i$,5))

	AccFile$ = src$
	AccMode = accRead
	gosub CheckAccess
	if not AccOK then
		print argv$[0]": can't read " src$
		goto ExitError
	endif

	AccFile$ = name$
	AccMode = accWrite
	gosub CheckAccess
	if not AccOK then
		print argv$[0]": can't write to " AccFile$
		goto ExitError
	endif

	tag1 = 65
	tag2 = 65

	onerr goto srcEOF
	fOpen src$ ",T" type
	do
		segment$ = name$ + chr$(tag1) + chr$(tag2)
		& getinfo segment$, i$
		if i$ > "" then
			fClose
			& print argv$[0] ": " segment$ " exists!"
			goto ExitError
		endif

		fOpen segment$
		for i = 1 to lines
			fRead src$
			& get a$
			fWrite segment$
			print a$
		next
		fClose segment$

		tag2 = tag2 + 1
		if tag2 > 90 then
			tag1 = tag1 + 1
			tag2 = 65
		endif
	loop
	srcEOF:
	fClose
goto Exit

#include <proline/proline.lib>
#include <proline/access.lib>
