' *****************************************************************************
' *
' *	shparse.b	Shell parsing utilities
' *			(C)opyright 1994 Morgan Davis Group
' *
' * When      Who Ver   Description
' * ========= === ===== =======================================================

' =============================================================================
'				P A R S E R S
' =============================================================================	

LoadParser:
	& load get ParserPath$, i
	if i and i <> 19 then
		print ParserPath$ "?"
		goto ExitError
	endif
return


FullParse:
	ParseBackslashes(CommandLine$, CommandLine$)
	p = 0
	repeat
		p = p + 1
		& pos (p, CommandLine$, q$), q
		& pos (p, CommandLine$ + ";", ";"), j
		& pos (p, CommandLine$, "#"), i
		if i and (i < j) and (i < q or not q) then
			j = i
			CommandLine$ = mid$(CommandLine$, 1, j - 1)
		else
			if q then
				& pos (q + 1, CommandLine$, q$), p
				if not p then
					i$ = "Missing quote"
					goto StdErrMsg
				endif
				if j > q then j = 0
			endif
		endif
	until j

	& spc(mid$(CommandLine$, 1, j - 1)), theCommand$
	& spc(mid$(CommandLine$, j + 1)), CommandLine$

#ifndef PLUSH_COMMANDS
	if skipLevel% then
		ParseQuotes(SHPARSE_QUOTE, theCommand$, theCommand$)
		ParseSpaces(theCommand$, theCommand$)
		return
	endif
#endif

ParseVar:
	& pos right$ (theCommand$,"$"),p
	if p then
		ParseVarLen(mid$(theCommand$, p + 1), i)
		if i or mid$(theCommand$,p + 1, 1) = "/" then
			i$ = mid$(theCommand$, p + 1, i + not i)
			k = len(i$)
#ifdef PLUSH_COMMANDS
			gosub plushVar	' Do plush variable lookup
#else
			j = VAR_SLASH
			i% = varsDefined%
			gosub findVar
			if q then
				if q = VAR_DATE then
					gosub UpdateDate
				else
					if q = VAR_CWD then
						gosub UpdateCWD
					else
						if q = VAR_TIME then gosub UpdateTime
					endif
				endif
				i$ = mid$(var$[q], k + 2)
				if mid$(theCommand$, p + k + 1,1) = "[" then
					i% = val(mid$(theCommand$, p + k + 2))
					k = k + 3 + (i% > 9)
					gosub GetItem
					i$ = a$
				endif
				theCommand$ = mid$ (theCommand$, 1, p - 1) + i$ + mid$(theCommand$, p + k + 1)
			else
				pop
				goto UndefdVar
			endif
#endif PLUSH_COMMANDS
			goto ParseVar
		endif
	endif

	ParseQuotes(SHPARSE_QUOTE, theCommand$, theCommand$)
	ParseSpaces(theCommand$, theCommand$)
	ParseControls(theCommand$, theCommand$)

ParseHome:
	& pos (theCommand$, "~"), p
	if p then
		' ~ = $HOME
		' ~foo = $/usr/foo
		i$ = mid$(theCommand$, p + 1)
		i = len(i$)
		if i then
			ParseVarLen(i$, i)
		endif
		if not i then
			i$ = ID$[uHome]
		else
			i$ = USR_PATH + mid$(theCommand$, p + 1, i)
		endif
		theCommand$ = mid$(theCommand$, 1, p - 1) + \
			i$ + mid$(theCommand$, p + i + 1)
		goto ParseHome
	endif
return

