' ************************************************************************
' **									**
' **  setenv.b 		Setup user's environment			**
' **			(C)opyright 1994 Morgan Davis Group		**
' **									**
' ** When    Who Ver	What						**
' ** ======= === ======	==============================================  **
' ** 23sep90 mwd 1.2	Converted to MD-BASIC.				**
' ** 21feb92 mwd 1.3	Updated for 2.0 layout				**
' ** 24feb94 mwd 3.0	Removed plush env (var) file munging
' ** 14may94 mwd	Added -u option to specify user
' **									**
' ************************************************************************

#define IDENT_PROG "setenv"
#define IDENT_VERS "3.0"
#define IDENT_DATE "14may94"
#define	IDENT_NAME "Morgan_Davis"


#include <basic.h>
#include <proline/proline.h>

' ====================
' Main
' ====================

	gosub AppInit

	theUser$ = ID$[uName]		' Default to current user
	
	options$ = "?u:"
	optchar$ = ""
	repeat
		gosub getopt
		if optchar$ = "u" and SuperUser then theUser$ = optarg$
		if optchar$ = "?" then
			print "Usage: " argv$[0] " [ -u user ]"
			goto ExitError
		endif
	until optchar$ = ""
	
	env$ = ADM_PATH + theUser$ + "/environs"

	cancelKey	= peek(sttyCancel)
	nullCount	= peek(sttyNulls)
	tabSupport	= peek(sttyTabs)
	
	termcap$	= "tty"
	paging		= TRUE
	screenLen	= 24
	screenWidth	= 80
	menuMode	= TRUE
	hotkeys		= TRUE
	tb$[FALSE]	= "Preserved"
	tb$[TRUE]	= "Expanded"
	y$[FALSE]	= "No"
	y$[TRUE]	= "Yes"
	o$[FALSE]	= "Off"
	o$[TRUE]	= "On"

	dim termcap$[40]

	& GETINFO env$,envInfo$
	if envInfo$ > "" then 
		fOpen env$
		fRead env$
		input	env, \
			cancelKey, \
			nullCount, \
			tabSupport, \
			dummy1, \
			dummy2, \
			screenLen, \
			screenWidth, \
			paging, \
			termcap$, \
			menuMode, \
			hotkeys, \
			ID$[uEditor]
		fClose
	endif

	do
		& ioctl(ioClearScreen)
		print
		print "			  ProLine Environment Editor"
		print
		print
		cancelKey$ = "Control-" + chr$(64 + cancelKey)
		if cancelKey = 127 then cancelKey$ = "Delete"
		if cancelKey = 27 then cancelKey$ = "Escape"
		print "Terminal settings for " theUser$ ":"
		print 
		print "   1. Cancel key:^I"	cancelKey$
		print "   2. Tabs are:^I^I"	tb$[tabSupport]
		print "   3. Nulls:^I^I"	nullCount
		print "   4. Screen height:^I"	screenLen" lines"
		print "   5. Screen width:^I"	screenWidth" columns"
		print "   6. --More-- paging:^I"y$[paging]
		print "   7. Terminal:^I^I"	termcap$
		print "   8. Menu mode:^I"	o$[menuMode]
		print "   9. Hot-key mode:^I"	o$[hotkeys]
		print "  10. Text editor:^I"	ID$[uEditor]
		env = 12

		print 
		& read (2),"Number to change (Q to quit): ",i$
		print 
		& lcase (i$)
		if i$ = "q" then goto Quit

		i = abs(val(i$))
		changed = TRUE

		on i gosub setCancel, setTabs, setNulls, \
			setHeight, setWidth, setPaging, setEmul, setMenu, \
			setHotKey, setEditor
	loop


setEditor:
	editorList$[1] = "ed"
	editorList$[2] = "edit"
	editorList$[3] = "vedit"
	print "1. ed..........Standard UNIX editor"
	print "2. edit........ProLine text editor"
	print "3. vedit.......Visual full-screen editor"
	print
	& read (1), "Editor to use (1-3): ", i$
	i = val(i$)
	if not i or (i > 3) then goto setEditor
	ID$[uEditor] = editorList$[i]
return


setCancel:
	& int stop 
	print "Type your new cancel key now -> ";
	get a$
	& int on 
	i = asc (a$)
	if not i or i = 8 or i = 9 or i = 13 or i = 19 or i = 23 or \
		(i > 31 and i < 127) then 
		print "INVALID KEY"
		goto setCancel
	endif
	cancelKey = i
return 

setTabs:
	tabSupport = not tabSupport
return 

setNulls:
	& read (3),"Number of nulls after C/R: ",i$
	i = abs (val (i$))
	if i < 256 then nullCount = i
return 

setHeight:
	& read (2),"Screen height in lines (4-99): ",i$
	i = abs (val (i$))
	if i < 4 then 
		print "Too few lines.  Must be at least 4."
		goto setHeight
	endif
	screenLen = i
return 

setWidth:
	& read (3),"Screen width in columns (40, 80, 132): ",i$
	i = abs (val (i$))
	if i < 40 then 
		print "Too few columns.  Must be at least 40."
		goto setWidth
	endif
	if i > 132 then 
		print "Too many columns.  Can't exceed 132."
		goto setWidth
	endif
	screenWidth = i
return 

setPaging:
	paging = not paging
return 

setEmul:
	if not termCount then
		& files(SYS_PATH + "termcaps", termcap$, 0), termCount
		& sort (termcap$, termCount)
	endif
	j = 0
	for i = 1 to termCount
		& lcase (termcap$[i])
		j = j + 1
		& right$(str$(i), 2), a$
		a$ = a$ + ". " + termcap$[i]
		print a$;
		if j < 3 then & str$ (1 + (24 - len(a$)) / 8, 9)
		if j = 3 then 
			print 
			j = 0
		endif
	next 
	print 
	if j then print 

	print "Terminal to emulate (1-" termCount "): ";
	& read (2), i$
	i = abs(val(i$))
	if not i or (i > termCount) then 
		print 
		goto setEmul
	endif
	termcap$ = termcap$[i]
	termUpdate = TRUE
return 

setMenu:
	menuMode = not menuMode
return 

setHotKey:
	hotkeys = not hotkeys
return 



Quit:
	if not changed then 
		print "No changes made."
		goto Exit
	endif


	poke sttyCancel, cancelKey
	poke sttyNulls, nullCount
	poke sttyTabs, tabSupport
	
	& int = cancelKey
	& nulls (nullCount)
	& tab (tabSupport)

	& page len screenLen
	if paging then
		& page on
	else
		& page stop 
	endif

	if termUpdate then
		fBload SYS_PATH "termcaps/" termcap$ ",T0,A768"
		& tset(768)
		& ioctl(ioNormal)
		& ioctl(ioInsertOff)
		& ioctl(ioULOff)
		& ioctl(ioClearScreen)
	endif
	print 

	&store  ID$[uName] + ":" + ID$[uUID] + ":" + ID$[uGID] + ":" + \
		ID$[uFullName] + ":" + ID$[uHome] + ":" + \
		ID$[uCallerID] + ":" + ID$[uEditor] to UserID_Cell
	
	print "Environment updated.";
	if ID$[uGID] = "3" then goto Interrupt

	print "  Recording new settings...";

	if envInfo$ > "" then fDelete env$
	fOpen env$
	fWrite env$
		print env
		print cancelKey
		print nullCount
		print tabSupport
		print dummy1
		print dummy2
		print screenLen
		print screenWidth
		print paging
		print termcap$
		print menuMode
		print hotkeys
		print ID$[uEditor]
	fClose
	print "saved."
	print "(Note: Some changes may take affect on your next session)"

goto Exit

#include <proline/proline.lib>
#include <proline/getopt.lib>
