' ************************************************************************
' **
' **  rmdir.b		Remove directories and their contents
' **			(C)opyright 1994 Morgan Davis Group
' **
' ** When    Who Ver	What
' ** ======= === ======	==============================================
' ** 09sep93 mwd 2.0	Created from rmuser.b source
' **
' ************************************************************************

#define IDENT_PROG "rmdir"
#define IDENT_VERS "2.0"
#define IDENT_DATE "9sep93"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <proline/proline.h>

#define	MAX_FILES	64

' ****************************************
' **
' ** main
' **
' **

	gosub AppInit
	options$ = "?ps"
	optchar$ = ""
	repeat
		gosub getopt
		if optchar$ = "?" then showUsage = TRUE
		if optchar$ = "p" then progress% = TRUE
		if optchar$ = "s" then saveDir% = TRUE
	until optchar$ = ""
	
	if showUsage or (nargc < 2) then
		print "Usage: "argv$[0]" [-ps] dir..."
		goto Exit
	endif

	dim file$[MAX_FILES]

	for i = 1 to nargc - 1
		f$ = nargv$[i]
		gosub KillDirectory
	next
goto Exit


KillFile:
	onerr goto kfErr
	killed% = FALSE
	fDelete k$
	killed% = TRUE
	kfErr:
	onerr goto HandleError
	if not killed% then &onerr
	if progress% and killed% then
		& lcase(k$)
		&print argv$[0]": removed " k$
	endif
return 


KillDirectory:
	if right$(f$, 1) = "/" then f$ = left$(f$, len(f$) - 1)
	AccFile$ = f$
	accMode = accDelete
	gosub CheckAccess
	if not accOK then
		&print argv$[0]": can't remove " f$
		ExitStatus% = -1
		return
	endif
	& GETINFO f$, i$
	if i$ = "" then return
	if progress% then &print argv$[0]": removing " f$
nextDir:
	i$ = f$
rmDir:	
	& files (i$, file$, , VIS_AND_INVIS), nf, actualFiles
	if not nf then
		on i$ <> f$ goto nextDir
		if not saveDir% then
			fUnlock f$
			fDelete f$
			if progress% then &print argv$[0]": removed " f$
		else
			if progress% then &print argv$[0]": spared " f$
		endif
		return 
	endif

	i = 1
	repeat
		k$ = i$ + "/" + file$[i]
		gosub KillFile
		if not killed% then
			& GETINFO k$, j$
			if asc(mid$(j$, 4)) < 128 then
				fUnlock k$
				gosub KillFile
			endif
			if not killed% then
				if asc (mid$ (j$,5)) = 15 then
					i$ = k$
					goto rmDir
				else
					print argv$[0]": can't remove " k$
					goto Exit
				endif
			endif
		endif
		i = i + 1
	until i > nf
	if nf < actualFiles then goto rmDir
goto nextDir

#include <proline/proline.lib>
#include <proline/access.lib>
#include <proline/getopt.lib>
