' _____________________________________________________________________
'|                                                                     |
'|                  Resume File Generator Version 1.2.2                |
'|                   By Bob Lindabury (pro-graphics)                   |
'|                    Modified by dean@pro-electric                    |
'|                                                                     |
'|                             resume.b                                |
'|_____________________________________________________________________|

#define IDENT_PROG "resume"
#define IDENT_VERS "1.2.2"
#define IDENT_DATE "28mar92"
#define	IDENT_NAME "Bob_Lindabury_&_Dean_Fick"

' Dean Fick modified this on 6/17/91.  Removed the '.' before the name
' of the resume file and changed the output prompts a bit.
'
' Dean further modified the program on 10/31/91, adding options requested
' by Bob Lindabury.  Also made some internal changes to source code not
' affecting visible operation.
'
' Minor change 3/28/92 by Dean; removed the opening ^M when making resume
' file, added ^M at end of resume file.

#include <proline/proline.h>

' ****************************************************************
' **
' ** Main Program
' **
' **

     gosub AppInit

     & ioctl [ioClearScreen]

     RsrcFile$ = RSRC_PATH + "resume.rsrc"

     & getinfo RsrcFile$, Info$
     if Info$ = "" then
          print argv$[0] ": " RsrcFile$ " not found"
          goto Exit
     endif
     fOpen RsrcFile$
     fRead RsrcFile$

     input Maximum

     dim Question$[Maximum]
     dim Answer$[Maximum]

     & get Title$

     for Count = 1 TO Maximum
          & get Question$[Count]
     next

     fClose RsrcFile$

     & ioctl [ioClearScreen]

     print "--------------------"
     print "Resume File Module"
     print "Ver. 1.2.3  3/28/92"
     print "--------------------^M"
     print "Answering the following questions is optional.  The information"
     print "you provide will be visible to other users.  What you enter will"
     print "in no way affect your status here at "SysInfo$[plNode]".^M"
     print Title$ "^M"
     print "There are "Maximum" questions.^M"
     print "Continue";

     gosub GetAnswer

     if yn$ = "n" then goto Aborted

ShowQuestions:
     for Count = 1 TO Maximum

DoQuestion:
          & ioctl[ioClearScreen]
          print "Question #"Count"^M"
          print Question$[Count]
          & str$ (len (Question$[Count]), 45)
          print chr$(13)
          & read (55),"Response: ",Answer$[Count]
          & spc (Answer$[Count]), Answer$[Count]
          if len (Answer$[Count]) = 0 then goto DoQuestion
     next

     & ioctl[ioClearScreen]
     for Count = 1 to Maximum
          print Question$[Count] " " Answer$[Count]
     next

     print "^MAll correct";
     gosub GetAnswer
     if yn$ = "n" then
          print "^MQuit";
          gosub GetAnswer
          if yn$ = "y" then
               goto aborted
          else
               goto ShowQuestions
          endif
     endif

     print "^MThanks!^M"

     outFile$ = ID$[uHome] + "/resume"

     & getinfo outFile$, FileInfo$

     if FileInfo$ = "" then
          print "Writing new resume file...";
          goto WriteResumeFile
     else
          print "You already have a resume file!"
          gosub FileExistChoice
     endif

     if I$ = "C" then
          print "^MCancelled. ^M"
          goto Exit
     endif

     if I$ = "A" then
          print "^MAppending your current resume file...";
     else
          print "^MOverwriting your old resume file...";
          fDelete outFile$
     endif

WriteResumeFile:
     fAppend outFile$
     & time (Time$)
     print ID$[uFullName] " (" ID$[uName] "@" SysInfo$[plNode]\
     ") - Updated: " Time$"^M"
     for Count = 1 to Maximum
          print Question$[Count] "  " Answer$[Count]
     next
     print
     fClose outFile$
     print "done!^M"
     goto Exit


' ****************************************************************
' **
' ** Loop until user inputs Y or N.  Echo it when found.
' **
' **

GetAnswer:
     print "? (y/n) ";
     repeat
          get yn$
          & lcase (yn$)
     until yn$ = "y" or yn$  = "n"
     print yn$
return

' ****************************************************************
' **
' ** Print abort message and exit.
' **
' **

Aborted:
     print "^MAborted.  Please leave some information next time.  Thanks!^M"
     goto Exit

' ****************************************************************
' **
' ** Loop until user enters A, O, or C.
' **
' **

FileExistChoice:
     repeat
          print "^MAppend, Overwrite or Cancel? (A/O/C) ";
          get I$
          & ucase (I$)
          print I$
          & pos ("AOC", I$), p
     until p
     return

' ****************************************************************
' **
' **
' ** Standard ProLine library routines
' **

#include <proline/proline.lib>
