' ************************************************************************
' **
' **  news.b		System news utility
' **			(C)opyright 1993 Morgan Davis Group
' **
' ** When    Who Ver	What
' ** ======= === ======	==============================================
' ** 19oct93 mwd 2.1	Converted to MD-BASIC from old 1.2 1988 program.
' **
' ************************************************************************

#define	IDENT_PROG "news"
#define	IDENT_VERS "3.0"
#define	IDENT_DATE "6may94"
#define	IDENT_NAME "Morgan_Davis"

#include <proline/proline.h>

#define	MAX_NEWS_FILES	100
#define	USAGE		"[ -acinsw ] [ -t item ] [ items... ]"
#define	WORLD_NEWS	ETC_PATH "mcinews"
#define	NUMBERS		"-,0123456789"
#define	EDITING		"^M^H^?"
#define	VERBS		"^Mdelhanpqtu?+-"
#define	ARGS		"^Macflnp?"

	gosub AppInit

	newstmpFile$	= TEMP_PATH + "newstmp"

	if ReturnFlag% then
		& getinfo newstmpFile$, i$
		if i$ > "" then
			fRestore newstmpFile$
			fDelete newstmpFile$
			goto topLevelEntry
		endif
	endif
	
	newsDir$	= NEWS_PATH
	utmpFile$	= TEMP_PATH + "utmp"
	s$[TRUE]	= "s"
	dim fileList$[MAX_NEWS_FILES]

	options$ = "?acinst:w"
	optchar$ = ""
	repeat
		gosub getopt
		if optchar$ = "?" then showUsage% = TRUE
		if optchar$ = "a" then printAll% = TRUE
		if optchar$ = "c" then mustRead% = TRUE
		if optchar$ = "n" then gosub listItems
		if optchar$ = "s" then gosub printCount
		if optchar$ = "i" then interactive% = TRUE
		if optchar$ = "t" then gosub touchItem
		if optchar$ = "w" then gosub showWorldNews
	until optchar$ = ""
	
	if showUsage% then
		& print "Usage: " argv$[0] " " USAGE
		goto Exit
	endif

	if not interactive% then
		if mustRead% then & int stop
		if nargc > 1 then
			gosub selectiveUpdate
		else
			gosub newsUpdate
		endif
		& int on
		goto Exit
	endif

	& ioctl(ioClearScreen)
	print "   /|   \"
	print " _/ |  \ \"
	print "(_  | ) ) |   ProLine System News " IDENT_VERS
	print "  \ |  / /"
	print "   \|   /^M^MCounting...";
	gosub printFileCount
	if not fileCount% and not SuperUser then goto Exit

topLevelEntry:
	& on int goto topLevel

topLevel:
	& pop
	print 
	do
		& pop
		print "news> ";
	prompt:
		cancel = FALSE
		get a$
		& lcase(a$)
		& pos (VERBS, a$), verb
		& pos (NUMBERS, a$), num
		if not verb and num then
			gosub completeRange
			if cancel then goto prompt
			gosub validRange
			if not cancel then gosub displayItems
		else
			if not verb and a$ <> "^H" then
				print "Type ? for help"
			endif
			on verb gosub goNext, doDelete, doEdit, doList, \
				doHeaders, doAdd, goNext, goPrev, doQuit, \
				doType, doUpdate, doHelp, doMoreOn, doMoreOff
		endif
	loop

completeRange:
	print a$;
	do
		repeat
			get i$
			& pos (NUMBERS, i$), num
			& pos (EDITING, i$), edit
		until num or edit
		if edit then
			if i$ = "^M" then goto rangeDone
			print "^H ^H";
			num = len(a$) - 1
			if num then
				a$ = mid$(a$, 1, num)
			else
				cancel = TRUE
				return
			endif
		else
			if i$ = "," or i$ = "-" then
				& pos(a$, "-"), num
				if num then
					i$ = ""
				else
					i$ = "-"
				endif
			endif
			a$ = a$ + i$
			print i$;
		endif
	loop	
rangeDone:
	s = val(a$)
	if s < 1 then s = 1
	e = s
	& pos (a$, "-"), num
	if num then e = val(mid$(a$, num + 1))
	if not e then e = fileCount%
	print
return

validRange:
	if fileCount% < e or e < s then 
		print "Items are from 1 to "fileCount%
		cancel = TRUE
	endif
return


getArg:
	cancel = FALSE
	do
		get a$
		& lcase(a$)
		& pos (ARGS, a$), arg
		& pos (NUMBERS, a$), num
		if num then
			gosub completeRange
			if cancel then goto getArg
			goto validRange
		endif
		on arg goto doCurrent, doAll, doCurrent, doFirst, doLast, \
			doNext, doPrev, doArgHelp
	loop

doMoreOn:
	print "+ More on"
	& page on
return

doMoreOff:
	print "- More off"
	& page stop
return

doCurrent:
	print "Current"
	s = np + not np
	e = np
return 

doArgHelp:
	print "Help"
	print
	print "    <F>irst     <L>ast      <N>ext      <P>revious  <A>ll"
	print "    <C>urrent   x           x-y         x-          -y"
	cancel = TRUE
return

doHelp:
	print "Help"
	& ioctl(ioClearScreen)
	print
	& list HELP_PATH + "news"
	print 
return 

doAll:
	print "All"
selectAll:
	s = 1
	e = fileCount%
return 

doFirst:
	print "First"
	s = 1
	e = 1
return 

doLast:
	print "Last"
	s = fileCount%
	e = fileCount%
return

goPrev:
	gosub doPrev
	if not cancel then goto displayItems
return

doPrev:
	print "Previous"
	if np - 1 > 0 then
		s = np - 1
	else
		cancel = TRUE
	endif
	e = s
return 

goNext:
	gosub doNext
	if not cancel then gosub displayItems
return

doNext:
	print "Next"
	if np = fileCount% then 
		cancel = TRUE
	else
		s = np + 1
	endif
	e = s
return 


doHeaders:
	print "Headers ";
	gosub getArg
	if not cancel then goto displayHeaders
return

doEdit:
	print "Edit ";
	gosub suTest
	gosub getArg
	if cancel then return

	tf$ = fileList$[s]
goto editItem


doAdd:
	print "Add ";
	gosub suTest
	if fileCount% >= MAX_NEWS_FILES then
		print "-- sorry, " MAX_NEWS_FILES " items exist."
		return
	endif
	print "new item"
	& read (30),"Subject: ",su$
	if su$ = "" then return

	print "Making item...";
	gosub curNewsTime
	fAppend newsDir$ tf$
	print "System News: " mid$ (t$,5)" -- "su$
	print
	print
	fClose

	fileCount% = fileCount% + 1
	fileList$[fileCount%] = tf$
	
editItem:
	print "Invoking editor...";
	fStore newstmpFile$
	System(ID$[uEditor] + " " + newsDir$ + tf$)


doUpdate:
	print "Update ";
	gosub suTest
	gosub getArg
	if not cancel then
		print "Wait..";
		for i = s to e
			print ".";
			newsFile$ = fileList$[i]
			gosub touchNewsFile
		next
		gosub getNewsFileCount
		print "done"
	endif
return


doList:
	print "List"
	gosub selectAll

displayHeaders:
	print
	gosub displayHeaders2
	print
return

displayHeaders2:
	if fileCount% then
		print  "  #  File         Date      Time        Subject"
'		print  " 22  n93123.0132  13 Sep 93 12:23:21 -- sdasdsa"
		for i = s to e
			f$ = newsDir$ + fileList$[i]
			fOpen f$
			fRead f$
			& get a$
			& right$(str$(i), 3), i$
			print i$ "  " fileList$[i] "  " mid$ (a$,15)
			fClose
		next
	else
		print "(No news is good news)"
	endif
return 

doType:
	print "Type ";
	gosub getArg
	if cancel then return

displayItems:
	print 
	for i = s to e
		np = i
		print "[" i " of " fileCount% "]  ";
		& list newsDir$ + fileList$[i]
		print 
	next 
return 

doDelete:
	print "Delete ";
	gosub suTest
	gosub getArg
	if not cancel then
		gosub displayHeaders
		& read (1),"OK to delete? ",a$
		& ucase(a$)
		if a$ = "Y" then 
			print "Wait..";
			for i = s to e
				print ".";
				fDelete newsDir$fileList$[i]
				np = np - (np = fileCount%)
				fileCount% = fileCount% - 1
			next
			goto printFileCount
		endif
	endif
return

printFileCount:
	gosub getNewsFileCount
	print fileCount%" item" s$[fileCount% <> 1]
return


getNewsFileCount:
	& files (newsDir$, fileList$), fileCount%
	& sort (fileList$, fileCount%)
return 


suTest:
	if not SuperUser then 
		print "is not accessible"
		pop
	endif
return 


doQuit:
	print "Quit"
goto Exit


' ====================
  printCount:
' ====================
	gosub getNewsFileCount
	print fileCount%
return


' ====================
  listItems:
' ====================
	gosub getNewsFileCount
	if fileCount% then
		gosub selectAll
		gosub displayHeaders2
	endif
return


' ====================
  touchItem:
' ====================
	if not SuperUser then
		& print argv$[0] ": can't touch"
		return
	endif

	item$ = optarg$
	gosub getNewsFileCount
	gosub findItem
	if newsFile$ = "" then return

	
' ====================
  touchNewsFile:
' ====================
	gosub curNewsTime
	fRename newsDir$ newsFile$ "," newsDir$ tf$
	fOpen newsDir$ tf$
	fWrite newsDir$ tf$
	print "System News: " mid$(t$,5);
	fClose
return 


' ====================
  findItem:
' ====================
	newsFile$ = ""
	i$ = item$
	i = val(i$)
	if i$ = str$(i) then
		if i > 0 and i <= fileCount% then newsFile$ = fileList$[i]
		return
	endif

	& lcase(i$)
	if len(i$) = 11 and left$(i$, 1) = "n" and mid$(i$, 7, 1) = "." then
		& getinfo newsDir$ + i$, a$
		if a$ > "" then newsFile$ = i$
		return
	endif

	i = 0
	repeat
		i = i + 1
		fOpen newsDir$ fileList$[i]
		fRead newsDir$ fileList$[i]
		& get a$
		fClose
		& lcase(a$)
		found = (mid$(a$, 37) = i$)
	until found or (i = fileCount%)
	if found then newsFile$ = fileList$[i]
return


' ====================
  showWorldNews:
' ====================
	i$ = WORLD_NEWS
	& getinfo i$, a$
	if a$ > "" then	& list WORLD_NEWS
return


' ====================
  curNewsTime:
' ====================
	& time(t$)
  cnnTime:
	& pos ("?anebarprayunulugepctovec", mid$ (t$, 10, 2)), mn
	mn = mn / 2
	y = val (mid$ (t$, 13, 2))
	day = 1000 * y + val (mid$("??000031059090120151181212243273304334", \
		mn * 3,3)) + val(mid$ (t$,6)) + (mn > 2 and y / 4 = int (y / 4))
	tf$ = "N" + str$(day) + "." + mid$ (t$, 16, 2) + mid$ (t$, 19, 2)
	' ex: N93365.0330
	& getinfo newsDir$ + tf$, i$
	if i$ > "" then 
		print ".";
		& wait 3
		goto curNewsTime
	endif
return 


' ====================
  newsUpdate:
' ====================
	gosub getNewsFileCount
	if fileCount% then
		fOpen utmpFile$
		fRead utmpFile$
		& get t$
		fClose
		gosub cnnTime
		for i = 1 to fileCount%
			if printAll% or (fileList$[i] > tf$) then
				& list newsDir$ + fileList$[i]
				print
				if mustRead% then & page
			endif
		next
	endif
return


' ====================
  selectiveUpdate:
' ====================
	gosub getNewsFileCount
	for x = 1 to nargc - 1
		item$ = nargv$[x]
		gosub findItem
		if newsFile$ > "" then & list newsDir$ + newsFile$
	next
return


#include <proline/proline.lib>
#include <proline/getopt.lib>

#define LAUNCH_NO_EXEC_PERM
#include <proline/launch.lib>
