' ************************************************************************
' **									**
' **  ed.b -		Standard UNIX editor				**
' **			(C)opyright 1994 Morgan Davis Group		**
' **									**
' ** When    Who Ver	What						**
' ** ======= === ======	==============================================  **
' ** 24sep90 mwd 1.0	Converted very old ed (pre-edit) to MD-BASIC.	**
' ** 07aug91 mwd 1.1	Fixed e command; didn't remember new filename	**
' **									**
' ** To do:								**
' **	Unimplemented commands: j (join), m (move), t (copy)		**
' **									**
' ************************************************************************

#define IDENT_PROG "ed"
#define IDENT_VERS "1.1"
#define IDENT_DATE "7aug91"
#define IDENT_NAME "Morgan_Davis"

#include <ctype.h>
#include <basic.h>
#include <prodos.h>
#include <appleio.h>
#include <errors.h>
#include <proline/proline.h>

#define	PRINT_CMD	16
#define	ED_CMDS		"acdeEfghHijklmnpPqQrstuvwxz=!"
#define ED_OPS		".$/?+-,;"
#define ED_OPFUNCS	pDot, pDollar, pSlash, pQuest, pPlus, pMinus, \
			pComma, pSemi
#define	ED_MOD		"11100010011101000001011100100"
#define	ED_FUNCS	eAppend, eChange, eDelete, eEdit, eEdit2, eFile, \
			eNoFunc, eHelp, eHelpMode, eInsert, eJoin, eNoFunc, \
			ePrint, eMove, eNumList, ePrint, ePrompt, eQuit, \
			eExit, eRead, eSub, eCopy, eNoFunc, eNoFunc, \
			eWrite, eNoFunc, eScroll, eLineNum, eNoFunc

#define	msg(m)		msg$ = m : print left$(errChar$ + msg$, helpMode)

	gosub AppInit
	if argc < 2 then
		print "Usage: " argv$[0] " file"
		goto Exit
	endif

	errChar$ = "?^M"
	suSave = SuperUser
	remfile$ = argv$[1]
	c$ = remfile$
	pageCount = 22
	helpMode = 1
	& page def paging
	
	fFre
	maxlines = fre(0) / 40		' Roughly calculate maximum lines
	dim line$[maxlines + 1]

	& on int goto edintr
	& page stop

	gosub eEdit2
	goto main

edintr:	& pop 
	print
	msg("interrupt")
main:
	do
		gosub GetCommand
		on theCommand gosub ED_FUNCS
		wFlag% = wFlag% or val(mid$(ED_MOD, theCommand, 1))
		& pos ("pln", c$), p
		if p then
			a[0] = point
			a[1] = point
			gosub ePrint, ePrint, eNumList
		endif
	loop

' ====================
' Unimplemented
' ====================

eCopy:
eJoin:
eMove:
eNoFunc:
	msg("pound sand")
return


' ====================
' Help Mode
' ====================

eHelpMode:
	if helpMode = 1 then
		helpMode = 255
	else
		helpMode = 1
		return
	endif
eHelp:
	print msg$
return


' ====================
' Quit
' ====================

eQuit:
	gosub writeWarn
eExit:
	if paging then & page on
goto Exit

' ====================
' Prompt
' ====================

ePrompt:
	if c$ > "" then
		prompt$ = c$
		c$ = ""
	else
		if prompt$ = "" then
			prompt$ = "*"
		else
			prompt$ = ""
		endif
	endif
return


' ====================
' File
' ====================

eFile:
	if c$ > "" then
		gosub setTheFile
		remfile$ = theFile$
	else
		print remfile$
	endif
return


' ====================
' Edit
' ====================

eEdit:
	gosub writeWarn
eEdit2:
	if lines then
		for i = 1 to lines
			line$[i] = ""
		next
		fFre
		lines = 0
	endif
	wFlag% = FALSE
	gosub eRead
	remfile$ = theFile$
return

' --------------------
' Read
' --------------------
	
eRead:
	gosub setTheFile
	gosub CheckReadAccess
	if AccOK then
		gosub appendFile
		point = lines
	endif
return


' ====================
' Change
' ====================

eChange:
	gosub eDelete
goto eInsert


' ====================
' Delete
' ====================

eDelete:
	gosub defPoint
	if a[1] = lines then 
		lines = a[0] - 1
		s% = a[0]
		e% = a[1]
		point = lines
	else
		for i = a[1] to lines
			line$[a[0] + i - a[1]] = line$[i + 1]
		next 
		e% = lines
		lines = a[0] + (lines - a[1]) - 1
		s% = lines + 1
		point = a[0]
	endif
	for i = lines + 1 to k%
		line$[i] = ""
	next
	fFre
return 


' ====================
' Append
' ====================

eAppend:
	if a% < 0 then gosub defPoint
	if a[0] < lines then a[0] = a[0] + 1
	if a[0] = lines then
		repeat
			lines = lines + 1
			& read line$[lines]
		until line$(lines) = "." or lines = maxlines
		lines = lines - 1
		point = lines
		return
	endif

' --------------------
' Insert
' --------------------

eInsert:
	if a% < 0 then gosub defPoint
	if not a[0] then a[0] = 1
	repeat
		& read a$
		if a$ <> "." then 
			point = a[0]
			for i = lines to point step - 1
				line$[i + 1) = line$[i]
			next 
			line$[point] = a$
			a[0] = point + 1
			lines = lines + 1
		endif
	until a$ = "." or lines = maxlines
return 


' ====================
' Numbered List
' ====================

eNumList:
	gosub defPoint
	for i = a[0] to a[1]
		& print i "^I" line$[i]
	next 
	point = a[1]
return 


' ====================
' Scroll
' ====================

eScroll:
	if val(c$) then pageCount = val(c$)
	if not a[0] then a[0] = point + (point < lines)
	a[1] = a[0] + pageCount
	if a[1] > lines then a[1] = lines

' --------------------
' Print
' --------------------

ePrint:
	gosub defPoint
	for i = a[0] to a[1]
		& print line$(i)
	next
	point = a[1]
return 


' ====================
' Print Address
' ====================

eLineNum:
	if a[0] then
		print a[0]
	else
		print lines
	endif
return


' ====================
' Substitute
' ====================

eSub:
	gosub defPoint
	a$ = left$(c$, 1)
	& pos (2, c$, a$),p
	& pos (p + 1, c$, a$), q
	if not p or not q then
		msg ("`" + a$ + "' expected")
		return
	endif
	search$ = mid$(c$, 2, p - 2)
	a$ = mid$(c$, p + 1, q - p - 1)
	g% = mid$(c$, q + 1, 1) = "g"
	c$ = mid$(c$, q + 1 + g%)
	k% = 0
	for i = a[0] to a[1]
		p = 1
		repeat
			& pos (p, line$[i], search$),p
			if p then
				point = i
				line$[i] = mid$(line$[i], 1, p - 1) + a$ + \
					mid$(line$[i], p + len(search$))
				if g% then
					p = p + len(a$)
				else
					p = 0
				endif
				k% = TRUE
			endif
		until not p
	next
	if not k% then
		msg ("search string not found")
	endif
return 

' ====================
' Write
' ====================

eWrite:
	if not lines then 
		msg ("no lines")
		return 
	endif

	if c$ > "" then
		quit = left$(c$, 2) = "q "
		if quit then c$ = mid$(c$, 3)
	endif

	gosub setTheFile

	if not a[0] then a[0] = 1
	if not a[1] then a[1] = lines
	& GETINFO theFile$, i$
	errCode = peek(_ERRNUM)
	AccFile$ = theFile$
	if i$ > "" then
		type% = asc(mid$(i$,5))
		AccMode = accWrite + accDestroy
	else
		type% = 4
		AccMode = accWrite
	endif
	gosub CheckAccess
	if not AccOK or \
		(type% <> 4 and type% <> 240) or \
		(errCode = SyntaxErr) or \
		(errCode = NoSuchPathErr) then
		print "?" theFile$
		msg ("cannot create file")
		return
	endif
	if AccMode = accWrite then fCreate theFile$ ",t" type%
	fOpen theFile$ ",t" type%
	fWrite theFile$
	for i = a[0] to a[1]
		print line$[i]
	next

	fFlush theFile$
	gosub getMark
	& MLI (_SET_EOF, _SSETEOF), errCode
	fClose
	print i
	if a[0] = 1 and a[1] = lines then wFlag% = FALSE
	if quit then goto eQuit
return


' ============================================================
' CheckReadAccess -- Checks for read permission on theFile$
'	returning result in AccOK.  Also checks file type for
'	TXT or CMD, as well as non-random access text file types.
' ============================================================

CheckReadAccess:
	AccMode = accRead
	AccFile$ = theFile$
	gosub CheckAccess
	&getinfo theFile$, fileInfo$
	if AccOK and fileInfo$ > "" then
		if peek (_ERRNUM) = SyntaxErr
			AccOK = FALSE
		else
			type% = asc(mid$(fileInfo$,5))
			AccOK = (type% = 4 or type% = 240) and \
				not (asc(mid$(fileInfo$,6)) + \
				asc(mid$(fileInfo$,7)))
		endif
	endif
return


' ====================
' Get / Parse Command
' ====================

GetCommand:
	repeat
		print prompt$;
		& read c$
		&spc (c$),c$
		theCommand = 0
		a% = -1
		a[0] = 0
		a[1] = 0
		p = 1
		repeat
			gosub parseExpr
		until EOL
		if not theCommand and p > len(c$) then
			theCommand = PRINT_CMD
			if not a[0] then
				a[0] = point + 1
				a[1] = a[0]
			endif
		endif
		if a[0] < 0 or a[1] < 0 or a[0] > lines or a[1] > lines \
			or (a[1] and (a[0] > a[1])) then
			msg ("line out of range")
			theCommand = 0
		endif
	until theCommand
	&spc(mid$(c$, p)), c$

	' At this point:
	' 	theCommand is the command number
	' 	a[0] = 1st address, a[1] = 2nd
	'	c$ = remainder (arguments) of command
return
	
parseExpr:
	while mid$(c$, p, 1) = " "
		p = p + 1
	wend
	EOL = p > len(c$)
	if EOL then return

	a$ = mid$(c$, p, 1)		
	& pos (ED_OPS, a$), q
	if q then
		p = p + 1
		on q goto ED_OPFUNCS
	endif

	& pos (ED_CMDS, a$), theCommand
	if theCommand then
		p = p + 1
	else
		i$ = ""
		while mid$(c$,p,1) > "/" and mid$(c$,p,1) < ":"
			i$ = i$ + mid$(c$,p,1)
			p = p + 1
		wend
		if i$ > "" then
			a% = a% + 1
			a[a%] = val(i$)
			return
		endif
		msg ("unknown command")
	endif
	EOL = TRUE
return

pPlus:
	k = 1
	goto ppmset
pMinus:
	k = -1
ppmset:
	i = val(mid$(c$, p))
	if i then
		p = p + len(str$(i))
	else
		i = 1
	endif
	if a% < 0 then
		a% = a% + 1
		a[a%] = point
	endif
	a[a%] = a[a%] + (i * k)
return


pSemi:
	if a[0] then
		point = a[0]
		return
	endif
	i = point
	goto pscset
pComma:
	i = 1
	if a[0] then return
pscset:	a[0] = i
	a[1] = lines
	a% = 1
return


pDot:
	a% = a% + 1
	a[a%] = point
return

pDollar:
	a% = a% + 1
	a[a%] = lines
return

pSlash:
	sinc% = 1
	ss% = point + 1
	se% = lines
	sw% = 1
	goto psearch

pQuest:
	sinc% = -1
	ss% = point - 1
	se% = 1
	sw% = lines

psearch:
	&pos (p, c$, a$), q
	EOL = not q
	if q then
		a$ = mid$(c$, p, q - p)
		p = q + 1
		if a$ > "" then search$ = a$
		EOL = TRUE
		can% = se%
		for i = ss% to se% step sinc%
			gosub pfind
		next
		if EOL then
			can% = point
			for i = sw% to ss% step sinc%
				gosub pfind
			next
		endif
	endif
return
			
pfind:
	& pos (line$[i], search$), q
	if q then
		EOL = FALSE
		a% = a% + 1
		a[a%] = i
		i = can%
	endif
return


' ====================
' Utilities
' ====================

defPoint:
	if not a[0] then a[0] = point
	if not a[1] then a[1] = a[0]
return

writeWarn:
	if wFlag% then
		msg("warning: expected `w'")
		wFlag% = FALSE
		pop
	endif
return

setTheFile:
	if c$ > "" then
		&spc(c$), theFile$
		c$ = ""
	else
		theFile$ = remfile$
	endif
	if theFile$ = argv$[1] then
		SuperUser = suSave
	else
		SuperUser = ID$[uGID] = "0"
	endif
return

getMark:
	poke _SREFNUM, peek(_OREFNUM)
	& MLI (_GET_MARK, _SSETEOF), i
	i = peek(_SEOF) + peek(_SEOF + 1) * 256 + peek(_SEOF + 2) * 65536
return

appendFile:	
	if not AccOK or fileInfo$ = "" then
		msg ("cannot open input file")
		return
	endif

	onerr goto hitEOF
	fFre
	fOpen theFile$",t" type%
	fRead theFile$
	i = fre(0) - 256
	while i > 0
		lines = lines + 1
		&get line$[lines]
		repeat
			& pos (line$[lines], "^D"),p
			if p then & mid$(line$[lines], p) = "D"
		until not p
		i = i - len(line$[lines]) - 3
	wend
	errCode = 0
	goto noEOFerr

    hitEOF:
	&onerr errCode, lineNum
    noEOFerr:
	onerr goto HandleError
	gosub getMark
	fClose
	lines = lines - 1
	if errCode <> EOFErr then
		msg ("warning: buffer is full")
	endif
	print i
return
	
#include <proline/proline.lib>
#include <proline/access.lib>
