' **********************************************************************
' ***
' ***	du.b	Disk Usage
' ***		(C)opyright 1994 Morgan Davis Group
' ***

#define IDENT_PROG "du"
#define IDENT_VERS "1.1"
#define IDENT_DATE "7jun92"
#define IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <proline/proline.h>

#define	MAXFILES	512
#define	MAXDEPTH	16

	gosub AppInit

	gosub testOutput
	if accFile$ > "" then
		on not AccOK goto Exit
		if k = 1 and accMode > accWrite then fDelete accFile$
		outputFile$ = accFile$
	endif

	options$ = "as?"
	optchar$ = ""
	repeat
		gosub getopt
		if optchar$ = "a" then allFiles = TRUE
		if optchar$ = "s" then summary = TRUE
		if optchar$ = "?" then
			& print "Usage: " argv$[0] " [ -s ] [ -a ] name..."
			goto ExitError
		endif
	until optchar$ = ""
	
	fPrefix
	& get cwd$
	& lcase(cwd$)
	
	if nargc = 1 then
		nargv$[1] = cwd$
		nargc = nargc + 1
	endif
	
	dim pathIndex%[MAXDEPTH]
	
	for cd = 1 to nargc - 1
		path$ = nargv$[cd]
		& lcase(path$)
		if path$ = "/" then
			& pos(2, SysInfo$[plDir], "/"), p
			path$ = left$(SysInfo$[plDir], p - 1)
		endif
		if right$(path$, 1) = "/" then
			path$ = left$(path$, len(path$) - 1)
		endif
		if left$(cwd$, len(path$)) = path$ then
			pLen = len(path$) + 1
		else
			pLen = 0
		endif
		& getinfo path$, i$
		if i$ = "" or mid$(i$,5,1) <> chr$(15) then
			& print argv$[0]": can't open " path$
		else
			gosub searchPath
		endif
	next
goto Exit


testOutput:
	accFile$ = ""
	if asc(argv$[argc-1]) = 62 then
		argc = argc - 1
		accFile$ = argv$[argc]
		k = len(accFile$)
		& spc (accFile$, 62), accFile$
		k = k - len(accFile$)
		gosub testAccFile
	endif
return

testAccFile:
	& getinfo accFile$,i$
	accMode = accWrite + accWrite * (i$ > "")
	gosub CheckAccess
	if not accOK then
		print argv$[0] ": can't open " accFile$
		status% = -1
	endif
return


searchPath:
	SP% = 0
	thePath$ = ""
	gosub PushDir
	repeat
		dim f$[MAXFILES]
		& files(thePath$, f$, 15, vis_and_invis), f
		& sort (f$, f)
		cf = pathIndex%[SP%]
		path$ = f$[cf]
		& erase(f$)
		fFre
		& lcase(path$)
		if f >= pathIndex%[SP%] then
			pathIndex%[SP%] = cf + 1
			gosub PushDir
		else
			gosub scandir
			tb = tb + bc
			i$ = thePath$
			gosub PopDir
			if SP% then
				bt = bc
				if not summary and not allFiles then
					gosub ShowEntry
				endif
			else
				bt = tb
				gosub ShowEntry
			endif
		endif
	until not SP%
return

PushDir:
	SP% = SP% + 1
	thePath$ = thePath$ + path$ + "/"
	pathIndex%[SP%] = 1
return

PopDir:
	SP% = SP% - 1
	if SP% then
		& < thePath$, thePath$
		thePath$ = thePath$ + "/"
	endif
return


ShowEntry:
	if outputFile$ > "" then fAppend outputFile$
	if right$(i$, 1) = "/" then i$ = left$(i$, len(i$) - 1)
	if pLen then i$ = "." + mid$(i$, pLen)
	print bt "^I" i$
	if outputFile$ > "" then fClose outputFile$
return


scandir:
	fOpen thePath$ ",T15"
	fRead thePath$
	& get 
	& get 
	& get 
	bc = 0
	& rept
		& get a$
		if a$ > "" then
			bt = val (mid$(a$, 23, 7))
			if allFiles then
				i$ = mid$(a$,3,15)
				&lcase (i$)
				& spc(thePath$ + i$), i$
				gosub ShowEntry
			endif
			bc = bc + bt
		endif
	& until(a$ = "")
	fClose
return 

#include <proline/proline.lib>
#include <proline/access.lib>
#include <proline/getopt.lib>
