' *****************************************************************************
' *
' *	cshx.b		ProLine C-Shell Executable Core
' *			(C)opyright 1994 Morgan Davis Group
' *
' * When      Who Ver   Description
' * ========= === ===== =======================================================
' *  7-Dec-91 mwd 1.5	Converted to MD-BASIC
' * 15-Jul-92 mwd 2.0	Release 2.0
' * 14-Sep-92 mwd 2.0.1	Fixed run protection bug in RunAccess (/usr/ matching)
' * 24-Feb-93 mwd 2.0.2 Fixed bugs in logout, exec, cp and mv
' *  7-Jun-93 mwd 2.0.3 Fixed mv permission bug
' * 16-Jul-93 mwd 2.0.4 2.0.1 fix wasn't fixed: USR_PATH != ID$[uHome]  fool!!
' * 13-Sep-93 mwd 2.1b1 Fixed parsing bug -- wasn't handling # comments right
' *  2-Jan-93 mwd 3.0b2 Added new Parse module commands
' *
' *****************************************************************************

#define IDENT_PROG "cshx"
#include "csh.h"

' =============================================================================
'			   C - S H E L L   C O D E
' =============================================================================

	onerr goto HandleError
	& on hangup goto Logout
	if envFile$ = "" then
		gosub AppInit
		gosub MakeEnvFile
		fRestore envFile$
		& restore ShellArgs_Cell to i$
		status% = asc(mid$(i$, 3))
		if status% > 127 then status% = status% - 256
	endif
	def fn nextHistory(i) = (i + 1) * (i < MAX_HISTORY)
	def fn prevHistory(i) = (i - 1) * (i > 0) + (MAX_HISTORY * not i)
	gosub SetEnvLvl
	gosub LoadParser
	onerr goto ShellError
	gosub closeScript

	var$[VAR_STATUS]= "status=" + str$(status%)
	if status% then gosub handleStatus

	repeat
		& int on
		& on int goto ExecCancel
		gosub ExecuteCommand
		goto GetNext
		ExecCancel:
			& print
		ExecCancel2:
			& pop
			gosub cmdStop
		GetNext:
		gosub GetNextCommand
	until exitFlag% and scriptFile$ = ""
	gosub PopEnv
	theCommand$ = chr$(0)
	argc = 0
	gosub storeCommand
	if printing% then gosub KillPrinter
	ExitStatus% = status%
goto Exit

handleStatus:
	i$ = "exit"
	j = unsetBegin%
	i% = varsDefined%
	gosub findVar
	if q then gosub cmdStop
	status% = 0	
return


GetNextCommand:
	execFlag% = FALSE
	if status% then gosub handleStatus
	if CommandLine$ > "" then return
	if scriptFile$ > "" then
		onerr goto scriptEOF
		if not scriptOpen% then 
			fOpen scriptFile$ ",T" scriptType%
			fRead scriptFile$ ",B" scriptPos%
			scriptOpen% = TRUE
		endif

		fRead scriptFile$
		repeat
			& get CommandLine$
			scriptPos% = scriptPos% + len(CommandLine$) + 1
			& spc(CommandLine$), CommandLine$
		until CommandLine$ > ""
		ctrlDFix:
		& pos (CommandLine$,"^D"), p
		if p then
			& mid$ (CommandLine$, p) = "D"
			goto ctrlDFix
		endif
		fFre
		status% = 0
		return	

		scriptEOF:
		onerr goto ShellError
		& onerr i, j
		on i <> 5 goto ShellError
		goto cmdStop
	endif

	if printing% then gosub KillPrinter
	if exitOnEOC% then exitFlag% = TRUE
	if exitFlag% then return

	histID% = histID% + 1
	if ifLevel% then
		& left$("", ifLevel% * 4), stuffer$
	else
		stuffer$ = ""
	endif
	prompting% = TRUE
	theCommand$ = mid$(var$[VAR_PROMPT], 8)
	gosub ParseVar
	prompting% = FALSE
	& pos (theCommand$, "!"), p
	if p then theCommand$ = mid$(theCommand$, 1, p - 1) + \
		str$(histID%) + mid$(theCommand$, p + 1)
	j = histHead%
	history$[j] = ""
	& int = peek(sttyCancel),4,10,14,11,16
	& on int goto inputTrap
	inputAgain:
		repeat
			& print theCommand$;
			& read (-255, stuffer$), CommandLine$
			& spc(CommandLine$), CommandLine$
		until CommandLine$ > ""
		if asc(CommandLine$) = 33 then
			gosub getHistory
			if CommandLine$ = "" then goto inputAgain
			& ioctl (ioUp)
			& ioctl (ioClearEOL)
			& print theCommand$ CommandLine$
		endif
		& time(j$)
		history$[histHead%] = mid$(j$, 16, 5) + "  " + CommandLine$
		histHead% = fn nextHistory(histHead%)
		if inHist% < MAX_HISTORY then
			inHist% = inHist% + 1
		else
			histTail% = fn nextHistory(histTail%)
		endif
		& int = peek(sttyCancel)
		status% = 0
		return
	inputTrap:
		& int(i)
		if i = 4 then
			if envLevel% > 1 then
				& print "exit"
			else
				& print "logout"
			endif
			exitFlag% = TRUE
			return
		endif
		if (i = 10 or i = 14) and (j <> histHead%) then
			j = fn nextHistory(j)
		endif
		if (i = 11 or i = 16) and (j <> histTail%) then
			j = fn prevHistory(j)
		endif
		stuffer$ = mid$(history$[j], 8)
		& ioctl (ioCR)
		& ioctl (ioClearEOL)
	goto inputAgain	
' GetNextCommand

getHistory:
	& pos (CommandLine$ + " ", " "), p
	i$ = mid$(CommandLine$, 2, p - 2)
	stuffer$ = ""
	k = val(i$)
	if k then
		q = inHist% + 1
		if k >= histID% or k < (histID% - q) then
			CommandLine$ = ""
			return
		endif
		k = histHead% - (histID% - k)
		if k < 0 then k = q + k
	else
		if i$ = "!" then
			k = fn prevHistory(histHead%)
		else
			j% = histHead%
			k = -1
			for i = 0 to inHist%
				if i$ = mid$(history$[j%], 8, len(i$)) then
					k = j%
					i = inHist%
				else
					j% = fn prevHistory(j%)
				endif
			next
			if k < 0 then
				CommandLine$ = ""
				return
			endif
		endif
	endif
	CommandLine$ = mid$(history$[k], 8) + mid$(CommandLine$, p)
return



PopEnv:
	gosub closeScript
	& getinfo envFile$, i$
	if i$ > "" then fDelete envFile$
	envLevel% = envLevel% - 1
	poke sttyShell, envLevel%
	gosub MakeEnvFile
SetEnvLvl:
	var$[VAR_SHLVL] = "shlvl=" + str$(envLevel%)
return
	
MakeEnvFile:
	envLevel% = peek(sttyShell)
	envFile$ = SysInfo$[plTempDir] + ENVNAME + str$(envLevel%)
return


SubAlias:
	j% = 0
	accOK = FALSE
	repeat
		& pos (theCommand$ + " ", " "), p
		i$ = left$(theCommand$, p - 1)
		p$ = mid$(theCommand$, p + 1)
		& asc(i$)
		k = len(i$)
		j = aliasBegin%
		i% = j + aliasesDefined% - 1
		gosub findVar
		if q then
			accOK = TRUE
			theCommand$ = mid$(var$[q], k + 2)
			& pos (theCommand$, "!"), p%
			if p% then
				repeat
					& pos ("^~*$", mid$(theCommand$, p% + 1, 1)), q%
					if q% then
						k = len(p$) + 1
						j = 1
						if q% = 1 then
							& pos (p$ + " ", " "), k
						else
							if q% = 3 then
								& pos right$ (p$," "), q%
								if q% then j = q% + 1
							endif
						endif
						theCommand$ = mid$(theCommand$, 1, p% - 1) + \
							mid$(p$, j, k - j) + \
							mid$(theCommand$, p% + 2)
					endif
					& pos (p% + 1, theCommand$, "!"), p%
				until not p%
			else
				& spc(theCommand$ + " " + p$), theCommand$
			endif
		endif
		j% = j% + 1
	until not q or j% = aliasesDefined%
	if accOK then
		& spc (theCommand$ + CommandLine$, 59), CommandLine$
		gosub FullParse
	endif
return


Argumentize:
	realCL$ = theCommand$
	& asc(realCL$)

	argc = 0
	p = 0
	theCommand$ = theCommand$ + " "
	repeat
		q = p + 1
		if asc(mid$(theCommand$, q, 1)) = 46 then
			gosub UpdateCWD
			k = 2
			i$ = mid$(theCommand$, q, k)
			if i$ = ".." then
				& < j$, j$
			else
				k = 1
			endif
			theCommand$ = mid$(theCommand$, 1, p) + j$ + \
				mid$ (theCommand$, p + k + 1)
		endif
				
		& pos (q, theCommand$, " "), p
		argv$[argc] = mid$(theCommand$, q, p - q)
		& asc(argv$[argc])
		argc = argc + 1
		& mid$ (theCommand$, p) = chr$(0)
	until p = len(theCommand$)
	& asc(theCommand$)
	& lcase (argv$[0])
	if argv$[argc-1] = ">" PRINTER_DEVICE then 
		argc = argc - 1
		if argc then
			theCommand$ = mid$(theCommand$,1, \
				len(theCommand$) - 10)
			realCL$ = left$(realCL$, len(theCommand$))
			if (not dcd%) or SuperUser then
				& load get SysInfo$[plModulesDir] + "Printer"
				& scrn(printerOn)
				printing% = TRUE
			endif
		endif
	endif
return


ExecuteCommand:
	gosub FullParse
	if status% then goto ExecCancel2
	if theCommand$ = "" then return
	
PostIfEntry:
	if aliasesDefined% then gosub SubAlias
	gosub Argumentize

CmdEntry:
	a$ = argv$[0]
	& pos (directives$, ";" + a$ + " "), j
	if j then on asc(mid$(directives$,j-1))-64 goto DIRECTIVE_FUNCS

	if skipLevel% then return

	& pos (commands$, ";" + a$ + " "), j
	if j then on asc(mid$(commands$,j-1))-64 goto COMMANDS_FUNCS

	& pos (a$, "/"),p
	if p then
		accFile$ = a$
		gosub getFileType
		if fileType% > -1 then goto DoRun
	else	
		' Look for a$ in PATH_LIST
		p$ = mid$(var$(VAR_PATH), 6)
		t = len(p$)
		p = 0
		repeat
			&pos (p+1, p$ + " ", " "), q
			j$ = mid$(p$, p + 1, q - p - 1) + "/"
			if j$ = "./" then
				fPrefix
				& get j$
			endif
			accFile$ = j$ + a$
			gosub getFileType
			if fileType% > -1 then goto DoRun
			p = q
		until p > t
	endif
	i$ = argv$[0] + ": command not found"
goto StdErrMsg


DoRun:
	accOK = fileType% = BAS_TYPE or fileType% = CMD_TYPE
	if accOK and not SuperUser then
		accMode = accExecute
		gosub CheckAccess
		if accOK and fileType% = BAS_TYPE then
			& pos (PATH_LIST, AccFile2$), AccOK
'			i$ = ID$[uHome]
'			AccOK = left$(AccFile2$, len(i$)) <> i$
		endif
	endif

	if not accOK then
		print argv$[0] ": can't run"
		status% = -1
		return
	endif

	if fileType% = CMD_TYPE then goto runScript

	if execFlag% then
		gosub PopEnv
	else
		gosub closeScript
		fStore envFile$
		& restore ProgStack_Cell to i$
		& store ShellXPath$ + ":" + i$ to ProgStack_Cell
	endif
	gosub storeCommand
	& load fre PARSER_ID
fLaunch accFile$


storeCommand:
	if status% < 0 then status% = status% + 256
	& left$(chr$(SuperUser)+chr$(argc)+chr$(status%)+chr$(exitFlag%),7,0),i$
	& store i$ + theCommand$ to ShellArgs_Cell
return

GetItem:
	q% = 0
	p% = 0
	repeat
		q = p% + 1
		& pos (q, i$ + " ", " "), p%
		if p% - q then
			a$ = mid$(i$, q, p% - q)
			q% = q% + 1
		endif
	until q% > i% or p% > len(i$)
	if q% <= i% then a$ = ""
return


checkFile:
	& getinfo accFile$, i$
	accOK = i$ > ""
	if accOK then goto fileAccess
fileNotFound:
	print argv$[0] ": can't find " accFile$
	status% = -1
return

checkMove:
	accMode = accRead + accDelete
	goto checkCPMV

checkCopy:
	accMode = accRead
checkCPMV:
	accFile$ = argv$[i]
	gosub fullPath
	argv$[i] = accFile$
	gosub checkFile
	if not accOK then return

	if fileType% = DIR_TYPE then 
		& < accFile$,j$
		argv$[argc-1] = target$ + mid$(accFile$, len(j$) + 1)
	endif
	accFile$ = argv$[argc-1]
	gosub fullPath
	argv$[argc-1] = accFile$

' @@@@@@@@@@@@@@@@@@@@@@@
'
' For some reason, the lines commented below keep echo/cat from hanging
' when a >file redirection is used.  The lines would be nice to have since
' it would eliminate a possible extra disk access.
'
' @@@@@@@@@@@@@@@@@@@@@@@

testAccFile:
'	& < accFile$, i$
'	if accFile$ > i$ then
		& getinfo accFile$,i$
		accMode = accWrite + accDelete * (i$ > "")
'	else
'		accMode = accWrite
'	endif

fileAccess:
	gosub CheckAccess
	if not accOK then
		print argv$[0] ": can't access " accFile$
		status% = -1
	endif
return


fullPath:
	if asc(accFile$) <> 47 then 
		gosub UpdateCWD
		accFile$ = j$ + "/" + accFile$
	endif
	& lcase(accFile$)
stripSlash:
	if right$(accFile$,1) = "/" then
		accFile$ = left$(accFile$, len(accFile$) -1)
	endif
return 

getFileType:
	& getinfo accFile$, i$
	if i$ = "" then 
		fileType% = -1
		return
	endif
	fileType% = asc(mid$(i$,5))
return


closeScript:
	fClose scriptFile$
	scriptOpen% = FALSE
return


cmdExec:
	gosub hasArg
	& pos (realCL$, " "), p
	theCommand$ = mid$(realCL$, p + 1)
	gosub cmdStop2
	execFlag% = TRUE
	exitFlag% = TRUE
	pop
goto PostIfEntry

cmdShift:
	if argc = 1 then
		i$ = "argv"
		q = VAR_ARGV
	else
		i$ = argv$[1]
		j = unsetBegin%
		i% = varsDefined%
		gosub findVar
		if not q then goto UndefdVar
	endif
	& pos(len(i$) + 2, var$[q], " "), p
	if not p then p = 254
	var$[q] = i$ + "=" + mid$(var$[q], p + 1)
return


UndefdVar:
	i$ = i$ + ": undefined"
goto StdErrMsg


cmdHistory:
	j = histTail%
	k = histID% - inHist% + 1
	for i = 1 to inHist%
		& right$(str$(k), 6), i$
		print i$ "  " history$[j]
		j = fn nextHistory(j)
		k = k + 1
	next
return


cmdPwd:
	gosub UpdateCWD
	print j$
return 


cmdMv:
	gosub targArg
	for i = 1 to argc - 2
		gosub checkMove
		if accOK then
			accFile$ = argv$[i]
			a$ = argv$[argc-1]
			if accFile$ <> a$ then
				& < accFile$, i$
				& < a$, j$
				if i$ = j$ or (accFile$ = i$ and a$ = j$) then
					if accMode > accWrite then fDelete a$
					fRename accFile$ "," a$
				else
					if scriptOpen% then gosub closeScript
					& copy(accFile$ to a$)
					fDelete accFile$
				endif
			endif
		endif
	next
return


cmdRm:
	gosub hasArg
	accMode = accDelete
	for i = 1 to argc-1
		accFile$ = argv$[i]
		gosub checkFile
		if accOK then fDelete accFile$
	next 
return 


cmdCp:
	q% = FALSE
	goto addcopy
cmdAdd:
	q% = TRUE
addcopy:
	gosub targArg
	gosub closeScript
	for i = 1 to argc - 2
		gosub checkCopy
		if accOK and (argv$[i] <> argv$[argc-1]) then
			if not q% and accMode > accWrite then
				fDelete argv$[argc-1]
			endif
			fFre
			& add(argv$[i] to argv$[argc-1])
		endif
	next
return 


cmdCat:
	gosub hasArg
	gosub testOutput
	if accFile$ > "" then
		argv$[argc] = accFile$
		argc = argc + 1
		on k goto cmdCp, cmdAdd
	else	
		accMode = accRead
		for i = 1 to argc - 1
			accFile$ = argv$[i]
			gosub checkFile
			if accOK then & list accFile$
		next
	endif
return


cmdCd:
	if argc = 1 then
		accFile$ = ID$[uHome]
	else
		accFile$ = argv$[1]
		if accFile$ = "/" then accFile$ = SysInfo$[plDir]
	endif
	gosub getFileType
	on filetype% < 0 goto fileNotFound
	if filetype% <> DIR_TYPE then
		i$ = accFile$ + ": not a directory"
		goto StdErrMsg
	endif	
	fPrefix accFile$
goto UpdateCWD


targArg:
	if argc < 2 then
		i$ = "source... [target]"
		goto PopUsage
	endif
	if argc = 2 then 
		gosub UpdateCWD
		argv$[2] = j$
		argc = 3
	endif
	accFile$ = argv$[argc-1]
	gosub stripSlash
	target$ = accFile$
goto getFileType


cmdMkdir:
	if argc < 2 then
		i$ = "dir..."
		goto ShowUsage
	endif
	accMode = accWrite
	for i = 1 to argc - 1
		accFile$ = argv$[i]
		gosub getFileType
		if fileType% > -1 then
			i$ = accFile$ + ": exists"
			gosub StdErrMsg
		else
			gosub fileAccess
			if accOK then fCreate argv$[i]
		endif
	next 
return 


cmdRead:
	if argc < 2 then
		i$ = "var"
		goto ShowUsage
	endif
	& read a$
	argv$[1] = argv$[1] + "=" + a$
goto cmdSet

	
cmdClear:
	& ioctl(ioClearScreen)
return 


cmdElse:
	if ifLevel% then
		if skipLevel% = ifLevel% then
			skipLevel% = 0
		else
			if not skipLevel% then skipLevel% = ifLevel%
		endif
		return
	endif
goto noIf

cmdEndif:
	if ifLevel% then
		if skipLevel% = ifLevel% then skipLevel% = 0
		ifLevel% = ifLevel% - 1
		return
	endif
noIf:
	i$ = argv$[0] + ": unexpected"
goto StdErrMsg


cmdIf:
	i = 0
	a$ = ""
	for q = 1 to argc - 1
		j$ = argv$[q]
		if j$ = "then" then
			i = q
			q = argc - 1
		else
			if j$ = "-f" then
				if not skipLevel% then & getinfo argv$[q+1], i$
				j$ = str$(i$ > "")
				q = q + 1
			else
				gosub ifFixArgs
			endif
			a$ = a$ + j$
		endif
	next
	if argv$[i] <> "then" then
		i$ = "expr then [...]"
		goto ShowUsage
	endif

	& val a$ to j

	if i < (argc - 1) then
		k = 0
		for q = i + 1 to argc - 1
			if argv$[q] = "else" then
				k = q
				q = argc - 1
			endif
		next
		if not j then			' false?
			if not k then return	' no else? then quit
			j = k + 1		' else+1 to rest of args
		else
			if k then argc = k	' there is an else, skip it
			j = i + 1
		endif
		gosub ConcatArgs
		theCommand$ = a$
		goto PostIfEntry
	else
		ifLevel% = ifLevel% + 1
		if skipLevel% then return
		skipLevel% = ifLevel% * (not j)
	endif
return


ifFixArgs:
	if asc(j$) = 40 then
		if len(j$) > 1 then j$ = "(" + q$ + mid$(j$, 2) + q$
	else
		if right$(j$,1) = ")" then
			if len(j$) > 1 then j$ = q$ + mid$(j$, 1, len(j$) - 1) + q$ + ")"
		else
			i$ = j$
			& lcase(i$)
			& pos (operators$, ";" + i$ + " "), p
			if p then
				p = asc(mid$(operators$,p - 1))-64
				if p < SUBOP_NEXT then
					j$ = mid$(SUBOPS, p * 3 - 2,3)
				endif
			else
				if j$ = chr$(0) then j$ = ""
				j$ = q$ + j$ + q$
			endif
		endif
	endif
return


cmdSource:
	gosub hasArg
	accFile$ = argv$[1]
	accMode = accExecute
	gosub checkFile
	if not accOK then return

	realCL$ = mid$(realCL$, 8)
	argc = argc - 1
	
runScript:
	CLSave$ = CommandLine$
	CommandLine$ = ""
	gosub cmdStop2
	var$[VAR_ARGV] = "argv=" + realCL$
	var$[VAR_ARGC] = "argc=" + str$(argc)
	gosub getFileType
	scriptType% = fileType%
	gosub fullPath
	scriptFile$ = accFile$
return

cmdLogout:
	gosub cmdStop
	while envLevel% > 1
		gosub PopEnv
	wend
	& restore ProgStack_Cell to a$
	& pos right$(a$, ":"), p
	& store mid$(a$, p + 1) to ProgStack_Cell

cmdExit:
	if argc > 1 then status% = val(argv$[1])
	if scriptFile$ = "" then exitFlag% = TRUE
	
cmdStop:
	CommandLine$ = CLSave$
	CLSave$ = ""
cmdStop2:
	gosub closeScript
	scriptFile$ = ""
	ifLevel% = 0
	skipLevel% = 0
	scriptPos% = 0
return 


testOutput:
	accFile$ = ""
	if left$(argv$[argc-1], 1) = ">" then
		argc = argc - 1
		accFile$ = argv$[argc]
		k = len(accFile$)
		& spc (accFile$, 62), accFile$
		k = k - len(accFile$)
		gosub testAccFile
		if not accOK then pop
	endif
return


cmdEcho:
	gosub testOutput
	if accFile$ > "" then
		gosub closeScript
		if k = 1 and accMode > accWrite then fDelete accFile$
		fAppend accFile$
		gosub doEcho
		fClose
		return
	endif
		
doEcho:		
	i$ = chr$ (13)
	if argc > 1 then
		j = 1
		if argv$[1] = "-n" then 
			i$ = ""
			j = 2
		endif
		if j <= argc - 1 then
			gosub ConcatArgs
			i$ = a$ + i$
		endif
	endif
	print i$;
return 

	
cmdUnalias:
	j = aliasBegin%
	i% = j + aliasesDefined% - 1
	gosub removeVar
	aliasesDefined% = aliasesDefined% - j%
return

cmdUnset:
	j = unsetBegin%
	i% = varsDefined%
	gosub removeVar
	varsDefined% = varsDefined% - j%
return

removeVar:
	if argc = 1 then goto showVars
	j% = 0
	for accOK = 1 to argc - 1
		i$ = argv$[accOK]
		gosub findVar
		if q then
			for k = q + 1 to i%
				var$[k - 1] = var$[k]
			next
			var$[i%] = ""
			j% = j% + 1
			i% = i% - 1
		endif
	next
return


findVar:
	q = 0
	if i% >= j then
		& lcase(i$)
		for i = j to i%
			if i$+"=" = mid$(var$[i],1,len(i$)+1) then
				q = i
				i = i%
			endif
		next
	endif
return


cmdAlias:
	j = aliasBegin%
	i% = j + aliasesDefined% - 1
	if argc = 1 then
		if aliasesDefined% then goto showVars2
		return
	endif

	if argc < 3 then
		i$ = "name value..."
		goto ShowUsage
	endif

	i$ = argv$[1]
	gosub findVar
	if not q then
		if aliasesDefined% < MAX_ALIASES then
			q = aliasBegin% + aliasesDefined%
			aliasesDefined% = aliasesDefined% + 1
		else
			i$ = "alias: table full"
			goto StdErrMsg
		endif
	endif
	var$[q] = i$ + "=" + mid$(realCL$, 8 + len(i$))
return

showVars:
	gosub UpdateDate
	gosub UpdateTime
	gosub UpdateCWD
showVars2:
	for i = j to i%
		a$ = var$[i]
		& pos(a$, "="), p
		if p then
			& mid$(a$, p) = "^I"
			& print a$
		endif
	next
return


cmdSet:
	j = VAR_SLASH
	i% = varsDefined%
	if argc = 1 then goto showVars

	for k = 1 to argc - 1
		a$ = argv$[k]
		& pos (a$,"="), p
		if not p then p = len(a$) + 1
		i$ = mid$(a$, 1, p - 1)
		a$ = mid$(a$, p + 1)
		ParseVarLen(i$, i)
		if i < len(i$) then 
			print i$": illegal"
			status% = -1
		else
			gosub findVar
			if not q then
				if varsDefined% < VAR_NEXT + MAX_VARS then
					varsDefined% = varsDefined% + 1
					q = varsDefined%
				else
					i$ = "set: table full"
					gosub StdErrMsg
				endif
			endif
			if not status% then
				var$[q] = i$ + "=" + a$
				if q = VAR_EDITOR then
					& pos (VALID_EDITORS, ";"+a$+";"),q
					if q then gosub SetEditor
				endif
			endif
		endif
	next
return 


SetEditor:
	ID$[uEditor] = a$
	a$ = ""
	for i = 1 to uItemCount
		a$ = a$ + ID$[i] + ":"
	next
	&spc (a$, 58),a$
	& store a$ to UserID_Cell
return


ConcatArgs:
	a$ = ""
	for i = j to argc - 1
		a$ = a$ + argv$[i] + " "
	next
	a$ = mid$(a$, 1, len(a$) - 1)
return


ShellError:
	data	6,"path",7,"file",8,"i/o",9,"volume",\
		10,"access",16,"syntax",20,"busy",\
		53,"param",163,"type",176,"length",-1,,

	& onerr p, q
	fClose
	& restore goto ShellError
	& rept
		read i%,i$
	& until(i% = p or i% < 0)
	if i% > 0 then
		i$ = argv$[0] + ": " + i$
	else
		i$ = Shell$ + ": " + str$(p) + "@" + str$(q)
	endif
	i$ = i$ + " error"
	gosub StdErrMsg
	if p = 12 then call -1370
	gosub LoadParser
goto ExecCancel2

	
UpdateDate:
	& time(j$)
	var$[VAR_DATE] = "date=" + j$ + " " + SysInfo$[plZone]
return

UpdateTime:
	' 7 02 02 94 00 53 55
	& time(j$)
	if mid$(j$, 6, 1) = " " then &mid$(j$, 6) = "0"
	& mid$(j$, 18) = " "
	& mid$(j$, 21) = " "
	& pos(" anebarprayunulugepctovec", mid$(j$, 10, 2)), t
	& right$(str$(t / 2), 2, 48), a$	
	& pos("SuMoTuWeThFrSa", left$(j$, 2)), t
	var$[VAR_TIME] = "time=" + left$(j$, 3) + mid$(j$, 5, 4) + \
		a$ + mid$(j$, 12) + " " + str$((t - 1) / 2)
return

UpdateCWD:
	fPrefix
	& get j$
	& lcase(j$)
	j$ = mid$ (j$, 1, len (j$) - 1)
	var$[VAR_CWD] = "cwd=" + j$
return


hasArg:
	if argc > 1 then return
	i$ = "file..."
PopUsage:
	pop 
ShowUsage:
	i$ = "Usage: " + argv$[0] + " " + i$
StdErrMsg:
	if printing% then gosub KillPrinter
	if prompting% then var$[VAR_PROMPT] = "prompt=?"
	& print i$
	status% = -1
return

KillPrinter:
	& scrn(printerOff)
	& load fre PrinterTool_ID
return

#define	APP_AT_EXIT	ShellCleanUp
ShellCleanUp:
	& load fre PARSER_ID
return

#define	SHPARSE_QUOTE	34
#include "shparse.b"

#define APP_ONLY_INFO
#include <proline/proline.lib>
#include <proline/access.lib>

