.TH BANK G
.DA 16 December 1993
.SH Name
bank - Simulated banking system
.SH Syntax
bank [ _options_ ]
.SH Description
In games where money is the reward, it is desirable to maintain a
balance of cash between various games and be able to utilize your
earnings.  The ProLine Users Bank provides this service, and helps
regulate a simulated economy inside this system.
.PP
Your bank account allows you to make cash deposits and withdrawals with
your savings account, which can earn interest.  It keeps track of how
much money you are carrying with you (cash-on-hand).  You can transfer
funds to another user on the system.  You can take out loans and pay
them back as you earn money by playing (and winning) games.  There are
no service charges or maintenance fees.
.PP
Your account is created automatically (with a gift balance) the
first time you invoke it.  For more details about using the _bank_
interactively, issue its built-in <H>elp command.
.PP
Options:
.IP 10 -a n
Add cash.  This option adds cash (value _n_) to the current user's cash on
hand.  The current user defaults to the person issuing this
command.  (See _-u_ or _-g_ for setting the current user to a particular
account).
.IP 10 -c n
Change cash.  This sets the cash on hand to the specified value _n_ for
the current user.
.IP 10 -g game
Set game user.  This sets the current bank account to the one owned
by the specified _game_.  Games like _blackjack_ can maintain
bank accounts just as users do.
.IP 10 -i
Interactive.  Normally, when invoking _bank_ without arguments, the
user enters an interactive mode.  When options are used, the functions
they perform are completed and the user returns to the shell.  This
option is used in conjunction with other options to send the user into
interactive mode.  Typically, this is used after setting the current
user with _-u_ or _-g_ to work with their account interactively.
.IP 10 -s n
Subtract cash.  This subtracts from cash on hand the specified
value _n_ for the current user.
.IP 10 -q
Quiet.  Some options, such as setting the current user, issue
feedback.  This option disables such feedback.
.IP 10 -u user
Set user.  Sets the current account to the one owned by _user_.
.IP 10 -w
Net worth report.  Quick and easy way to find out what you're worth.
.IP
Of all these options, only _-w_ can be used by non-Super Users.
.PP
.PP Setting Up Accounts
.BR
As stated, user accounts are created automatically when users enter
the _bank_.  Accounts for games, like _blackjack_, need to be created
so that the game (casino) has cash with which to work.  This is usually done
like so:
.IP 5
bank -g blackjack -c 50000
.IP
This sets the current account to the _blackjack_ game (hence _-g_
option as opposed to _-u_), then assigns $50,000 cash to the account.
Game accounts, like the users who play the games, operate out of their
pool of cash on hand.
.SH Note
The order of options is generally significant.  That is, changes
invoked by options occur in the order in which they're presented.
Thus, the following reversal of options can have undesirable
affects:
.IP 5
bank -s 100.25 -u melvin
.IP
This subtracts $100.25 from the current account (yours!), then sets the
current user to ``melvin''.  This was probably not intended.
Consider this:
.IP 5
bank -w -u melvin -w
.IP
This reports _your_ net worth, sets the user to ``melvin'' and then
reports his net worth.
.SH Files
$/games/lib/bank.help - online help file,
.BR
$/adm/*/bank.account - user's bank account file,
.BR
$/games/lib/*.acct - game bank account files.
.SH Author
Morgan Davis (mdavis@mdg.cts.com)
