.TH CS F
.DA 6 May 1992
.SH Name
cs - Conference System file formats
.SH Description
Messages in the conference system are stored in a four-layer directory
hierarchy:
.IP 5
.AF
               CS Main Directory
               /      |        \
     conference   conference    conference
     /   |   \        |           /    \
topic topic topic   topic      topic   topic
  |      |    |       |          |       |
msgs   msgs  msgs   msgs       msgs     msgs
.AF
.IP
The conference system structure begins with a main directory.  This
directory contains subdirectories for each conference on the system.
In turn, these subdirectories contain subdirectories for each topic
within the conference.  A conference can have a maximum of six (6)
topics.  Inside of the topic directories are the individual messages.
.PP
.PP CS Resource file
.BR
_Cs_ requires a resource file, _$/etc/rsrc/cs.rsrc_, which contains the
pathname to the CS Main Directory.  The resource file also includes
the text that is placed into the Organization field of Internet-bound
posts.  A typical resource file might look like this:
.IP 5
.AF
/a/cs
ProLine [pro-sol], Rancho San Diego, CA
.AF
.IP
The organization information should include the name of the host and
its location.
.PP
.PP Info Files
.BR
Each area in the CS structure may include a file called ``info''.  Info
files contain information relating to the area in which they exist.
.PP
For example, upon entering the conference system for the first time,
the $/sys/pcs/info file is displayed.  When joining a new conference,
the info file that resides in the conference's directory (along with
its index and topic directories) is displayed, if it exists.  Likewise,
each topic directory can contain info files (along with the topic's
messages).
.PP
.PP Conference Index Files
.BR
Each conference has an index file called ``i..'' in the conference directory.
The index keeps track of the conference moderator's name, the number
of topics in the conference, and other information.  The format of these
files is given here, though you should never have to edit them directly.
The _csmod_ program handles any editing for you.
.PP
A typical index file might look like:
.IP 10
.AF
mdavis
1,4
news
1,0,7
vaporware:sewall@uconnvm.bitnet:1
0,1227,1327
groups:pro-news-groups@pro-sol;pro.news.groups:0
1,911,985
.AF
.IP
The first line contains the name of the moderator.
.PP
The second line, first number, is a flag: 1=open conference, 0=closed
conference.  The second number on that line is a count of the number of
topics in this conference. 
.PP
The lines that follow contain information about each topic.  A topic has two
lines of information.  The first line is the topic name (i.e. "news").  If
the topic is a networked topic, additional information is provided, separated
by colon characters: the network address to which postings are sent,
and a flag specifying if signatures are attached to network posts (0=no
signatures, 1=attach signatures).  The posting address field may also include
the formal name of a newsgroup with a semicolon separating the address from
the group name.
.PP
The line following the topic name contains three numbers:
.LM 5
.IP 5 (A)
Flag: 1=read only, 0=read/write
.IP 5 (B)
First active message number in the topic
.IP 5 (C)
Next usable (unused) message number, this means
that this number minus one is the last message
that is stored on disk.
.IP
.LM -5
.PP User Data Files
.BR
The conference system keeps track of the conferences each user is joined
to.  It also knows which messages a user has read.  This information is
stored in user's $/adm directory in a file named _csdata_.
.PP
The first line of a _cs_ membership info file contains the conference
name and, after a comma, the number of topics in that conference.
The remaining lines specify the last message read plus 1 within each
topic.  If a user has resigned from that topic, that number is preceded
by a hyphen.  If a user resigns from a conference, the complete entry
for that conference is removed including all the data for the topics
within that conference.
.PP
.PP Default Membership
.BR
If present, new users are automatically joined to the conferences listed
in the $/etc/default/csdata file.  This file contains the name of each
conference, followed by a comma and a zero, on each line.  Example:
.PP
.LM 5
.AF 0
learn,0
proline,0
apple,0
.AF 1
.LM -5
.SH Files
$/sys/pcs/cs.herald - Initial greeting upon entering _cs_,
.BR
$/sys/pcs/cs.list - list of conferences with descriptions,
.BR
$/etc/rsrc/cs.rsrc - CS resource file,
.BR
$/etc/default/csdata - list of default conferences users join,
.BR
_csdir_/*/i.. - index, status and config file for each conference,
.BR
$/adm/*/csdata - data files for each cs member,
.BR
$/etc/help/* - help files for CS commands.
.SH See Also
cs(C), csmod(C)
