.TH STTY C
.DA 16 May 1992
.SH Name
stty - Set terminal options
.SH Syntax
stty [ _option_... ]
.SH Description
_Stty_ is used to set certain I/O options on the current output
terminal. With no argument, it reports the current terminal settings. 
The following options are recognized.
.IP 9 intr ^c
sets your interrupt cancel key (default: Control-C). It must be a control
character or DEL. The argument to _intr_ begins with a caret (^) followed by
the letter corresponding to the control character (e.g., ^C for Control-C). 
To specify DEL, use ^?.
.IP 9 nulls 0
sets the number of nulls after a newline sequence (default 0).
The argument to _nulls_ is an integer from 0 to 255, which specifies
the number of null characters to send.
.IP 9 lines 23
sets the number of lines your terminal screen has (minus one) and turns on
screen paging.  When the specified number of lines have been displayed, you'll
then be prompted with --More-- at the bottom of the screen.  Pressing any key
will resume the display.  You can turn paging off by using "stty lines 0".
.IP 9 -tabs
tab characters are converted to spaces before printing. (default)
.IP 9 tabs
tab characters are preserved.
.IP
_Stty_ can be used with any or all of the options described above
on the same line.  For example:
.IP 5
.AF
stty intr ^? nulls 3 lines 22 -tabs
.AF
.IP
This tells the system to recognize the DEL key as the interrupt character,
send 3 nulls after each line, turn screen paging on for every 22 lines of
text displayed, and expand tabs to spaces.
.SH See Also
setenv(C), tset(C)
