.TH SET C
.DA 16 May 1992
.SH Name
set, unset - Set or unset shell variables
.SH Syntax
set [ _name=value_... ]
.BR
unset _name_...
.SH Description
With no arguments, _set_ lists all shell variables and their values.
With arguments, _set_ assigns a _value_ to the variable _name_ given.
.PP
Example:
.IP 10
.AF
set hello=world
.AF
.IP
Sets the variable _hello_ to the value ``world''.  To access the value
in this new variable, prefix it with a dollar sign, as in:
.IP 10
.AF
1% echo $hello
world
2% ls $hello
world: directory not found
.AF
.IP
Multiple variables can be assigned all at once, as with:
.IP 10
.AF
set foo=bar seven=7 hard="disk drive"
.AF
.IP
To erase a variable, the _unset_ command is used with one or more
variable names:
.IP 10
.AF
3% unset hello
4% unset crash bang bigbang bam
.AF
.IP
Note that variables used in the _value_ portion of a _set_ command
are expanded into the _value_.  This may not be desirable.
In the case where the variable should not be expanded during the
assignment, escape the variable with a backslash (\):
.IP 5
.AF
set prompt="[\$cwd] "
.AF
.IP
.SH See Also
csh(C)
