.TH SENDMAIL C
.DA 16 September 1993
.SH Name
sendmail - Send mail over the internet
.SH Syntax
sendmail
.SH Description
_Sendmail_ sends a message to one or more people, routing the message
over whichever networks are necessary to deliver the message to the
correct place.  Other programs provide user-friendly front ends;
_sendmail_ is used only to deliver preformatted message files placed in
the $/spool/mail subdirectory.
.PP
.PP Routing Strategy
.BR
Local user addresses are determined by matching user directories in $/usr. 
Remote site addresses are determined by matching directories in $/mdss.
.PP
If a local user address is unrecognized, an alias file ($/etc/aliases)
is searched and the route is aliased appropriately if a match is found. 
If a remote site address is unrecognized, it is searched for in a path
alias database ($/etc/paths) and the bogus route is substituted if an
alias is found.  If a route still fails, its appended domain, if
included, is searched for in the path alias file.  If a domain match is
found, the path is aliased appropriately, otherwise the letter is
forwarded to the authority site (governed by the system's domain).
.PP
If a local address in an alias list begins with `~' (tilde), it forces
sendmail to write into the named mailbox without verifying that the
address is an actual user on the system.  See _aliases(F)_ for details.
.PP
If _sendmail_ is unable to find a valid route at this point, the message is
forwarded to a ``smart host'' (see below).  If no smart host is
designated, the message is returned to the sender with an error message.
.PP
.PP Special Handling
.BR
_Sendmail_ also resolves local letters for users who have a _forward_
file in their home directory.  The _forward_ file contains e-mail
addresses that replace the local user's address, thus forwarding letters
to addresses other than (or including) the local user.  See forward(F)
for more details.
.PP
It is also the responsibility of _sendmail_ to deliver local messages
with attached binary segments, as formatted by the _rcp_ program.  Text
portions of such messages are delivered in the usual fashion while the
binary portion is written into the addressee's user area.  If a file
collision occurs, the file is saved with a unique name.
.PP
.PP Resource File
.BR
The resource file for sendmail contains entries that regulate its
operation.  Each entry is on a line by itself in the following order:
.IP 10 Line 1
Smart host.  This line contains the complete path to a ``smart host'',
that is, one that can handle unresolved addressing. For example, this
line might contain ``pro-neighbor''. Any messages that can't be resolved
locally are eventually passed on to ``pro-neighbor'', a smart host that
attempts to deliver the message.
.IP 10 Line 2
Busy flag. This line contains a number (0 for FALSE, and 1 to TRUE) to
determine if the modem should be placed off hook (busy) while _sendmail_
delivers mail.
.IP 10 Line 3
Progress level. This line contains a number (0 to 9) setting the level
of progress reporting while _sendmail_ runs.  Level 0 is minimal
reporting, while 9 is maximum reporting.
.BR 2
_Sendmail_ displays a code for each letter delivered.  These codes are:
.BR 2
(.) = local letter
.BR
(!) = offsite letter
.BR
(>) = local _rcp_ letter
.BR
(F) = forwarded letter
.BR
(N) = news batch
.BR
(X) = bounced letter
.IP 10 Line 4
Aliases location.  This line holds the pathname to the _aliases_
database file.  See _aliases(F)_ for details.  Default is $/etc/aliases.
.IP 10 Line 5
Paths location.  This line holds the pathname to the _paths_ database
file.  See _map(F)_ for details.  Default is $/etc/paths.
.BR 2
By setting the pathnames of the aliases and paths files to a RAM disk
location, sendmail's performance can be increased.  Be sure to place
copy commands in $/etc/rc to copy the files to the RAM disk after
starting up.  See _rc(ADM)_ for details.
.IP 10 Line 6
Favor smart host flag. This line contains a number (0 for FALSE, and 1
to TRUE) to determine if _sendmail_ should attempt to locate addresses
containing aliases in the paths database.
.BR 2
If set to 1, _sendmail_ consults the paths database to lookup addresses
with domains that are not the same as the host's.  This is useful when
the host communicates with more than one domain authority.
.BR 2
If set to 0, any addresses with domain specifiers other than the host's
are passed immediately to the smart host.  This avoids extra passes through
the paths database which speeds up processing.
.IP
If a fatal operating system error occurs, _sendmail_ displays
error information, followed by an alert sound at the console.  This
will last for approximately a minute before the system is restarted.
Press Control-C to cancel the error and enter BASIC.
.SH Files
$/etc/aliases - user alias database,
.BR
$/etc/paths - path alias database,
.BR
$/etc/rsrc/sendmail.rsrc - resource file,
.BR
$spool/mail - mail spool directory,
.BR
$/usr/*/forward - user's forwarding address file.
.SH See Also
aliases(F), forward(F), mail(C), mdss(NET), rcp(NET)
