.TH ROT13 C
.DA 16 May 1992
.SH Name
rot13 - Rot13 file conversion utility
.SH Syntax
rot13 [ -h ] _infile_ [ _outfile_ ]
.SH Description
_Rot13_ encodes (or decodes) a text file, rotating each alphabetical character
in the file 13 places in the alphabet.  Encoding a text file with _rot13_
prevents reading the text without the special effort required to
decode it.  For example, offensive jokes in the rec.humor.funny newsgroup
are encoded using _rot13_.
.PP
Since the _rot13_ encoding is also self-decoding, a file encoded into
_rot13_ format is decoded in the same manner.  A second pass over the
file decodes it.
.PP
The optional -h flag skips the header on the _infile_.  This prevents
_rot13_ from processing any initial header lines, up to the first blank
line, processing only the body of a message.  In other words, header lines
are left ``as-is''.
.PP
_Rot13_ prints its output to the screen, or to the file given as the
_outfile_ argument.
.PP
Examples:
.IP 5
.AF
rot13 string.joke
.AF
.IP
processes the file ``string.joke'' with output appearing on the screen.
.IP 5
.AF
rot13 -h string.joke joke.rot
.AF
.IP
processes ``string.joke'' into the file ``joke.rot'', leaving the
header alone.
.SH See Also
safecom(C), uudecode(C), uuencode(C)
.SH Author
Dean Fick (dean@pro-electric.cts.com)
