.TH PLUSH C
.DA 24 February 1994
.SH Name
plush - ProLine Users Shell
.SH Syntax
plush
.SH Description
_Plush_ is a simple, flexible, and friendly shell environment for the
typical ProLine user.  It employs a menu-style interface offering
access to resources that one would only be able to access from a more
powerful shell, such as _csh_. 
.PP
.PP Using PLUSH
.BR
When _plush_ is invoked, it presents a menu of commands. After a
selection is made, the appropriate task is performed.  This can involve
launching an application or performing an internal function within
_plush_, such as going into a submenu. Upon exiting a launched
application, _plush_ resumes, displaying the last menu presented.
.PP
Special keys: To back out of a submenu and return to a previous menu,
press a ``backup'' key.  A backup key is any control character other
than the user's cancel (interrupt) key.  The backspace or RETURN keys
are suggested as backup keys.  Pressing a cancel key halts a process
and returns to the current menu prompt.  Pressing `?' shows a list of a
menu's commands. The `+' and `-' keys toggle --More-- prompting.
.PP
_Plush_ can ask for a line of input as an argument to some menu
functions.  For example, some disk utilities would require the name of a
file to act upon.  _Plush_ recognizes the characters _$/_ in inputs as a
variable which expands to the ProLine system directory (just like in
_csh_).
.PP
.PP Plush Menus
.BR
Menus are defined in a _plush_ menu file.  When invoked, _plush_ attempts
to locate a menu file in this order:
.IP 5 1.
A file named ``plush.m'' in the user's $/adm directory.
.IP 5 2.
A file named ``plush.m.#'', where # is the group ID of the user, in $tmpdir.
.IP 5 3.
A file named ``plush.m'' in $tmpdir.
.IP 5 4.
A file named ``plush.m.#'', where # is the group ID of the user, in $/etc.
.IP 5 5.
A file named ``plush.m'' in $/etc.
.IP
This scheme allows the administrator to assign custom menu files to individual
users, groups, and others.
.SH Notes
_Plush_ runs faster if it and its menu files are located on a RAM disk.
.PP
For details on designing custom menus, see plush(F).
.SH Files
$/adm/*/environs - user's environment settings,
.BR
$tmpdir/plush.env - temporary environment file.
.SH See Also
csh(C), plush(F), setenv(C)
