.TH PC C
.DA 16 May 1992
.SH Name
pc - Programmable calculator
.SH Syntax
pc [ _expr_ ]
.SH Description
_Pc_ is a programmable calculator.  It provides simple or very sophisticated
number crunching -- from basic adding-machine work to complex mathematical
expression evaluation.
.PP
.PP Features
.LM 5
.RM -5
.IP 3 o
_Arithmetic Operators_.  +, -, / (division), * (multiplication),
^ (exponentiation), nested parenthetical ordering.
.IP 3 o
_Relational Operators_.  =, >, <, <>, >=, <=, AND, OR, NOT.
.IP 3 o
_Advanced Functions_.  SGN, INT, ABS, SQR, RND, LOG, EXP, COS, SIN, TAN, ATN.
.IP 3 o
_String Functions_. LEN, STR$, VAL, ASC, CHR$, LEFT$, RIGHT$, MID$.
.IP 3 o
_User Defined Variables_. Up to 32 pre-evaluated or constant variables.
.IP 3 o
_Stack_. Holds up to 32 values.
.IP 3 o
_History_.  A 100-entry command history allows you to select one or more
previous entries for additional processing.  The history also maintains
the result of each operation at each point in time.
.IP 3 o
_Precision_. Includes 38-digit floating point precision.
.IP 0
.RM 5
.LM -5
The functions adhere closely to the standard BASIC programming
language syntax.
.PP
.PP The Command Line
.BR
When invoked with the _expr_ argument, _pc_ evaluates the expression,
displays the result, and exits.  Example:
.IP 5
.AF
# pc 2 * 2 - 8
-4
# _
.AF 1
.IP
When invoked without an argument, _pc_ enters a command mode, allowing you
to issue multiple commands to do simple or complex calculations.  This is the
initial command line prompt:
.IP 5
.AF
pc [0] 1> _
.AF 1
.IP
The number in [ square ] brackets is the _current result register_.  This
register holds the value of the last operation that _pc_ performed.  The
number before the `>' character is the line number of the next entry to
be added to the history buffer.
.PP
Entering any number or numeric expression at this prompt causes _pc_
to evaluate it and change the result register accordingly:
.IP 5
.AF
pc [0] 1> 6502 + 65816
pc [72318] 2> _
.AF 1
.IP
If the command begins with an arithmetic operator (+, -, /, etc.), _pc_
performs the operation on the value contained in the result register.
For example:
.IP 5
.AF
pc [72318] 3> - 65816 
pc [6502] 4> _
.AF 1
.IP
Spaces are optional within expressions.  They are needed only to delimit
_pc_ commands from their arguments, if any.
.PP
.PP Boolean Math
.BR
Boolean arithmetic is accomplished by entering Boolean expressions
on the command line:
.IP 5
.AF
pc [6502] 5> "foo" > "bar"
pc [1] 6> _
.AF 1
.IP
Any true expression sets the result register to one, while a false expression
sets it to zero.  Boolean operations against the result register are allowed
by entering a relational operator as the first argument on the command line.
.PP
.PP Precedence
.BR
Use ( parentheses ) to enclose operations to be performed first.  Operations
buried deepest within parenthesis (that is, parentheses inside parentheses)
are performed first.
.PP
_Pc_'s precedence rules are to collect and evaluate nested parenthetical
expressions first, then perform multiplication and division (left to right),
followed by addition and subtraction (left to right).
.PP
.PP Commands
.BR
_Pc_ recognizes the following commands:
.LM 5
.IP 15 quit
(or q).  Quits _pc_.
.IP 15 clear
(or cl).  Clears memory, including the stack and all variables.  The result
register is reset to 0.
.IP 15 history
(or hist).  Displays a history of the previous commands entered and their
results.
.IP 15 help
(or ?).  Shows a list of the available commands.
.IP 15 do x[,y]
(or run).  Tells _pc_ to process history entries from x to y.  If y is
omitted, _pc_ processes line x only.  Intermediate results are shown
after each entry is processed.  All lines are processed, except for lines
containing do (or run) commands.
.IP 15 set var=expr
(or let).  Defines (or redefines) and sets the variable named var to the
evaluated expression expr.  The value of var is obtained by prefixing it with
the character $.  The result register is not affected.
.IP 15 define var=str
(or def).  Defines (or redefines) the variable named var to the string str.
The string contains an expression which is not evaluated until the variable
is used later in an expression.  The value of var is obtained by prefixing it
with the character $.  The result register is not affected.
.IP 15 print expr
Evaluates the expression expr and prints the result.  The result register
is not affected.
.IP 15 list
Lists the defined variables and their current values.
.IP 15 push [expr]
Pushes a value onto the stack.  If no argument is given, the current value
of the result register is pushed.  If an expression argument is given,
its value is pushed onto the stack.  The result register is not affected.
.IP 15 pull [var]
(or pop). Pulls the last pushed value off the stack.  If no argument is given,
the value pulled off the stack is stored into the result register.  If the
name of a variable is given (whether previously defined or not), the value
is stored in that variable, and the result register is not affected.
.IP 15 stack
Displays the contents of the stack.  The next item off the stack is the
last one listed.
.LM -5
.IP
.PP Constants and Keywords
.BR
_Pc_ comes with a constant for pi (3.141592653) referenced by the keyword PI.
In addition, the result register can be accessed in expressions by using
the keyword RESULT.  Example:
.IP 5
.AF
pc [1] 6> result * 3 * 3 * result
pc [9] 7> _
.AF 1
.IP
Notice how the initial value of result is retained throughout the entire
evaluation of the expression, resulting in 9.  (1 * 3 * 3 * 1 = 9).
.PP
.PP User Variables
.BR
You may define up to 32 variables for use in expressions.  Variables are
defined and initialized using the set (or let) and define (or def) commands.
.PP
Variables initialized with set have their expressions evaluated first,
and the result is stored in the variable.  That is to say, a variable
defined with set will simply hold a number.  Example:
.IP 5
.AF
pc [9] 8> set answer = asc("Life, the Universe, ...")-34
pc [9] 9> print $answer
     42
pc [9] 10> _
.AF 1
.IP
Variables initialized with define retain their expressions as a constant
value.  The result of the expression is evaluated at calculation time
when the variable is given in an expression.  Here are two simple
examples:
.IP 5
.AF
pc [9] 10> define faren = 1.8 * result + 32
pc [9] 11> define celsius = (result - 32) / 1.8
pc [9] 12> list
     $answer    = 42
     $faren     = 1.8 * result + 32
     $celsius   = (result - 32) / 1.8
pc [9] 13> _
.AF 1
.IP
Unlike the variable answer, set in the previous example, faren and celsius
retain their actual assignment rather than being evaluated.  They also
make use of the RESULT keyword so that their functions operate on the current
value of the result register.
.PP
If the result register holds the value 9 degrees Celsius, then entering
$faren on the command line will convert the value to its Fahrenheit
equivalent:
.IP 5
.AF
pc [9] 13> $faren
pc [48.2] 14> _
.AF 1
.IP
Conversely, entering $celsius changes the value back to Fahrenheit:
.IP 5
.AF
pc [48.2] 14> $celsius
pc [9] 15> _
.AF 1
.IP
.PP The Stack
.BR
The _pc_ provides a 32-entry stack for temporary storage of numbers.
You can push values onto the stack and pull them off in last-in, first-out
(LIFO) order.  Using the stack instead of declaring temporary variables
can speed up multi-line computations.
.SH Diagnostics
Typical diagnostic messages from _pc_ are:
.PP
``### syntax error''
.BR
Instructions given are improperly formatted or not recognized.
.PP
``### illegal quantity error''
.BR
A value used with a function is out of range.  For example, passing a value
greater than 255 to CHR$() causes this error.
.PP
``### overflow error''
.BR
A computation involved a number out of the range of the program.  _Pc_
can accept numbers in the range of 1E-38 to 1E+38.
.PP
``### division by zero error''
.BR
Self-explanatory.  This is not allowed.
.PP
``### type mismatch error''
.BR
A value passed to a function is not of the appropriate type.  This occurs,
for example, when passing a string to a numeric function, e.g., SGN(``a'').
.PP
``### out of memory error''
.BR
The variable table is full.
.SH Author
Morgan Davis (mdavis@pro-sol.cts.com)
