.TH PAR C
.DA 16 May 1992
.SH Name
par - ProLine archive utility
.SH Syntax
par [ _startdir_ ] [ _filelist_ ] [ _parfile_ ]
.SH Description
The _par_ command allows you to archive up to 255 files into a single ProLine
archive (.par) file.  For example, typing:
.IP 5
.AF
par $/etc/help $/etc/help update.par
.AF
.IP
packs all files in the $/etc/help directory to the file ``update.par''
in the current working directory.
.PP
The arguments are:
.IP 10 startdir
This is the path to the topmost directory containing files that will
be archived.  That includes files in subdirectories found below _startdir_
in the directory hierarchy.
.BR 2
Using $/ is usually a good starting directory.
.IP 10 filelist
This argument has special qualities.  If it describes the path to a
subdirectory, all of the non-directory entries in that subdirectory
will be chosen for archiving.  Note: this is not recursive.
.BR 2
If _filelist_ is a text file, it contains a list of filenames
(full or partial paths) to indicate the files that should be archived.
This file must contain one pathname entry per line.  (The _find_ command can
generate such a file--and it can be used to create a list of files
that descend through nested directories).
.IP 10 parfile
The _parfile_ argument is the name of the archive file to create.
.IP
If any of these arguments are omitted from the command line, _par_
prompts you for them, even the entry of the list of filenames.
.PP
.PP File Lists
.BR
Note that the files you choose for archiving must follow certain
rules.  The most important is that you should never introduce
a new path to a file that hasn't had its parent directory entered
beforehand.  For example, it's okay to select the file ``booga''
in ``$/ooga/booga'', so long as you chose ``$/ooga'' before it.
Also, none of the entries can specify a file that resides outside of
the _startdir_ hierarchy.
.PP
Archives will not contain the full path to the original archived
files.  Therefore, the person doing the unarchiving must be sure
about where the contents of the archive will be stored.
.SH Note
_Par_ currently creates archives in the Binary II format,
but this may not always be the case.  No compression is done.
.SH See Also
find(C), unpar(C)
