.TH DSTAT C
.DA 30 September 1993
.SH Name
dstat - Directory access status
.SH Syntax
dstat [ _opcode_-_permission_ ] [ _directory_ ] ...
.SH Description
Without any arguments, _dstat_ displays the directory
access status for the current working directory. By giving one or more
directory names as arguments, _dstat_ reports their associated access
statuses.
.PP
(The access status pertains only to other users who do not own the specified
directories.  This is because the owner of a directory holds full access for
its contents.)
.PP
When a directory is first created, it has no access permission levels
assigned.  By using _dstat_ with _permission_ flags, however, the following
statuses can be set or cleared:
.IP 5 r
Read permission - viewing, searching, downloading, and copying
to other files.
.IP 5 w
Write permission - creating files (but not modifying existing files).
.IP 5 d
Delete permission - complete removal and destruction of files.
.IP 5 x
Execute permission - the ability to execute programs and shell scripts.
.IP
To make changes, prefix the permission characters with an opcode as
follows:
.IP 5 -
Removes permissions
.IP 5 =
Sets absolute permissions
.IP 5 +
Adds permissions
.IP
Examples:
.IP 5
.AF
dstat +rw      # add read and write access
dstat =x       # set only execution permission
dstat -d       # remove delete permission
dstat +        # (same as = alone) grant full access
dstat -        # remove all permissions
.AF
.IP
You can give more than one permission at a time by including
multiple permission characters after the opcode.  If permission
characters are omitted, full access is either granted (+/=) or removed (-).
.PP
When _dstat_ is told to adjust a permission level, it assumes the current
working directory if no _directory_ argument is given.  Multiple directories
can be set to the same permission levels by specifying more than one
directory in the command line.
.SH IMPORTANT
The system administrator should _NOT_ allow both _WRITE_ _AND_ _EXECUTE_
permission in a directory outside of the $/usr hierarchy!
Doing this would allow a user to upload a
program or binary file, execute it, and cause potential havoc,
catastrophic event, cataclysmic disaster, or worse.  The shell limits
execution to shell script files by non-root users within the $/usr
hierarchy. Therefore, write+execute permission is safe here.
.SH Programmer's Note
Directory permission settings are stored in the lower 4 bits of the
auxiliary field in the directory's file information.  Arbitrarily
changing these bits could have disastrous effects should it allow for
``destroy'' permission in a system directory.  The bit assignments are:
.IP 5
.AF
+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
|  |  |  |  |  |  |  |  |  |  |  |  | x| d| w| r|
+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
 15 14 13 12 11 10  9  8  7  6  5  4  3  2  1  0
.AF 1
.BR
Auxiliary Field in Directory Files
.IP
Bits 4 through 15 are reserved for future use.
.SH See Also
mkdir(C), setfile(C)
