.TH CS C
.DA 6 May 1992
.SH Name
cs - Conference System
.SH Syntax
cs
.SH Description
The _cs_ command invokes the conference system.  It is called a ``conference
system'' instead of a ``bulletin board'' or ``message base'' because
active participation by system members is encouraged.
.PP
The conference system is where system members gather to discuss a
variety of topics in open or closed forums.  Networked conferences can
include offsite participants, expanding the forums to users on
computer systems around the world.
.PP
This tutorial will help you master the operation of CS in just a few
minutes.  First, all you really need to know to get around in the
conference system is the RETURN (or ENTER) key. When you press RETURN,
you are taken from one unread message to the next, from one topic to
another, and so on.
.PP
Of course, if you find yourself wondering what to do next, you can type
the question mark key (?) and a list of available commands or responses
will be shown.
.PP
.PP About Conferences and Topics
.BR
Each conference is dedicated to the discussion of one particular
subject. For example, music.  Within the ``music'' conference, there may
be one or more subconferencing areas, called _topics_.  Topics for the
``music'' conference might be ``concerts'', ``discs'', ``reviews'', and
so on.
.PP
Conferences come in two flavors: _Open_ and _Closed_.  An Open conference
is one that anyone can join, while a Closed conference is by invitation
only.
.PP
There are two kinds of topics, too: _Local_ and _Networked_.  Local topics
are those in which only local system members participate.  Networked
topics let the whole world in on the act!  People from remote sites,
sometimes as far away as the other side of the world, exchange messages
in networked topics.
.PP
.PP Getting Started
.BR
Your first step in using the conference system will be to join conferences
that interest you, then read some or all of the existing messages, respond to
them, and add your own to the discussion.
.PP
There are three main areas in the conference system:
.IP 10 cs>
Select and work with conferences and topics.
.IP 10 read>
Read messages and switch topics in a conference.
.IP 10 add>
Enter text to create a new message.
.IP
You can get a detailed list of commands at each prompt by pressing ``?''.
.PP
.PP Joining A Conference
.BR
When you first enter CS, press RETURN to join the first conference with
new messages since your last visit.  If there are no new messages, you
can choose to join a conference by using the (J)oin command.
.PP
.PP Reading Messages
.BR
Once you've joined a conference and entered into a topic area, press
RETURN to being reading new messages.  Popular commands at the read>
prompt are:
.IP 10 Next
Display the next unread message.
.BR 2
Next takes you from one unread message to the Next.  When you run out of
unread messages in one conference/topic, Next takes you to the next
conference you're joined to with unread messages.
.IP 10 Skip
Change your unread message pointer.
.BR 2
If you've joined a new conference that has an over- whelming number of
unread messages, you may choose not to read them all.  Use Skip to skip
over messages you don't want to read.
.IP 10 Add
Add a new message to the conference/topic.
.BR 2
Add allows you to add a brand new message.  You're asked to
describe the subject of your message, and then you can
begin writing it.  This takes you to the add> prompt.
.IP 10 Reply
Reply to a message.
.BR 2
Like Add, Reply lets you contribute to the discussion. Use this command
when you want to continue an ongoing discussion.	
.IP
There are many more commands than those listed above.  Type ``?'' at the
read> prompt to see the complete listing of available commands.
.PP
.PP Adding or Replying
.BR
When you Add or Reply to a message, you're asked to enter the
``Subject'' of your contribution.  Type in a brief description that
summarizes what your message is about.
.PP
Next, type in your message.  As with a pad of paper, you can write out
your comment and edit it before you add it to the discussion. If you
make a mistake in the line you are presently typing, you can backspace
and correct it.  If you want to make a change in an earlier line,
finish the note and edit it later.
.PP
When done entering text, type a period on a new line and press RETURN. 
This takes you to the add> prompt where you can save or edit your
message, as well as other options.
.PP
.PP Now You're Ready!
.BR
You now know enough about CS to use it effectively.  Remember that you
can always use ``?'' if you need to see a list of available commands no
matter where you are.  If you ever get into a situation that you wish
you could get out of, use your Cancel Key (usually Control-C).  Call
upon the system administrator or one who is knowledgeable with the
operation of the system if you find you need further assistance. 
.PP
.PP Quick Start Checklist
.BR
Upon entering CS, you may want to:
.IP 5 1.
Use (L)ist to see a listing of available conferences.
.IP 5 2.
Then use (J)oin to subscribe to a conference that interests you.
.IP 5 3.
Finally, just keep pressing RETURN to read each unread message in
succession until there are no more.
.IP
Happy Conferencing!
.SH Files
$/bin/csx - CS core program (loads faster from a RAM disk),
.BR
$/sys/pcs/cs.herald - Initial greeting upon entering _cs_,
.BR
$/sys/pcs/cs.list - list of conferences with descriptions,
.BR
$/etc/rsrc/cs.rsrc - CS resources,
.BR
$/etc/default/csdata - list of default conferences users join,
.BR
$/adm/*/csdata - data files for each cs member,
.BR
$/etc/help/* - help files for CS commands.
.SH See Also
cs(F), cs.maint(C), csmod(C), postnews(C)
