.TH CALENDAR C
.DA 6 May 1992
.SH Name
calendar - Personal calendar
.SH Syntax
calendar [ -e ] [ _eventfile_ ]
.SH Description
_Calendar_ reminds you of upcoming events.  The events are displayed when
_calendar_ is called, usually from the login script.
.PP
To set up a list of events, you must create a file called ``events'' in
your user directory. Example:
.IP 5
.AF
DOW  Dy Mon Yr
***  15 Aug **
National Frozen Pizza Day
Wed! ** Sep **
Dart League, 11:30 PM
+10! 31 Oct **
Start working on Halloween costume
***!  7 Dec **
File:daves.birthday
END
.AF
.IP
The first line _must_ be included exactly as shown, or _calendar_ will ignore
the entire file.  Each event entry consists of two lines, a date line and a
message line.  The date line can include wildcard characters for a ``don't
care'' situation.  The date line must be formatted exactly as shown, or that
event will be ignored. A maximum of 99 events can be stored.
.PP
In the example above, the first event is to occur on August 15th, with the
day of week and year ignored.  If _calendar_ is called on August 15th, the
message ``National Frozen Pizza Day'' will be displayed.
.PP
If _calendar_ is called on any Wednesday in September, the second event is
triggered, and the message ``Dart League, 11:00 PM'' is displayed.
.PP
The third event is an example of look-ahead.  The first character on the date
line is a ``+'', followed by the number of days advance notice required (up to
99).  In the example, the message ``Start working on Halloween costume'' will
be displayed every day between October 21 and October 31, along with a
countdown of the number of days until the event occurs.  After October 31,
the message will no longer be displayed.  Wildcards may be used in
combination with look-ahead. When wildcards are used with look-ahead,
_calendar_ will check the following month or year if appropriate. For
example:
.IP 5
.AF
+10!  5 *** **
Pay phone bill
.AF
.IP
This event would be displayed from about the 25th of the month (depending on
which month) through the 5th of the following month. If the current date is
December 31, ``5 days until:'' will be displayed, since _calendar_ will look
past the end of the year.
.PP
The last three examples show a feature new to v1.5 - auto-delete.  If the
fourth character of the date line is a ``!'', the event will be saved after it
is displayed.  If the ``!'' is missing, the event will be deleted after it is
displayed.  For look-ahead events, the event will not be deleted until the
actual date occurs.
.PP
The last line of the file must be ``END'' by itself, or calendar will give an
error.
.PP
The ``events'' file can also be created and edited with the built-in editor. To
use the editor, invoke _calendar_ with the -e parameter. The editor is
quite self-explanatory.
.PP
Version 1.6 includes an improved editor and adds two new features: alternate
eventfile, and textfile display.
.PP
The alternate eventfile works just like the main one, except the filename
must be used when calling _calendar_. Simply use ``calendar alt.events'' or
``calendar -e alt.events''. The alternate events file may use any legal
filename, and there is no limit to the number of alternate files.
.PP
The textfile display feature allows you to display any textfile as the
message for a given event. This makes it easy to add multiple events for a
particular day, or to make a special sign. To use this feature, enter
``File:filename'' as the message text for that day (as shown in the fourth
example).
.SH Files
$/usr/*/events - User's default event list.
.SH Author
David Zachmeyer.  Bug reports or suggestions should be sent to djz@pro-phc.
