;msgcomp2: Compress message system in-place
;
MIN_KILLED	EQU	10	;Usually 25.
;
*GET	DOSCALLS
*GET	EXTERNAL
*GET	ASCII
;
	ORG	PROG_START
	DEFW	BASE
	DEFW	THIS_PROG_END
	DEFW	0
	DEFW	0
;End of program load info.
;
	COM	'<msgcomp2 2.0  19-Feb-87>'
;
	ORG	BASE+100H
START	LD	SP,START
	LD	A,(38FFH)
	OR	A
	JR	NZ,START
;
	LD	A,(PRIV_1)
	BIT	IS_SYSOP,A
	JP	Z,TERMINATE
;
	LD	HL,0
	LD	(MOVED),HL
	LD	HL,-1
	LD	(THIS_MSG_O),HL
	LD	(THIS_MSG_N),HL
;
	LD	HL,MSGBUFF
	LD	(BUF_PTR),HL
	LD	HL,0
	LD	(BUF_LEN),HL
;
	CALL	OPEN_FILES	;Open all files
	CALL	CHK_COUNTS	;exit if too few killed
	CALL	FIND_KILLED	;find first killed msg
;
	CALL	MOVE_MSG	;relocate text.
	JP	Z,EXIT
	JP	EXIT
;
MOVE_MSG
	LD	HL,(THIS_MSG_O)
	INC	HL
	LD	(THIS_MSG_O),HL
	LD	DE,(NUM_MSG)
	OR	A
	SBC	HL,DE
	JP	Z,FINISHED
;
MM_02
	CALL	READ_HDR_REC	;Hdr and TOP file byte.
;
	LD	A,(OLD_HDR_FLAG)
	BIT	FM_KILLED,A
	JP	NZ,MOVE_MSG	;ignore if killed.
;
	LD	HL,OLD_HDR_REC
	LD	DE,NEW_HDR_REC
	LD	BC,16
	LDIR
;
	LD	A,(LAST_TXT_EOF)
	LD	(NEW_HDR_RBA),A
	LD	HL,(LAST_TXT_EOF+1)
	LD	(NEW_HDR_RBA+1),HL
;
;
	LD	A,(TOPIC_BYTE)
	LD	B,A
	LD	A,(NEW_HDR_TOPIC)
	CP	B
	JR	Z,MM_05
;
	LD	HL,M_COR_TOP1
	CALL	LOG_MSG_2
	LD	HL,(THIS_MSG_O)
	LD	DE,STRING
	CALL	SPUTNUM
	LD	HL,M_SPACE
	CALL	STRCAT
	LD	A,(TOPIC_BYTE)
	LD	L,A
	LD	H,0
	CALL	SPUTNUM
	LD	HL,M_SPACE
	CALL	STRCAT
	LD	A,(NEW_HDR_TOPIC)
	LD	L,A
	LD	H,0
	CALL	SPUTNUM
	LD	HL,STRING
	CALL	LOG_MSG_2
	LD	HL,M_CR
	CALL	LOG_MSG_2
;
	LD	A,(NEW_HDR_TOPIC)
	LD	(TOPIC_BYTE),A
;
MM_05
;
	LD	A,(OLD_HDR_RBA)
	LD	C,A
	LD	HL,(OLD_HDR_RBA+1)
	LD	DE,OLD_TXT
	CALL	DOS_POS_RBA
	JP	NZ,ERROR
;
	LD	DE,OLD_TXT
	CALL	$GET
	JP	NZ,ERROR
	CP	0FFH
	JP	NZ,CORRUPT
	CALL	PUTBUF
;
	LD	DE,OLD_TXT
	CALL	$GET
	JP	NZ,ERROR
	CALL	PUTBUF
;
	LD	DE,OLD_TXT
	CALL	$GET
	JP	NZ,ERROR
	CALL	PUTBUF
;
MM_03	LD	DE,OLD_TXT
	CALL	$GET
	JP	NZ,ERROR
	OR	A
	JR	Z,MM_04
	CALL	PUTBUF
	JR	MM_03
;
MM_04
	CALL	PUTBUF
;
	CALL	WRITE_HDR_REC	;And TOP file byte.
	LD	HL,OLD_HDR_FLAG
	SET	FM_KILLED,(HL)
;
	LD	DE,OLD_HDR
	CALL	DOS_BACK_RECD
	JP	NZ,ERROR
;
	CALL	DOS_WRIT_SECT
	JP	NZ,ERROR
;
	LD	HL,(MOVED)
	INC	HL
	LD	(MOVED),HL
;
	LD	HL,(THIS_MSG_N)
	INC	HL
	LD	(THIS_MSG_N),HL
	JP	MOVE_MSG
;
FINISHED
;If EOF ...
	LD	HL,(THIS_MSG_N)
	LD	(NUM_MSG),HL
	LD	HL,0
	LD	(NUM_KLD_MSG),HL
;
	LD	A,(LAST_TXT_EOF)
	LD	(EOF_RBA),A
	LD	HL,(LAST_TXT_EOF+1)
	LD	(EOF_RBA+1),HL
;
;
	LD	DE,OLD_TOP
	CALL	DOS_REWIND
	JP	NZ,ERROR
;
	LD	HL,STATS_REC
	LD	B,16
MM_01	LD	A,(HL)
	CALL	$PUT
	JP	NZ,ERROR
	INC	HL
	DJNZ	MM_01
;
	;close files & stuff
;Ensure text file has shrunk (freeing lotsa lovely space)
;by setting EOF equal to NEXT.
	LD	A,(LAST_TXT_EOF)
	LD	(OLD_TXT+8),A	;EOF  low
	LD	HL,(LAST_TXT_EOF+1)
	LD	(OLD_TXT+12),HL	;EOF  mid/high
;
	LD	DE,OLD_TXT
	CALL	DOS_CLOSE
	LD	DE,OLD_HDR
	CALL	DOS_CLOSE
	LD	DE,OLD_TOP
	CALL	DOS_CLOSE
	JP	EXIT		;exit
;
READ_HDR_REC
	LD	HL,(THIS_MSG_O)
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	LD	C,L
	LD	L,H
	LD	H,0
	LD	DE,OLD_HDR
	CALL	DOS_POS_RBA
	JP	NZ,ERROR
;
	LD	HL,OLD_HDR_REC
	CALL	DOS_READ_SECT
	JP	NZ,ERROR
;
	LD	HL,(THIS_MSG_O)
	LD	A,16
	ADD	A,H
	LD	C,L
	LD	L,A
	LD	H,0
	LD	DE,OLD_TOP
	CALL	DOS_POS_RBA
	JP	NZ,ERROR
;
	CALL	$GET
	JP	NZ,ERROR
;
	LD	(TOPIC_BYTE),A
	RET
;
WRITE_HDR_REC
	LD	HL,(THIS_MSG_N)
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	LD	C,L
	LD	L,H
	LD	H,0
	LD	DE,OLD_HDR
	CALL	DOS_POS_RBA
	JP	NZ,ERROR
;
	LD	HL,NEW_HDR_REC
	CALL	DOS_WRIT_SECT
	JP	NZ,ERROR
;
	LD	HL,(THIS_MSG_N)
	LD	A,H
	ADD	A,16
	LD	C,L
	LD	L,A
	LD	H,0
	LD	DE,OLD_TOP
	CALL	DOS_POS_RBA
	JP	NZ,ERROR
;
	LD	A,(TOPIC_BYTE)
	CALL	$PUT
	JP	NZ,ERROR
	RET
;
FIND_KILLED
	LD	HL,(THIS_MSG_O)
	INC	HL
	LD	(THIS_MSG_O),HL
	LD	(THIS_MSG_N),HL
;
	LD	A,(OLD_HDR_RBA)	;TXT rba for last unkilled
	LD	(LAST_TXT_EOF),A
	LD	HL,(OLD_HDR_RBA+1)
	LD	(LAST_TXT_EOF+1),HL
;
	CALL	READ_HDR_REC
	LD	A,(OLD_HDR_FLAG)
	BIT	FM_KILLED,A
	JR	Z,FIND_KILLED		;loop until found
;
;
;
;If THIS_MSG_O = 0000, (ie first msg killed), then there
;is NO previous TXT file rba, hence TXT file is already
;positioned to the correct starting place (000000).
;
	LD	HL,(THIS_MSG_O)
	LD	A,H
	OR	L
	RET	Z
;
;Try and position text file.
	LD	A,(LAST_TXT_EOF)
	LD	C,A
	LD	HL,(LAST_TXT_EOF+1)
	LD	DE,NEW_TXT
	CALL	DOS_POS_RBA
	JP	NZ,ERROR
;
	LD	DE,OLD_TXT	;Read flag FF
	CALL	$GET
	JP	NZ,ERROR
	CP	0FFH
	JP	NZ,CORRUPT
	CALL	$GET		;Read unused byte 1
	JP	NZ,ERROR
	CALL	$GET		;Read unused byte 2
	JP	NZ,ERROR
FK_02				;Read till end msg
	CALL	$GET
	JP	NZ,ERROR
	OR	A
	JR	NZ,FK_02	;find EOM.
;
	LD	A,(OLD_TXT+5)
	LD	(LAST_TXT_EOF),A
	LD	HL,(OLD_TXT+10)
	LD	(LAST_TXT_EOF+1),HL
	RET
;
OPEN_FILES
	LD	DE,OLD_TXT
	LD	HL,OLD_TXT_BUF
	LD	B,0
	CALL	DOS_OPEN_EX
	JP	NZ,ERROR
;
	LD	DE,OLD_HDR
	LD	HL,OLD_HDR_BUF
	LD	B,16
	CALL	DOS_OPEN_EX
	JP	NZ,ERROR
;
	LD	DE,OLD_TOP
	LD	HL,OLD_TOP_BUF
	LD	B,0
	CALL	DOS_OPEN_EX
	JP	NZ,ERROR
;
	LD	B,0F8H		;add all perms
	LD	C,44H		;write + extend only
;
	LD	A,(OLD_TOP+1)
	AND	B
	OR	C
	LD	(OLD_TOP+1),A
;
	LD	A,(OLD_TXT+1)
	AND	B
	OR	C
	LD	(OLD_TXT+1),A
;
	LD	A,(OLD_HDR+1)
	AND	B
	OR	C
	LD	(OLD_HDR+1),A
;
	RET
;
CHK_COUNTS
	LD	HL,STATS_REC	;Read stats
	LD	DE,OLD_TOP
	LD	B,16
CC_01	CALL	$GET
	JP	NZ,ERROR
	LD	(HL),A
	INC	HL
	DJNZ	CC_01
;
	LD	HL,(NUM_KLD_MSG)
	LD	DE,MIN_KILLED
	OR	A
	SBC	HL,DE
	LD	A,0
	JP	C,TERMINATE	;if too few killed.
;
	RET
;
CORRUPT
	LD	HL,M_CORRUPT
	LD	DE,($STDOUT)
	CALL	MESS_0
	LD	HL,M_CORRUPT
	CALL	LOG_MSG
	LD	A,15
	JP	TERMINATE
;
LOG_MSG_2
	PUSH	HL
	CALL	LOG_MSG
	POP	HL
	LD	DE,$DO
	CALL	MESS_0
	RET
;
EXIT
	XOR	A
	JP	TERMINATE
;
ERROR	PUSH	AF
	OR	80H
	CALL	DOS_ERROR
;
	LD	DE,OLD_TXT	;Rewind files to write
	CALL	DOS_REWIND	;any updated sectors
	LD	DE,OLD_TOP	;without the EOF hassles
	CALL	DOS_REWIND	;of closing the files.
	LD	DE,OLD_HDR
	CALL	DOS_REWIND
;
	POP	AF
	JP	TERMINATE
;
*GET	ROUTINES
;
BUF_PTR		DEFW	0
BUF_LEN		DEFW	0
MOVED		DEFW	0
THIS_MSG_O	DEFW	0
THIS_MSG_N	DEFW	0
TOPIC_BYTE	DEFW	0
LAST_TXT_EOF	DEFB	0,0,0
;
STRING	DEFS	80
;
M_COR_TOP1
	DEFM	'** topic code corrupt, ',0
M_CORRUPT
	DEFM	'Corrupt files: First byte of msg is not FF',CR,0
M_SPACE	DEFM	'  ',0
M_CR	DEFM	CR,0
;
;msghdr.hdr: format of MSGHDR.ZMS file.
;Last updated 03-Oct-86
;
;
OLD_HDR_REC
OLD_HDR_FLAG	DEFB	0
OLD_HDR_LINES	DEFB	0
OLD_HDR_RBA	DEFB	0,0,0
OLD_HDR_DATE	DEFB	0,0,0
OLD_HDR_SNDR	DEFW	0
OLD_HDR_RCVR	DEFW	0
OLD_HDR_TOPIC	DEFB	0
OLD_HDR_TIME	DEFB	0,0,0
;
;Format of HDR_FLAG
FM_KILLED	EQU	0
FM_PRIVATE	EQU	1
FM_IMPORT	EQU	2
FM_RUDE		EQU	3
FM_NETMSG	EQU	4
FM_NETSENT	EQU	5
;
;End of msghdr.
OLD_TXT	DEFM	'msgtxt.zms',CR
	DC	32-11,0
OLD_HDR	DEFM	'msghdr.zms',CR
	DC	32-11,0
OLD_TOP	DEFM	'msgtop.zms',CR
	DC	32-11,0
;
*GET	MSGTOP
;
OLD_TXT_BUF	DEFS	256
OLD_HDR_BUF	DEFS	256
OLD_TOP_BUF	DEFS	256
;
MSGBUFF	DEFS	1024
THIS_PROG_END	EQU	$
;
	END	START
