;msgcomp: Compress message system in-place
;
MIN_KILLED	EQU	10	;Usually 25.
;
*GET	DOSCALLS
*GET	EXTERNAL
*GET	ASCII
;
	ORG	PROG_START
	DEFW	BASE
	DEFW	THIS_PROG_END
	DEFW	0
	DEFW	0
;End of program load info.
;
	COM	'<msgcomp 1.1  27-Dec-87>'
;
	ORG	BASE+100H
START	LD	SP,START
	LD	A,(38FFH)
	OR	A
	JR	NZ,START
;
	LD	A,(PRIV_1)
	BIT	IS_SYSOP,A
	JP	Z,TERMINATE
;
	LD	HL,0
	LD	(MOVED),HL
	LD	HL,-1
	LD	(THIS_MSG_O),HL
	LD	(THIS_MSG_N),HL
;
	CALL	OPEN_FILES	;Open all files
	CALL	CHK_COUNTS	;exit if too few killed
;Now: old_top,new_top are positioned to rba 0x1000
	CALL	FIND_KILLED	;find first killed msg
;old hdr & old top are positioned after the first killed
;new hdr & new top are positioned AT the first killed.
;
	CALL	MOVE_MSG	;relocate hdr & top field
	JP	EXIT
;
MOVE_MSG
	LD	HL,(THIS_MSG_O)
	INC	HL
	LD	(THIS_MSG_O),HL
	LD	DE,(NUM_MSG)
	OR	A
	SBC	HL,DE
	JP	Z,FINISHED
;
MM_02
	CALL	READ_HDR_REC	;Read old hdr & top
;
	LD	A,(OLD_HDR_FLAG)
	BIT	FM_KILLED,A
	JP	NZ,MOVE_MSG	;ignore if killed.
;
	LD	HL,OLD_HDR_REC	;Copy header
	LD	DE,NEW_HDR_REC
	LD	BC,16
	LDIR
;
	LD	HL,(THIS_MSG_N)
	INC	HL
	LD	(THIS_MSG_N),HL
;
	LD	A,(TOPIC_BYTE)
	LD	B,A
	LD	A,(NEW_HDR_TOPIC)
	CP	B
	JR	Z,MM_05
;
	CALL	CORR_MSG
;
MM_05
	CALL	WRITE_HDR_REC	;Write new hdr & top
;
	LD	HL,OLD_HDR_FLAG	;Set old msg killed
	SET	FM_KILLED,(HL)
;
	LD	DE,OLD_HDR
	CALL	DOS_BACK_RECD
	JP	NZ,ERROR
;
	CALL	DOS_WRIT_SECT
	JP	NZ,ERROR
;
	LD	HL,(MOVED)
	INC	HL
	LD	(MOVED),HL
	JP	MOVE_MSG
;
FINISHED
;If EOF ...
	LD	HL,(THIS_MSG_N)
	LD	(NUM_MSG),HL
	LD	HL,0
	LD	(NUM_KLD_MSG),HL
;
;
	LD	DE,NEW_TOP
	CALL	DOS_REWIND
	JP	NZ,ERROR
;
	LD	HL,STATS_REC
	LD	B,16
MM_01	LD	A,(HL)
	CALL	$PUT
	JP	NZ,ERROR
	INC	HL
	DJNZ	MM_01
;
	;close files & stuff
	LD	DE,NEW_TOP
	CALL	DOS_CLOSE
;
	LD	DE,NEW_HDR
	CALL	DOS_CLOSE
	JP	EXIT		;exit
;
CORR_MSG
	LD	HL,M_COR_TOP1
	CALL	LOG_MSG_2
	LD	HL,(THIS_MSG_O)
	LD	DE,STRING
	CALL	SPUTNUM
	LD	HL,M_SPACE
	CALL	STRCAT
	LD	A,(TOPIC_BYTE)
	LD	L,A
	LD	H,0
	CALL	SPUTNUM
	LD	HL,M_SPACE
	CALL	STRCAT
	LD	A,(NEW_HDR_TOPIC)
	LD	L,A
	LD	H,0
	CALL	SPUTNUM
	LD	HL,STRING
	CALL	LOG_MSG_2
	LD	HL,M_CR
	CALL	LOG_MSG_2
;
	LD	A,(NEW_HDR_TOPIC)
	LD	(TOPIC_BYTE),A
	RET
;
READ_HDR_REC
	LD	HL,OLD_HDR_REC
	LD	DE,OLD_HDR
	CALL	DOS_READ_SECT
	JP	NZ,ERROR
	LD	DE,OLD_TOP
	CALL	$GET
	JP	NZ,ERROR
	LD	(TOPIC_BYTE),A
	RET
;
WRITE_HDR_REC
	LD	HL,NEW_HDR_REC
	LD	DE,NEW_HDR
	CALL	DOS_WRIT_SECT
	JP	NZ,ERROR
	LD	A,(TOPIC_BYTE)
	LD	DE,NEW_TOP
	CALL	$PUT
	JP	NZ,ERROR
	RET
;
FIND_KILLED
	LD	HL,(THIS_MSG_O)
	INC	HL
	LD	(THIS_MSG_O),HL
	LD	(THIS_MSG_N),HL
;
	CALL	READ_HDR_REC
;
	LD	A,(OLD_HDR_FLAG)
	BIT	FM_KILLED,A
	JR	NZ,FOUND_KILLED
;Keep new hdr & top files in line
	LD	DE,NEW_HDR
	LD	HL,NEW_HDR_REC
	CALL	DOS_READ_SECT
	JP	NZ,ERROR
	LD	DE,NEW_TOP
	CALL	$GET
	JP	NZ,ERROR
	JR	FIND_KILLED		;loop until found
;
FOUND_KILLED
	RET
;
OPEN_FILES
;
	LD	DE,OLD_HDR
	LD	HL,OLD_HDR_BUF
	LD	B,16
	CALL	DOS_OPEN_EX
	JP	NZ,ERROR
;
	LD	DE,OLD_TOP
	LD	HL,OLD_TOP_BUF
	LD	B,0
	CALL	DOS_OPEN_EX
	JP	NZ,ERROR
;
	LD	DE,NEW_HDR
	LD	HL,NEW_HDR_BUF
	LD	B,16
	CALL	DOS_OPEN_EX
	JP	NZ,ERROR
;
	LD	DE,NEW_TOP
	LD	HL,NEW_TOP_BUF
	LD	B,0
	CALL	DOS_OPEN_EX
	JP	NZ,ERROR
;
	LD	B,0F8H		;add all perms
	LD	C,5		;read perms
;
	LD	A,(OLD_TOP+1)
	AND	B
	OR	C
	LD	(OLD_TOP+1),A
;
	LD	A,(OLD_HDR+1)
	AND	B
	OR	40H		;prevent OLD_HDR shrink
	LD	(OLD_HDR+1),A
;
	LD	A,(NEW_TOP+1)
	AND	B
	OR	40H
	LD	(NEW_TOP+1),A
;
	LD	A,(NEW_HDR+1)
	AND	B
	OR	40H
	LD	(NEW_HDR+1),A
	RET
;
CHK_COUNTS
	LD	HL,STATS_REC	;Read stats
	LD	DE,OLD_TOP
	LD	B,16
CC_01	CALL	$GET
	JP	NZ,ERROR
	LD	(HL),A
	INC	HL
	DJNZ	CC_01
;
	LD	HL,(NUM_KLD_MSG)
	LD	DE,MIN_KILLED
	OR	A
	SBC	HL,DE
	LD	A,0
	JP	C,TERMINATE	;if too few killed.
;
	LD	HL,16		;Position new TOP file
	LD	C,0
	LD	DE,NEW_TOP
	CALL	DOS_POS_RBA
	JP	NZ,ERROR
;
	LD	HL,16		;Position old TOP file
	LD	C,0
	LD	DE,OLD_TOP
	CALL	DOS_POS_RBA
	JP	NZ,ERROR
	RET
;
LOG_MSG_2
	PUSH	HL
	CALL	LOG_MSG
	POP	HL
	LD	DE,$DO
	CALL	MESS_0
	RET
;
EXIT
	XOR	A
	JP	TERMINATE
;
ERROR	PUSH	AF
	OR	80H
	CALL	DOS_ERROR
;
;
	POP	AF
	JP	TERMINATE
;
*GET	ROUTINES
;
MOVED		DEFW	0
THIS_MSG_O	DEFW	0
THIS_MSG_N	DEFW	0
TOPIC_BYTE	DEFW	0
;
STRING	DEFS	80
;
M_COR_TOP1
	DEFM	'** topic code corrupt, ',0
M_SPACE	DEFM	'  ',0
M_CR	DEFM	CR,0
;
;msghdr.hdr: format of MSGHDR.ZMS file.
;Last updated 03-Oct-86
;
;
OLD_HDR_REC
OLD_HDR_FLAG	DEFB	0
OLD_HDR_LINES	DEFB	0
OLD_HDR_RBA	DEFB	0,0,0
OLD_HDR_DATE	DEFB	0,0,0
OLD_HDR_SNDR	DEFW	0
OLD_HDR_RCVR	DEFW	0
OLD_HDR_TOPIC	DEFB	0
OLD_HDR_TIME	DEFB	0,0,0
;
;Format of HDR_FLAG
FM_KILLED	EQU	0
FM_PRIVATE	EQU	1
FM_IMPORT	EQU	2
FM_RUDE		EQU	3
FM_NETMSG	EQU	4
FM_NETSENT	EQU	5
;
;End of msghdr.
;msghdr.hdr: format of MSGHDR.ZMS file.
;Last updated 03-Oct-86
;
NEW_HDR_REC
NEW_HDR_FLAG	DEFB	0
NEW_HDR_LINES	DEFB	0
NEW_HDR_RBA	DEFB	0,0,0
NEW_HDR_DATE	DEFB	0,0,0
NEW_HDR_SNDR	DEFW	0
NEW_HDR_RCVR	DEFW	0
NEW_HDR_TOPIC	DEFB	0
NEW_HDR_TIME	DEFB	0,0,0
;
;End of msghdr.
;
NEW_HDR	DEFM	'msghdr.zms',CR
	DC	32-11,0
NEW_TOP	DEFM	'msgtop.zms',CR
	DC	32-11,0
OLD_HDR	DEFM	'msghdr.zms',CR
	DC	32-11,0
OLD_TOP	DEFM	'msgtop.zms',CR
	DC	32-11,0
;
*GET	MSGTOP
;
NEW_HDR_BUF	DEFS	256
NEW_TOP_BUF	DEFS	256
OLD_HDR_BUF	DEFS	256
OLD_TOP_BUF	DEFS	256
;
THIS_PROG_END	EQU	$
;
	END	START
