;bbsquash: Squash TreeBoard messages..
;
*GET	DOSCALLS
*GET	EXTERNAL
*GET	ASCII
;
	ORG	PROG_START
	DEFW	BASE
	DEFW	THIS_PROG_END
	DEFW	0
	DEFW	0
;End of program load info.
;
	COM	'<bbsquash 1.2g 06-Apr-87>'
;
	ORG	BASE+100H
START	LD	SP,START
;
;ensure SYSOP or SYSTEM is running this.
	LD	A,(PRIV_1)
	BIT	IS_SYSOP,A
	LD	A,128
	JP	Z,TERMINATE
;
	LD	HL,M_FILDUP
	CALL	PUTS
	CALL	FIL_DUP
;
	LD	HL,M_TOPCOP
	CALL	PUTS
;
	CALL	TOP_COPY
;
	LD	HL,M_INFCOP
	CALL	PUTS
;
	CALL	INFO_COPY
;
	LD	HL,M_COUCOP
	CALL	PUTS
;
	CALL	COUNT_COPY
	CALL	DONE
;
	LD	HL,M_DONE
	CALL	PUTS
;
	LD	A,0
	JP	TERMINATE
;
FIL_DUP
	LD	HL,BUF_S_TXT
	LD	DE,FCB_S_TXT
	LD	B,0
	CALL	DOS_OPEN_EX
	JR	NZ,CANT_OPEN
	LD	A,(FCB_S_TXT+1)
	AND	0F8H
	OR	5
	LD	(FCB_S_TXT+1),A
;
	LD	HL,BUF_S_HDR
	LD	DE,FCB_S_HDR
	LD	B,16
	CALL	DOS_OPEN_EX
	JR	NZ,CANT_OPEN
	LD	A,(FCB_S_HDR+1)
	AND	0F8H
	OR	5
	LD	(FCB_S_HDR+1),A
;
	LD	HL,BUF_S_TOP
	LD	DE,FCB_S_TOP
	LD	B,0
	CALL	DOS_OPEN_EX
	JR	NZ,CANT_OPEN
	LD	A,(FCB_S_TOP+1)
	AND	0F8H
	OR	5	;Stops EOF shrink.
	LD	(FCB_S_TOP+1),A
;
;Open destination files...
	LD	HL,BUF_D_TXT
	LD	DE,FCB_D_TXT
	LD	B,0
	CALL	DOS_OPEN_NEW
	JR	NZ,CANT_CREATE
;
	LD	HL,STARTBUFFER
	LD	(OUTBUFFER),HL
;
	LD	HL,BUF_D_HDR
	LD	DE,FCB_D_HDR
	LD	B,16
	CALL	DOS_OPEN_NEW
	JR	NZ,CANT_CREATE
;
	LD	HL,BUF_D_TOP
	LD	DE,FCB_D_TOP
	LD	B,0
	CALL	DOS_OPEN_NEW
	JR	NZ,CANT_CREATE
;
	LD	HL,M_OPENOK
	CALL	MESS
	RET
CANT_OPEN
	PUSH	AF
	LD	HL,M_CNT_OPEN
	CALL	MESS
	POP	AF
	JP	ERROR
;
CANT_CREATE
	PUSH	AF
	LD	HL,M_CNT_CRT
	CALL	MESS
	POP	AF
	JP	ERROR
;
RET_NZ	XOR	A
	CP	1
	RET
RET_Z	CP	A
	RET
;
INFO_COPY
	LD	HL,0
	LD	(THIS_MSG),HL
	LD	(MSG_COUNT),HL
;
;Get msg header into buffer.
IC_01	LD	HL,(THIS_MSG)
	PUSH	HL
	LD	DE,(NUM_MSG)
	OR	A
	SBC	HL,DE
	POP	HL
	JP	Z,IC_END
	INC	HL
	LD	(THIS_MSG),HL
	LD	HL,HDR_BUFF
	LD	DE,FCB_S_HDR
	CALL	DOS_READ_SECT
	JP	NZ,ERROR
;
	CALL	GET_TOP		;Get message's topic
	LD	B,A
	LD	A,(HDR_TOPIC)
	CP	B
	CALL	NZ,CORRUPT_TOP
;
	LD	A,(HDR_FLAG)	;Check if deleted
	BIT	FM_KILLED,A
	JR	NZ,IC_01
;
	LD	HL,(MSG_COUNT)	;Not deleted so copy
	INC	HL
	LD	(MSG_COUNT),HL
;
	LD	A,(HDR_TOPIC)	;Write topic No. to TOP
	CALL	PUT_TOP
;
	LD	HL,HDR_RBA	;Position text file
	LD	C,(HL)
	INC	HL
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	EX	DE,HL
	LD	DE,FCB_S_TXT
	CALL	DOS_POS_RBA
	JP	NZ,ERROR
;
;
;Find "current" txt rba by adding bytes used in buffer
;to file rba.
	LD	HL,(OUTBUFFER)
	LD	DE,STARTBUFFER
	OR	A
	SBC	HL,DE
	LD	A,(FCB_D_TXT+5)
	ADD	A,L
	LD	(HDR_RBA),A
	LD	A,(FCB_D_TXT+10)
	ADC	A,H
	LD	(HDR_RBA+1),A
	LD	A,(FCB_D_TXT+11)
	ADC	A,0
	LD	(HDR_RBA+2),A
;
;
	CALL	GET_TXT		;Check & copy msg text
	CP	0FFH		;First byte must be FFH
	JP	NZ,CORRUPT_TXT1
	CALL	PUT_TXT
	CALL	GET_TXT
	LD	B,A
	LD	A,(HDR_FLAG)
	CP	B
;Not tested because of forwarding....
	CALL	PUT_TXT
	CALL	GET_TXT		;Read old "number of lines"
	XOR	A
IC_01D	CALL	PUT_TXT
;
IC_02
	CALL	GET_TXT
	PUSH	AF
	CALL	PUT_TXT
	POP	AF
	OR	A
	JR	NZ,IC_02
IC_03
;
;Write new header out
	LD	HL,HDR_BUFF
	LD	DE,FCB_D_HDR
	CALL	DOS_WRIT_SECT
	JP	NZ,ERROR
	JP	IC_01
;
IC_END
ICE_1	JP	RET_Z
;
TOP_COPY
	LD	HL,STATS_REC
	LD	B,16
TC_00A	PUSH	BC
	PUSH	HL
	CALL	GET_TOP
	PUSH	AF
	CALL	PUT_TOP
	POP	AF
	POP	HL
	LD	(HL),A
	INC	HL
	POP	BC
	DJNZ	TC_00A
;
	LD	BC,4096-16
TC_01	LD	A,B
	OR	C
	JR	Z,TC_02
	PUSH	BC
	CALL	GET_TOP
	CALL	PUT_TOP
	POP	BC
	DEC	BC
	JR	TC_01
TC_02	LD	HL,FCB_D_TOP+1
	SET	6,(HL)		;prevent top file shrink
	RET
;
MESS	LD	DE,$DO
	CALL	MESS_0
	RET
;
ERROR
	PUSH	AF
	LD	HL,M_ERROR
	CALL	LOG_MSG
	CALL	DO_CLOSE
	POP	AF
	PUSH	AF
	OR	80H
	CALL	DOS_ERROR
	POP	AF
	JP	TERMINATE
;
DO_CLOSE
;
;Flush...
	CALL	FLUSH
;
	LD	DE,FCB_S_TXT
	CALL	DOS_CLOSE
	RET	NZ
	LD	DE,FCB_S_HDR
	CALL	DOS_CLOSE
	RET	NZ
	LD	DE,FCB_S_TOP
	CALL	DOS_CLOSE
	RET	NZ
	LD	DE,FCB_D_TXT
	CALL	DOS_CLOSE
	RET	NZ
	LD	DE,FCB_D_HDR
	CALL	DOS_CLOSE
	RET	NZ
	LD	DE,FCB_D_TOP
	CALL	DOS_CLOSE
	RET	NZ
	RET
;
CORRUPT_TOP
	LD	HL,M_COR_TOP	;topic<->hdr mismatch
	CALL	CORRUPT
	RET
;
CORRUPT_TXT1
	LD	HL,M_COR_TXT1	;not ff.
	CALL	CORRUPT
	JP	ABORT_IT
;
CORRUPT_TXT2
	LD	HL,M_COR_TXT2	;Header flag differs.
	CALL	CORRUPT
	JP	ABORT_IT
;
CORRUPT_TXT3
	LD	HL,M_COR_TXT3	;Differing line count.
	CALL	CORRUPT
	RET
	JP	ABORT_IT
;
CORRUPT
	PUSH	HL
	LD	HL,M_CORRUPT	;ptr: "Corrupted!"
	CALL	LOG_MSG
	LD	HL,M_CORRUPT
	LD	DE,$DO
	CALL	FPUTS		;vdu: "Corrupted!"
;
	LD	HL,M_MESSAGE
	CALL	LOG_MSG
	LD	HL,M_MESSAGE
	LD	DE,$DO
	CALL	FPUTS
;
	LD	HL,(THIS_MSG)
	DEC	HL
	LD	DE,STRING
	CALL	SPUTNUM
;
	LD	HL,STRING
	CALL	LOG_MSG
	LD	HL,STRING
	LD	DE,$DO
	CALL	FPUTS
	POP	HL
	PUSH	HL
	CALL	LOG_MSG		;ptr: "Why..."
;
	POP	HL
	LD	DE,$DO
	CALL	FPUTS		;vdu: "Why..."
	RET
;
DECIDE
	LD	HL,M_DOWHAT
	LD	DE,$DO
	CALL	MESS_0
	LD	HL,IN_BUFF
	LD	B,1
	CALL	40H
	JP	C,ABORT_IT
	LD	A,(HL)
	AND	5FH
	RET
;
ABORT_IT
	CALL	DO_CLOSE
	JP	NZ,ERROR
	LD	A,81H
	JP	TERMINATE
;
GET_TXT
	LD	DE,FCB_S_TXT
GP_GET	CALL	$GET
	RET	Z
	JP	ERROR
GET_TOP
	LD	DE,FCB_S_TOP
	JR	GP_GET
PUT_TXT
	PUSH	HL
	LD	HL,(OUTBUFFER)
	PUSH	AF
	PUSH	BC
	LD	DE,ENDBUFFER
	OR	A
	SBC	HL,DE
	CALL	Z,FLUSH
	POP	BC
	POP	AF
	LD	HL,(OUTBUFFER)
	LD	(HL),A
	INC	HL
	LD	(OUTBUFFER),HL
	POP	HL
	RET
;
FLUSH	PUSH	BC
	PUSH	HL
;
	LD	DE,STARTBUFFER
FLUSH_1	LD	HL,(OUTBUFFER)
	OR	A
	SBC	HL,DE
	JR	Z,FLUSH_3
;
	PUSH	DE
	LD	A,(DE)
	LD	DE,FCB_D_TXT
	CALL	$PUT
	JP	NZ,ERROR
	POP	DE
	INC	DE
	JR	FLUSH_1
FLUSH_3
	LD	HL,STARTBUFFER
	LD	(OUTBUFFER),HL
	POP	HL
	POP	BC
	RET
;
PUT_TOP
	LD	DE,FCB_D_TOP
	CALL	$PUT
	RET	Z
	JP	ERROR
;
COUNT_COPY
;
	CALL	FLUSH
;
	LD	DE,FCB_D_TOP	;Rewind topic file
	CALL	DOS_REWIND
	JP	NZ,ERROR
;
	LD	A,(MSG_COUNT)	;Put count of messages
	CALL	PUT_TOP
	LD	A,(MSG_COUNT+1)
	CALL	PUT_TOP
	XOR	A
	CALL	PUT_TOP		;Zero killed messages.
	XOR	A
	CALL	PUT_TOP
;
	LD	A,(FCB_D_TXT+5)	;Write TXT eof.
	CALL	PUT_TOP
	LD	A,(FCB_D_TXT+10)
	CALL	PUT_TOP
	LD	A,(FCB_D_TXT+11)
	CALL	PUT_TOP
;
	CP	A		;Finished!
	RET
;
DONE
;
	CALL	FLUSH
;
	CALL	DO_CLOSE
	JP	NZ,ERROR
	RET
;
*GET	ROUTINES
;
M_OPENOK
	DEFM	'Files opened OK',CR,0
M_CNT_OPEN
	DEFM	'Can''t open files!',CR,0
M_CNT_CRT
	DEFM	'Can''t create destination files!',CR,0
M_ERROR
	DEFM	'BBSQUASH: Disk Error!',CR,0
M_CORRUPT
	DEFM	'BBSQUASH: Files corrupt. Reason follows:',CR,0
M_MESSAGE
	DEFM	'In Absolute message number: ',0
;
M_COR_TOP
	DEFM	CR,'Mismatch between topic numbers in HDR & TOP',CR,0
M_COR_TXT1
	DEFM	CR,'First TXT byte of message not FFh',CR,0
M_COR_TXT2
	DEFM	CR,'Header flag mismatch TXT to HDR',CR,0
M_COR_TXT3
	DEFM	CR,'No. lines mismatch TXT to HDR',CR,0
M_DOWHAT
	DEFM	'<A>bort, <F>ix? ',0
;
HDR_BUFF	;Buffer for message headers.
*GET	MSGHDR
;
THIS_MSG	DEFW	0
MSG_COUNT	DEFW	0
;
;Info about counts.
*GET	MSGTOP
;
;
M_FILDUP
	DEFM	'Creating new files',CR,0
M_TOPCOP
	DEFM	'Copying topics',CR,0
M_INFCOP
	DEFM	'Copying text',CR,0
M_COUCOP
	DEFM	'Writing message counts',CR,0
M_DONE
	DEFM	'Finished.',CR,0
;
BUF_S_TXT
	DEFS	256
BUF_D_TXT
	DEFS	256
BUF_S_HDR
	DEFS	256
BUF_D_HDR
	DEFS	256
BUF_S_TOP
	DEFS	256
BUF_D_TOP
	DEFS	256
;
FCB_S_TXT
	DEFM	'MSGTXT.ZMS:2',CR
	DC	32-13,0
FCB_D_TXT
	DEFM	'MSGTXT.ZSQ/rrr:1',CR
	DC	32-17,0
FCB_S_HDR
	DEFM	'MSGHDR.ZMS:2',CR
	DC	32-13,0
FCB_D_HDR
	DEFM	'MSGHDR.ZSQ/rrr:1',CR
	DC	32-17,0
FCB_S_TOP
	DEFM	'MSGTOP.ZMS:2',CR
	DC	32-13,0
FCB_D_TOP
	DEFM	'MSGTOP.ZSQ/rrr:1',CR
	DC	32-17,0
;
IN_BUFF	DEFS	32
;
STRING	DEFS	256
;
OUTBUFFER	DEFW	0
STARTBUFFER
	DEFS	10240
ENDBUFFER	EQU	$
;
THIS_PROG_END	EQU	$
;
	END	START
