;cpnews2/asm: Assembler routines for cpnews
;
	COM	'<cpnews2 21-Jul-87>'
;
_READFREE
	LD	HL,(_NEWSTXT0)
	LD	DE,FD_FCBPTR
	ADD	HL,DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	CALL	DOS_READ_SECT
	JP	NZ,ERROR
	LD	HL,3
	ADD	HL,DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	EX	DE,HL
	LD	HL,FREE_0
	LD	BC,256
	LDIR
;
	LD	HL,(_NEWSTXT1)
	LD	DE,FD_FCBPTR
	ADD	HL,DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	CALL	DOS_READ_SECT
	JP	NZ,ERROR
	LD	HL,3
	ADD	HL,DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	EX	DE,HL
	LD	HL,FREE_1
	LD	BC,256
	LDIR
;
	RET
;
_WRITFREE
	LD	HL,(_NEWSTXT0)
	LD	DE,FD_FCBPTR
	ADD	HL,DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	CALL	DOS_REWIND
	PUSH	DE
	LD	HL,3
	ADD	HL,DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	LD	HL,FREE_0
	LD	BC,256
	LDIR
	POP	DE
	CALL	DOS_WRIT_SECT
	JP	NZ,ERROR
;
	LD	HL,(_NEWSTXT1)
	LD	DE,FD_FCBPTR
	ADD	HL,DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	CALL	DOS_REWIND
	PUSH	DE
	LD	HL,3
	ADD	HL,DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	LD	HL,FREE_1
	LD	BC,256
	LDIR
	POP	DE
	CALL	DOS_WRIT_SECT
	JP	NZ,ERROR
;
FREE_0	DEFS	256
FREE_1	DEFS	256
;
_ALLOCS
	LD	HL,FREE_0
	LD	B,0
	LD	DE,8
	LD	IX,0
	LD	A,0FFH
AS_1	CP	(HL)
	JR	NZ,AS_3
	INC	HL
	ADD	IX,DE
	DJNZ	AS_1
	LD	HL,FREE_1
AS_2	CP	(HL)
	JR	NZ,AS_3
	INC	HL
	ADD	IX,DE
	DJNZ	AS_2
	LD	HL,0
	RET
;
AS_3	PUSH	IX
	LD	B,(HL)
	LD	DE,0
	LD	A,1
	LD	C,A
AS_4	OR	B
	CP	B
	JR	NZ,AS_5
	SLA	C
	INC	E
	LD	A,C
	JR	AS_4
AS_5	LD	(HL),A
	POP	HL
	ADD	HL,DE
	RET
;
_PUTHEAD
	CALL	_ALLOCS
	LD	A,H
	OR	L
	JP	Z,ERROR
	LD	(NEXTSECT),HL
	LD	(FIRSTSECT),HL
	CALL	POS_TXT
;
	LD	HL,_H_FROM
	CALL	PH
	LD	HL,_H_TO
	CALL	PH
	LD	HL,_H_DATE
	CALL	PH
	LD	HL,_H_SUBJ
	CALL	PH
	RET
;
POS_TXT
	;Decide which file we want
	LD	DE,(NEXTSECT)
	LD	HL,2047
	OR	A
	SBC	HL,DE
	LD	HL,(_NEWSTXT0)	;0-2047
	JR	NC,PT_1
	LD	HL,-2048
	ADD	HL,DE
	EX	DE,HL
	LD	HL,(_NEWSTXT1)
PT_1
	PUSH	DE
	LD	DE,FD_FCBPTR
	ADD	HL,DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	LD	(FCB),DE
;
	;Position the file.
	POP	BC
	CALL	DOS_POS_RBA
	RET	NZ
;;	CALL	DOS_READ_SECT
;;	RET	Z
;
	LD	HL,3
	ADD	HL,DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	EX	DE,HL
	LD	(BUF),HL
;
	LD	(HL),0		;Zero "next sector"
	INC	HL
	LD	(HL),0
	INC	HL
	LD	(BYTEPOS),HL
	RET
;
FCB	DEFW	0
NEXTSECT	DEFW	0
;
PUT_TXT
	LD	HL,(BYTEPOS)
	LD	C,A
	PUSH	HL
	LD	DE,(BUF)
	XOR	A
	SBC	HL,DE
	OR	H
	POP	HL
	JR	Z,PUT_1
	LD	(HL),C
	INC	HL
	LD	(BYTEPOS),HL
	RET
PUT_1
	PUSH	BC
	CALL	_ALLOCS
	LD	A,H
	OR	L
	JP	Z,ERROR
	LD	(NEXTSECT),HL
	EX	DE,HL
	LD	HL,(BUF)
	LD	(HL),E
	INC	HL
	LD	(HL),D
	LD	DE,(FCB)
	CALL	DOS_WRIT_SECT
	JP	NZ,ERROR
;
	CALL	POS_TXT
;
	POP	BC
	LD	HL,(BYTEPOS)
	LD	(HL),C
	INC	HL
	LD	(BYTEPOS),HL
	RET
;
BUF	DEFW	0
BYTEPOS	DEFW	0
;
PH	LD	A,(HL)
	PUSH	HL
	CALL	PUT_TXT
	POP	HL
	LD	A,(HL)
	INC	HL
	OR	A
	JR	NZ,PH
	RET
;
ERROR
	LD	HL,M_ERROR
	PUSH	HL
	LD	HL,STDERR
	PUSH	HL
	CALL	_FPUTS
	POP	BC
	POP	BC
	CALL	_EXIT
	RET
;
M_ERROR	DEFM	'Unidentified error.',0DH,0
;
FCB_IN	DEFW	0
;
_PUTMSG
	LD	HL,(_FP)
	LD	DE,FD_FCBPTR
	ADD	HL,DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	LD	(FCB_IN),DE
PM_1	CALL	$GET
	JR	Z,PM_2
	CP	1AH
	JR	Z,PM_2
	OR	A
	JR	Z,PM_2
	PUSH	DE
	CALL	PUT_TXT
	POP	DE
	JR	PM_1
PM_2	XOR	A
	CALL	PUT_TXT
	LD	DE,(FCB)
	CALL	DOS_WRIT_SECT
	JP	NZ,ERROR
	RET
;
FIRSTSECT	DEFW	0
