;getpkt: Do all functions required to get a Fidonet
;	 packet
;
*GET	DOSCALLS
*GET	EXTERNAL
*GET	ASCII
*GET	RS232
;
	ORG	PROG_START
	DEFW	BASE
	DEFW	THIS_PROG_END
	DEFW	0
	DEFW	0
;End of program load info.
;
	COM	'<Getpkt 1.3c 14-Jan-88>'
	ORG	BASE+100H
;
START	LD	SP,START
;
	LD	A,(PRIV_1)
	BIT	IS_SYSOP,A
	JR	NZ,ST_1
	XOR	A
	JP	TERMINATE
ST_1
	LD	A,(HL)
	CP	'-'
	JR	NZ,ST_1A
	INC	HL
	LD	A,(HL)
	INC	HL
	INC	HL
	AND	5FH
	CP	'D'
	JR	NZ,ST_1A
	LD	A,1
	LD	(D_FLAG),A
ST_1A
;First .. figure out what file to put the packet in.
	CALL	MAKE_NAME	;make filename
;
GP_02
	CALL	MAIL_RECV
GP_03
	LD	HL,M_XMFOK
	CALL	LOG_MSG_2
;
;Now receive any attached files ...
	CALL	FILE_RECV
;
	LD	A,(FATAL)
	OR	A
	JR	NZ,GP_03B	;If fatal error
;
	LD	A,(D_FLAG)
	OR	A
	JP	NZ,GP_03B	;If we called out
;
;Now figure out who is calling, and run "ftalk" with
;the appropriate outgoing packet filename
	CALL	WHICH_LINK
	JR	Z,GP_03A	;there may be return mail
;
;We do not have a link to the machine which is calling.
;So just do this....
	LD	HL,M_NOLINKS
	CALL	LOG_MSG_2
	JR	GP_03B
;
GP_03A				;send return packet/files
;
	LD	HL,CMD_FTALK
	LD	DE,STRING
	CALL	STRCPY
	LD	HL,(HEAD_ORIG_NET)
	CALL	SPUTNUM
	LD	A,'/'
	LD	(DE),A
	INC	DE
	LD	HL,(HEAD_ORIG_NODE)
	CALL	SPUTNUM
;;	LD	HL,LINK_NAME
;;	CALL	STRCAT
;;	LD	HL,FILE_TRAIL2
;;	CALL	STRCAT
;
	LD	HL,STRING	;log the command
	CALL	LOG_MSG_2
;
	LD	HL,STRING
	CALL	CALL_PROG	;Send out packet/file
	OR	A
	JR	Z,GP_03B
	LD	HL,M_TALKBAD
	CALL	LOG_MSG_2
;
GP_03B
	CALL	FIX_STATS	;Alter & close stats.
	CALL	CLOSE_INF
;
	LD	HL,CMD_PKTDIS	;disassemble the packet.
	LD	DE,STRING
	CALL	STRCPY
	LD	HL,FILENAME
	CALL	STRCAT
	LD	HL,STRING
	CALL	CALL_PROG
	JR	Z,GP_04
;
	LD	HL,M_NODIS
	CALL	LOG_MSG_2
	LD	A,2
	JP	TERMINATE
;
GP_04
	LD	HL,M_DISOK
	CALL	LOG_MSG_2
	LD	HL,M_OK
	CALL	LOG_MSG_2
	XOR	A
	JP	TERMINATE
;
MAIL_RECV
	LD	HL,CMD_XMF
	LD	DE,STRING
	CALL	STRCPY
	LD	HL,FILENAME
	CALL	STRCAT
;
	LD	HL,STRING
	CALL	LOG_MSG_2
	LD	HL,M_CR
	CALL	LOG_MSG_2
;
	LD	HL,STRING
	CALL	CALL_PROG	;Receive the file.
	OR	A
	JR	NZ,MR_01
;
;Bump packet received count.
	LD	HL,(PKTS_RCVD)
	INC	HL
	LD	(PKTS_RCVD),HL
	CP	A
	RET
;
MR_01
	LD	HL,M_NOXMF	;Couldn't transfer
	CALL	LOG_MSG_2
	LD	A,1
	JP	TERMINATE
;
ERROR	PUSH	AF
	OR	80H
	CALL	DOS_ERROR
	LD	HL,M_BAD
	CALL	LOG_MSG_2
	POP	AF
	JP	TERMINATE
;
OPEN_STATS
	LD	HL,STATS_BUF
	LD	DE,STATS_FCB
	LD	B,16
	CALL	DOS_OPEN_EX
	JP	NZ,ERROR
	LD	A,(STATS_FCB+1)
	AND	0F8H
	LD	(STATS_FCB+1),A
	LD	HL,STATS_REC
	CALL	DOS_READ_SECT
	JP	NZ,ERROR
	CALL	DOS_REWIND
	RET
;
FIX_STATS
;
	CALL	OPEN_STATS
;Set stats file for # of packets received.
	LD	HL,(PKTS_RCVD)
	LD	(ST_PKTS_RCVD),HL
;
	LD	DE,STATS_FCB	;Rewrite record
	LD	HL,STATS_REC
	CALL	DOS_WRIT_SECT
	JP	NZ,ERROR
	CALL	DOS_CLOSE
	JP	NZ,ERROR
	RET
;
MAKE_NAME
	LD	DE,FILENAME+3	;Bypass "pkt"
	LD	HL,(PKTS_RCVD)	;from memory
	INC	HL
	CALL	SPUTNUM
	LD	HL,FILE_TRAIL
	CALL	STRCAT
	RET
;
;Receive any attached files.
FILE_RECV
	CALL	OPEN_INF
	LD	B,1
	CALL	GET_BYTE	;Flush
	LD	B,1
	CALL	GET_BYTE	;Flush
FR_01	CALL	MODEM7_FNAME
	JR	NC,FR_FAILED
	CP	EOT
	RET	Z
;
	LD	HL,M7_FILE
	CALL	LOG_MSG_2
;
	LD	HL,CMD_TELINK
	LD	DE,STRING
	CALL	STRCPY
	LD	HL,M7_FILE
	CALL	STRCAT
;
	LD	HL,STRING
	CALL	CALL_PROG
	OR	A
	JR	Z,FR_02
;
	LD	HL,M_RCVBAD
	CALL	LOG_MSG_2
	LD	A,1
	LD	(FATAL),A
	RET
;
FR_02
	LD	HL,M_RCVOK
	CALL	LOG_MSG_2
	CALL	WRITE_INF
	JR	FR_01
;
FR_FAILED
	LD	HL,M_FRFAIL
	CALL	LOG_MSG_2
	LD	A,1
	LD	(FATAL),A
	RET
;
OPEN_INF
	LD	HL,BUF_INF
	LD	DE,FCB_INF
	CALL	DOS_OPEN_EX
	RET	NZ
	CALL	DOS_POS_EOF
	RET	NZ
	LD	A,1
	LD	(CANLOG),A
	RET
;
WRITE_INF
	LD	A,(CANLOG)
	OR	A
	RET	Z
	LD	DE,FCB_INF
	LD	A,' '
	CALL	$PUT
	LD	A,' '
	CALL	$PUT
	LD	HL,M7_FILE
	CALL	FPUTS
	LD	A,CR
	CALL	$PUT
	RET
;
CLOSE_INF
	LD	A,(CANLOG)
	OR	A
	RET	Z
	LD	DE,FCB_INF
	CALL	DOS_CLOSE
	RET
;
MODEM7_FNAME
	LD	HL,MT_1
	CALL	LOG_MSG_1
	LD	A,(M7_TRY)
	INC	A
	LD	(M7_TRY),A
	CP	20
	JP	Z,M7_FAILED
;;;	IN	A,(0F8H)
;;;	IN	A,(0F8H)	;Flush.
	LD	A,NAK
	CALL	PUT_BYTE
MF_01
	LD	B,5
	CALL	GET_BYTE
	JR	C,MODEM7_FNAME	;If timeout.
	CP	ACK
	JR	Z,MF_03
	CP	SUB
	JR	Z,MF_SUB
	CP	EOT
	JR	Z,MF_02
;Unknown character.
	PUSH	AF
	LD	A,'"'
	LD	DE,$DO
	CALL	$PUT
	POP	AF
	CALL	$PUT
	LD	A,'"'
	CALL	$PUT
	LD	A,' '
	CALL	$PUT
	JR	MODEM7_FNAME
;
;No files attached.
MF_02
	LD	HL,MT_2
	CALL	LOG_MSG_1
;
	LD	HL,M_NMFILES
	CALL	LOG_MSG_2
	LD	A,EOT
	SCF
	RET
;
MF_SUB
	LD	HL,MT_5
	CALL	LOG_MSG_1
	LD	A,ACK
	CALL	PUT_BYTE
	LD	A,EOT
	SCF
	RET
;
MF_03
	LD	HL,MT_3
	CALL	LOG_MSG_1
	LD	HL,M7_FIELD
	LD	C,0
	LD	(HL),C
MF_04
	LD	B,1
	CALL	GET_BYTE
	JP	C,MODEM7_FNAME	;If timeout
	CP	EOT
	JR	Z,MF_02		;If ACK then EOT .!?
	CP	SUB
	JR	Z,MF_05
	CP	'u'
	JP	Z,MODEM7_FNAME
	LD	(HL),A
	INC	HL
	ADD	A,C
	LD	C,A
;
	LD	A,ACK
	CALL	PUT_BYTE
;
	JR	MF_04
;
MF_05	ADD	A,C		;add ^Z.
	CALL	PUT_BYTE
;;	LD	HL,MT_4
;;	CALL	LOG_MSG_1
MF_06
	LD	B,1
	CALL	GET_BYTE
	JP	C,MODEM7_FNAME
	CP	ACK
	JR	Z,MF_07		;convert filename.
	JP	MODEM7_FNAME
;
;Create a filename.
MF_07	LD	HL,M7_FIELD
	CALL	FIX_ALPHA
	LD	DE,M7_FILE
	LD	B,8
MF_07A	LD	A,(HL)
	CP	' '
	JR	Z,MF_07B
	CALL	FIX_ALPHANUM
	LD	(DE),A
	INC	HL
	INC	DE
	DJNZ	MF_07A
MF_07B
	LD	HL,M7_FIELD+8
;;	CALL	FIX_ALPHA
	LD	A,(HL)
	CP	' '
	JR	Z,MF_07D
	CALL	FIX_ALPHA
	LD	A,'.'
	LD	(DE),A
	INC	DE
	LD	B,3
MF_07C	LD	A,(HL)
	CP	' '
	JR	Z,MF_07D
	CALL	FIX_ALPHANUM
	LD	(DE),A
	INC	HL
	INC	DE
	DJNZ	MF_07C
MF_07D
	XOR	A
	LD	(DE),A
	SCF
	RET
;
FIX_ALPHA
	LD	A,(HL)
	LD	C,A
	AND	5FH	;to 40h-5fh
	CP	'A'
	JR	C,FA_01
	CP	'Z'+1
	RET	C
FA_01	AND	0FH	;0000xxxx
	ADD	A,61H
	LD	(HL),A
	RET
FIX_ALPHANUM
	CP	'0'
	JR	C,FA_02
	CP	'9'+1
	RET	C
	AND	5FH
	CP	'A'
	JR	C,FA_02
	CP	'Z'+1
	RET	C
FA_02	AND	0FH
	ADD	A,61H
	RET
;
M7_FAILED
	XOR	A
	LD	(M7_TRY),A
	SCF
	CCF
	RET
;
WHICH_LINK
	LD	HL,FILENAME	;Open packet just got
	LD	DE,PKT_FCB
	CALL	EXTRACT
	JP	NZ,ERROR
;
	LD	DE,PKT_FCB
	LD	HL,PKT_BUF
	LD	B,0
	CALL	DOS_OPEN_EX
	JP	NZ,ERROR
;
	LD	A,(PKT_FCB+1)
	AND	0F8H
	OR	5
	LD	(PKT_FCB+1),A
;
	LD	DE,PKT_FCB
	LD	HL,HEAD
	LD	B,58
WL_01	CALL	$GET		;read header
	JP	NZ,ERROR
	LD	(HL),A
	INC	HL
	DJNZ	WL_01
;
	RET			;All done!!
;Don't bother reading net links file ...
	LD	DE,NETL_FCB	;Open net links
	LD	HL,NETL_BUF
	LD	B,0
	CALL	DOS_OPEN_EX
	JP	NZ,ERROR
	LD	A,(NETL_FCB+1)
	AND	0F8H
	OR	5
	LD	(NETL_FCB+1),A
;
	LD	DE,NETL_FCB
	LD	HL,STRING
	CALL	GET_WORD
	JP	NZ,MAYBE_ERROR
;Read NETL file for machine numbers serving links
;and associated filenames.
WL_02	LD	DE,NETL_FCB
	LD	HL,STRING	;Bypass linkname
	CALL	GET_WORD
	JP	NZ,WL_EOF
	LD	HL,STRING
	CALL	GET_WORD	;Get machine number
	JP	NZ,MAYBE_ERROR
;
	LD	HL,STRING	;decode machine number
	LD	DE,0
	LD	A,(HL)
	INC	HL
	CP	'['
	JP	NZ,WL_NOTEQ
	LD	A,(HL)
	CALL	IF_NUM
	JP	NZ,WL_NOTEQ
	INC	HL
WL_03	CALL	ADD_SUM
	LD	A,(HL)
	INC	HL
	CALL	IF_NUM
	JR	Z,WL_03
	CP	'/'
	JP	NZ,WL_NOTEQ
	LD	(CURRENT_NET),DE
	LD	A,(HL)
	INC	HL
	CALL	IF_NUM
	JP	NZ,WL_NOTEQ
	LD	DE,0
WL_04	CALL	ADD_SUM
	LD	A,(HL)
	INC	HL
	CALL	IF_NUM
	JR	Z,WL_04
	CP	']'
	JP	NZ,WL_NOTEQ
	LD	(CURRENT_NODE),DE
;
;Now check the two numbers.
	LD	HL,(CURRENT_NET)
	LD	DE,(HEAD_ORIG_NET)
	OR	A
	SBC	HL,DE
	JP	NZ,WL_NOTEQ
;
	LD	HL,(CURRENT_NODE)
	LD	DE,(HEAD_ORIG_NODE)
	OR	A
	SBC	HL,DE
	JP	NZ,WL_NOTEQ
;
;Are equal! read in the filename & return with Z status.
	LD	DE,NETL_FCB
	LD	HL,LINK_NAME
	CALL	GET_WORD
	JP	NZ,MAYBE_ERROR
	RET
;
WL_NOTEQ
	LD	DE,NETL_FCB
	LD	HL,STRING
	CALL	GET_WORD
	JP	NZ,MAYBE_ERROR
	JP	WL_02		;reloop.
;
MAYBE_ERROR
	PUSH	AF
	LD	HL,M_MAYBE
	LD	DE,$DO
	CALL	MESS_0
	POP	AF
	JR	WL_EOF
;
WL_EOF	CP	1CH
	JR	Z,WL_EOF1
	CP	1DH
	JP	NZ,ERROR
WL_EOF1	XOR	A
	CP	1
	RET			;NZ = no links to him.
;
GET_WORD
	CALL	$GET
	RET	NZ
	CP	' '
	JR	Z,GW_01
	OR	A
	JR	Z,GW_01
	CP	CR
	JR	Z,GW_01
	LD	(HL),A
	INC	HL
	JR	GET_WORD
GW_01	LD	(HL),0
	CP	A
	RET
;
ADD_SUM	PUSH	HL
	PUSH	DE
	POP	HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,DE
	ADD	HL,HL
	SUB	'0'
	LD	E,A
	LD	D,0
	ADD	HL,DE
	PUSH	HL
	POP	DE
	POP	HL
	RET
;
LOG_MSG_2
	PUSH	HL
	LD	DE,$DO
	CALL	MESS_0
	POP	HL
	CALL	LOG_MSG
	RET
;
LOG_MSG_1
	PUSH	DE
	LD	DE,$DO
	CALL	MESS_0
	POP	DE
	RET
;
GET_BYTE
	PUSH	DE
GB_1	LD	D,40		;=1 sec
	LD	A,(TICKER)
	LD	E,A
GB_2	LD	A,(CD_STAT)
	BIT	1,A
	JR	NZ,GB_3
	IN	A,(RDSTAT)
	BIT	DAV,A
	JR	NZ,GB_4
	LD	A,(TICKER)
	CP	E
	LD	E,A
	JR	Z,GB_2
	DEC	D
	JR	NZ,GB_2
	DJNZ	GB_1
GB_3	POP	DE
	SCF		;If timeout or carrier loss
	RET	
;
GB_4	IN	A,(RDDATA)
	POP	DE
	OR	A
	RET
;
;
PUT_BYTE
	PUSH	AF
BS_1	LD	A,(CD_STAT)
	BIT	1,A
	JR	NZ,BS_2		;Carrier check.
	IN	A,(RDSTAT)
	BIT	CTS,A
	JR	Z,BS_1
BS_2
	POP	AF
	OUT	(WRDATA),A
	RET
;
*GET	ROUTINES
*GET	STATS
;
MT_1	DEFM	'--> trying to get filename',CR,0
MT_2	DEFM	'--> eot seen',CR,0
MT_3	DEFM	' ack ',0
MT_4	DEFM	' crc-sent ',0
MT_5	DEFM	' sub ',0
M_CR		DEFM	CR,0
M_OK		DEFM	'getpkt OK',CR,0
M_BAD		DEFM	'** getpkt bad',CR,0
M_NOXMF		DEFM	'** xmf pkt rcv failed',CR,0
M_XMFOK		DEFM	'xmf rcvd pkt ok',CR,0
M_DISOK		DEFM	'disassembled OK',CR,0
M_NODIS		DEFM	'** could not disassemble packet',CR,0
M_RCVOK		DEFM	'file receive worked',CR,0
M_FRFAIL	DEFM	'** modem7 filename failed',CR,0
M_RCVBAD	DEFM	'** file receive failed',CR,0
M_NMFILES	DEFM	'** no more files to receive',CR,0
M_NOLINKS	DEFM	'** no links to caller',CR,0
M_TALKBAD	DEFM	'** ftalk didn''t work',CR,0
M_MAYBE		DEFM	'** May be an error!',CR,0
;
M7_TRY	DEFB	0	;Tries for modem7 filename.
D_FLAG	DEFB	0	;=1 if we are calling out.
FATAL	DEFB	0	;=1 if file receive error
CANLOG	DEFB	0	;=1 If we can't open infiles log.
;
FILE_TRAIL	DEFM	'.net/xxxx',0
FILE_TRAIL2	DEFM	'/xxxx:2',0	;outgoing packets
;
FILENAME	DEFM	'PKT00000.xxx/pppppppp',0
;
STATS_FCB	DEFM	'stats.zms',ETX
		DC	32-10,0
PKT_FCB		DEFS	32
NETL_FCB	DEFM	'netl.zms',ETX
		DC	32-9,0
;
STATS_BUF	DEFS	256
PKT_BUF		DEFS	256
NETL_BUF	DEFS	256
;
CMD_XMF		DEFM	'xmf -qocr ',0
CMD_TELINK	DEFM	'xmf -qcr ',0
CMD_PKTDIS	DEFM	'pktdis -r ',0
CMD_FTALK	DEFM	'ftalk ',0
;
;Format of the packet header.....
HEAD
HEAD_ORIG_NODE	DEFS	2
HEAD_DEST_NODE	DEFS	2
HEAD_YMDHMS	DEFS	12
HEAD_RATE	DEFS	2
HEAD_VER	DEFS	2
HEAD_ORIG_NET	DEFS	2
HEAD_DEST_NET	DEFS	2
		DEFS	34
;
CURRENT_NET	DEFW	0
CURRENT_NODE	DEFW	0
;
M7_FILE		DEFS	64
M7_FIELD	DEFS	11	;abcdefghXYZ
STRING		DEFS	64
LINK_NAME	DEFS	64
;
FCB_INF		DEFM	'infiles:2',CR
		DC	32-10,0
BUF_INF		DEFS	256
;
THIS_PROG_END	EQU	$
;
	END	START
