;Acsnet1: low level routines for acsnet
;Last modified: 07-Aug-87
;
;
*GET	RS232
;
OK	EQU	0
TIMEOUT	EQU	1
BADNAK	EQU	2
GOODNAK	EQU	3
GOODACK	EQU	4
;
PACKETHDR	EQU	0FBH
PACKETTLR	EQU	004H
ACKHDR	EQU	0F4H
ACKTLR	EQU	00BH
ACK	EQU	06H
NAK	EQU	15H
;
;GET_BYTE:   Get a character from the modem
;Carry flag is set if there is a timeout.
;Load B with timeout length
GET_BYTE1
	LD	B,1
GET_BYTE
	PUSH	DE
GB_1	LD	D,40		;=1 sec
	LD	A,(TICKER)
	LD	E,A
GB_2
	CALL	CARR_DETECT
	JR	NZ,GB_3		;No carrier detect
	IN	A,(RDSTAT)
	BIT	DAV,A
	JR	NZ,GB_4
	LD	A,(TICKER)
	CP	E
	LD	E,A
	JR	Z,GB_2
	DEC	D
	JR	NZ,GB_2
	DJNZ	GB_1
GB_3	POP	DE
	SCF	
	RET	
;
GB_4	IN	A,(RDDATA)
	POP	DE
	OR	A
	RET
;
;PUT_BYTE: Send character to serial port
PUT_BYTE
	PUSH	AF
BS_1
	CALL	CARR_DETECT
	JR	NZ,BS_2		;Carrier check.
	IN	A,(RDSTAT)
	BIT	CTS,A
	JR	Z,BS_1
BS_2
	POP	AF
	OUT	(WRDATA),A
	RET
;
;CALC_CRC: Calculate CRC-CCITT on a block of data
CALC_CRC
	PUSH	HL
	LD	HL,0
	LD	(OLD_CRC),HL
	LD	(ZEROCRC),HL
	POP	HL
	LD	B,130
FC_01	LD	A,(HL)
	INC	HL
	PUSH	HL
	PUSH	BC
	LD	HL,(OLD_CRC)
	LD	C,A
	LD	B,8
FC_02
	RLC	C
	RL	L
	RL	H
	JR	NC,FC_03
	LD	A,H
	XOR	10H
	LD	H,A
	LD	A,L
	XOR	21H
	LD	L,A
FC_03
	LD	(OLD_CRC),HL
	DJNZ	FC_02
	POP	BC
	POP	HL
	DJNZ	FC_01
	LD	HL,(OLD_CRC)
	RET
;
CALC_CSM
	LD	C,0
FC_04	LD	A,(HL)
	ADD	A,C
	LD	C,A
	INC	HL
	DJNZ	FC_04
	LD	A,C
	RET
;
;FILESEND: Send a file to the other system.
;input, HL = filename.
FILESEND
	PUSH	HL
	LD	HL,M_FILESEND
	LD	DE,$DO
	CALL	MESS_0
	LD	HL,XMF_S
	LD	DE,STRING
	CALL	STRCPY
	POP	HL
	CALL	STRCAT
	LD	HL,STRING
	CALL	CALL_PROG
	RET
;
;FILERECV: Receive a file, hl = filename.
FILERECV
	PUSH	HL
	LD	HL,M_FILERECV
	LD	DE,$DO
	CALL	MESS_0
;
	LD	HL,XMF_R
	LD	DE,STRING
	CALL	STRCPY
	POP	HL
	CALL	STRCAT
	LD	HL,STRING
	CALL	CALL_PROG
	RET
;
;
;SENDHS: Send a handshake, HL= message buffer, A = length
SENDHS
	LD	(HS_MSG),HL
	LD	A,B
	LD	(HS_LEN),A
	OR	A
	RET	Z
	LD	HL,M_SENDHS
	LD	DE,$DO
	CALL	MESS_0
;
	CALL	PREPARE_S
;
	XOR	A
	LD	(COUNT),A
;
HS_1	LD	A,(COUNT)
	INC	A
	LD	(COUNT),A
	CP	11
	JP	NC,RET_NZ	;Too many errors
	CALL	SENDPACKET
HS_2	CALL	RECVACK
	CP	GOODACK
	JR	Z,HS_3
	LD	HL,M_BADACK
	CALL	LOG_MSG_2
	JR	HS_1
HS_3	LD	HL,M_ACKV
	CALL	LOG_MSG_2
;
	LD	A,(SENDSEQ)
	INC	A
	LD	(SENDSEQ),A
;
	CP	A
	RET
;
SENDPACKET
	LD	A,PACKETHDR
	CALL	PUT_BYTE
	LD	A,(HS_SEQ)
	CALL	PUT_BYTE
	LD	A,(HS_LEN)
	CALL	PUT_BYTE
	LD	HL,(HS_MSG)
	LD	A,(HS_LEN)
	LD	B,A
SP_1	LD	A,(HL)
	CALL	PUT_BYTE
	INC	HL
	DJNZ	SP_1
	LD	A,(HS_CSM)
	CALL	PUT_BYTE
	LD	A,PACKETTLR
	CALL	PUT_BYTE
	RET
;
RECVHS
;
	LD	HL,M_RECVHS
	LD	DE,$DO
	CALL	MESS_0
;
	XOR	A
	LD	(COUNT),A
HS_10
	LD	A,(COUNT)
	INC	A
	LD	(COUNT),A
	CP	11
	JP	NC,RET_NZ
;
	CALL	RECVPACKET
	JR	NZ,HS_10
	CALL	CHECKPACKET
	OR	A
	JR	NZ,HS_10
	CALL	SENDACK
;
	LD	A,(RECVSEQ)
	INC	A
	LD	(RECVSEQ),A
;
	LD	HL,M_VALID
	CALL	LOG_MSG_2
	CP	A
	RET
;
RECVPACKET
;
RP_1
	LD	B,10
	CALL	GET_BYTE
	JP	C,RP_TO
	CP	PACKETHDR
	JR	NZ,RP_1
;
	CALL	GET_BYTE1
	JP	C,RP_TO
	LD	(HS_SEQ),A
	LD	B,A
	LD	A,(RECVSEQ)
	CP	B
	JP	NZ,RP_ERR
;
	CALL	GET_BYTE1
	JP	C,RP_TO
	LD	(HS_LEN),A
;
	LD	B,A
	LD	HL,HS_BUF
RP_2	PUSH	BC
	CALL	GET_BYTE1
	POP	BC
	JP	C,RP_TO
	LD	(HL),A
	INC	HL
	DJNZ	RP_2
;
	CALL	GET_BYTE1
	JP	C,RP_TO
	LD	(HS_CSM),A
;
	CALL	GET_BYTE1
	JP	C,RP_TO
	CP	PACKETTLR
	JP	NZ,RP_ERR
	LD	HL,M_RP_OK
	CALL	LOG_MSG_2
	CP	A
	RET
;
RP_TO	CALL	SENDNAK
	LD	HL,M_RPTO
	CALL	LOG_MSG_2
	JP	RET_NZ
;
RP_ERR	CALL	SENDNAK
	LD	HL,M_RPERR
	CALL	LOG_MSG_2
	JP	RET_NZ
;
SENDACK
	LD	A,ACKHDR
	CALL	PUT_BYTE
	LD	A,ACK
	CALL	PUT_BYTE
	LD	A,ACK.XOR.0FFH
	CALL	PUT_BYTE
	LD	A,(RECVSEQ)
	CALL	PUT_BYTE
	LD	A,(RECVSEQ)
	XOR	0FFH
	CALL	PUT_BYTE
	LD	A,ACKTLR
	CALL	PUT_BYTE
	RET
;
SENDNAK
	CALL	GET_BYTE1	;Wait until silence
	JR	NC,SENDNAK
	LD	A,ACKHDR
	CALL	PUT_BYTE
	LD	A,NAK
	CALL	PUT_BYTE
	LD	A,NAK.XOR.0FFH
	CALL	PUT_BYTE
	LD	A,(RECVSEQ)
	CALL	PUT_BYTE
	LD	A,(RECVSEQ)
	XOR	0FFH
	CALL	PUT_BYTE
	LD	A,ACKTLR
	CALL	PUT_BYTE
	RET
;
PREPARE_S
	LD	A,(SENDSEQ)
	LD	(HS_SEQ),A
	LD	C,A
;
	LD	A,(HS_LEN)
	ADD	A,C
	LD	(HS_CSM),A
;
	LD	HL,(HS_MSG)
	LD	A,(HS_LEN)
	LD	B,A
	CALL	CALC_CSM
;
	LD	A,(HS_CSM)
	ADD	A,C
	LD	(HS_CSM),A
	RET
;
RECVACK
RA_1	LD	B,10
	CALL	GET_BYTE
	JR	C,RA_TIME
	CP	ACKHDR
	JR	NZ,RA_1		;Sync them
;
	LD	HL,ACKBUF
	LD	(HL),A
	INC	HL
;
	LD	B,5
RA_2	PUSH	BC
	PUSH	HL
	CALL	GET_BYTE1
	POP	HL
	POP	BC
	JR	C,RA_TIME
	LD	(HL),A
	INC	HL
	DJNZ	RA_2
;
	LD	HL,ACKBUF
	LD	A,(HL)
	INC	HL
	CP	ACKHDR
	JR	NZ,RA_BAD
	LD	A,(HL)
	INC	HL
	LD	B,A
	XOR	(HL)
	INC	HL
	CP	0FFH
	JR	NZ,RA_BAD
;
	LD	A,(HL)
	INC	HL
	LD	C,A
	XOR	(HL)
	INC	HL
	CP	0FFH
	JR	NZ,RA_BAD
	LD	A,(SENDSEQ)
	CP	C
	JR	NZ,RA_BAD
;
	LD	A,(HL)
	CP	ACKTLR
	JR	NZ,RA_BAD
;
	LD	A,B
	CP	ACK
	LD	A,GOODACK
	RET	Z
	LD	A,GOODNAK
	RET
;
RA_TIME	LD	A,TIMEOUT
	OR	A
	RET
RA_BAD	LD	A,BADNAK
	OR	A
	RET
;
CHECKPACKET
	LD	HL,M_CHKOK
	LD	DE,$DO
	CALL	MESS_0
	CP	A
	RET
;
COUNT	DEFB	0
ACKBUF	DEFS	6
;
XMF_S	DEFM	'xmf -qs ',0
XMF_R	DEFM	'xmf -coqr ',0
M_SENDHS
	DEFM	'Sending a packet',CR,0
M_RECVHS
	DEFM	'Receiving a packet',CR,0
M_RP_OK
	DEFM	'Got to end of recvpacket',CR,0
M_RPTO
	DEFM	'rp timed out',CR,0
M_RPERR
	DEFM	'rp errored out',CR,0
M_CHKOK
	DEFM	'Chkpacket returning ok',CR,0
M_FILESEND
	DEFM	'About to send a file',CR,0
M_FILERECV
	DEFM	'About to receive a file',CR,0
M_VALID
	DEFM	'packet was valid',CR,0
M_ACKV
	DEFM	'ack was valid',CR,0
M_BADACK
	DEFM	'Bad or no ack received',CR,0
;
HS_MSG	DEFW	0
HS_LEN	DEFB	0
HS_CSM	DEFB	0
HS_SEQ	DEFB	0
HS_BUF	DEFS	256
;
OLD_CRC	DEFW	0
ZEROCRC	DEFW	0	;Supposed to be after data buf
SENDSEQ	DEFB	0	;Sender requence number
RECVSEQ	DEFB	0	;Receiver sequence number
;
