;Acsnet: The protocol handler for ACSnet news/mail.
;
*GET	DOSCALLS
*GET	EXTERNAL
*GET	ASCII
*GET	RS232
;
ACSNET_ID	EQU	6
;
	ORG	PROG_START
	DEFW	BASE
	DEFW	THIS_PROG_END
	DEFW	0
	DEFW	0
;End of program load info.
;
	COM	'<Acsnet 1.1d 14-Aug-87>'
;
	ORG	BASE+100H
START
	LD	SP,START
;
	LD	DE,(USR_NUMBER)
	LD	HL,ACSNET_ID
	OR	A
	SBC	HL,DE
	JR	Z,ACS_OK
	LD	HL,2
	OR	A
	SBC	HL,DE
	JR	Z,ACS_OK
	LD	HL,1
	OR	A
	SBC	HL,DE
	JR	Z,ACS_OK
	JP	NZ,EXIT
;
ACS_OK
	LD	HL,M_CONNECT
	CALL	LOG_MSG_2
;
	CALL	SET_1200
	CALL	READY
	CALL	RECVNEWS
	CALL	RECVECHO	;In fidonet format
	CALL	SENDNEWS
	CALL	RECVMAIL
	CALL	SENDMAIL
	CALL	RECVFILES
	CALL	SENDFILES
;
;Process received news cum echomail
	CALL	PROCECHO
	LD	HL,M_DONE
	CALL	LOG_MSG_2
	XOR	A
	JP	EXIT
;
EXIT
	LD	HL,M_END
	CALL	LOG_MSG_2
	XOR	A
	JP	TERMINATE
;
READY	LD	HL,P_READY
	LD	B,1
	CALL	SENDHS
	JP	NZ,FAILED
	RET
;
RECVNEWS
	LD	HL,M_RN
	CALL	LOG_MSG_2
;
	LD	DE,FCB_NNEWS
	CALL	OPENF
RN_0	CALL	RECVHS
	JP	NZ,FAILED
	LD	A,(HS_BUF+0)
	CP	6
	JP	NZ,OOSYNC
;
	LD	A,(HS_BUF+1)
	OR	A
	JR	Z,RN_2		;No news to receive
	CALL	GETNEWS
	JR	RN_0
RN_2	LD	DE,FCB_NNEWS
	CALL	CLOSEF
	RET
;
RECVECHO
	LD	HL,M_RE
	CALL	LOG_MSG_2
;
	CALL	RECVHS
	LD	HL,M_FAIL2
	JP	NZ,FAILED
	LD	A,(HS_BUF+0)
	CP	5		;Means "echo packet"
	JP	NZ,OOSYNC
;
	LD	A,(HS_BUF+1)
	OR	A
	JR	NZ,RE_1		;Recv echo packet
	XOR	A
	LD	(ECHONAME),A
RE_1
	LD	HL,ECHONAME
	CALL	FILERECV
	LD	HL,M_FAIL1
	JP	NZ,FAILED
	RET
;
SENDNEWS
	LD	HL,M_SN
	CALL	LOG_MSG_2
	LD	HL,P_COUNT
	LD	(HL),1
	LD	B,2
	CALL	SENDHS
;
	LD	A,(P_COUNT+1)
	OR	A
	RET	Z
	LD	B,A
SN_1	PUSH	BC
	CALL	PUTNEWS
	POP	BC
	DJNZ	SN_1
	RET
;
RECVMAIL
	LD	HL,M_RM
	CALL	LOG_MSG_2
;
	LD	DE,FCB_NMAIL
	CALL	OPENF
;
	CALL	RECVHS
	JP	NZ,FAILED
	LD	A,(HS_BUF+0)
	CP	3
	JP	NZ,OOSYNC
;
	LD	A,(HS_BUF+1)
	LD	(NITEMS),A
	OR	A
	JR	Z,RM_2		;No mail to receive
	LD	B,A
RM_1	PUSH	BC
	CALL	GETMAIL
	POP	BC
	DJNZ	RM_1
RM_2	LD	DE,FCB_NMAIL
	CALL	CLOSEF
	RET
;
SENDMAIL
	LD	HL,M_SM
	CALL	LOG_MSG_2
;
	LD	HL,FCB_ACS
	LD	DE,FILENAME
	CALL	STRCPY
;
	LD	HL,P_COUNT
	LD	(HL),3
;Open acsnet.net, if nonexistent then no mail to send
	LD	DE,FCB_ACS
	LD	HL,BUF_NEW
	LD	B,0
	CALL	DOS_OPEN_EX
	JR	Z,SM_0A
;
	XOR	A
	LD	(P_COUNT+1),A
	LD	HL,P_COUNT
	LD	B,2
	CALL	SENDHS
	RET
;
SM_0A
	LD	A,1		;One file, acsnet.net
	LD	(P_COUNT+1),A
	LD	HL,P_COUNT
	LD	B,2
	CALL	SENDHS
	JP	NZ,FAILED
;
	CALL	PUTMAIL
	RET	NZ		;If failed.
	LD	DE,FCB_ACS
	CALL	DOS_KILL
	RET
;
RECVFILES
	LD	HL,M_RF
	CALL	LOG_MSG_2
;
	LD	DE,FCB_NFILES
	CALL	OPENF
;
	CALL	RECVHS
	JP	NZ,FAILED
	LD	A,(HS_BUF+0)
	CP	4
	JP	NZ,OOSYNC
;
	LD	A,(HS_BUF+1)
	LD	(NITEMS),A
	OR	A
	JR	Z,RF_2		;No files to receive
	LD	B,A
RF_1	PUSH	BC
	CALL	GETFILES
	POP	BC
	DJNZ	RF_1
RF_2	LD	DE,FCB_NFILES
	CALL	CLOSEF
	RET
;
OPENF	LD	HL,BUF_NEW
	LD	B,0
	CALL	DOS_OPEN_EX
	JP	NZ,FAILED
	CALL	DOS_POS_EOF
	RET
;
CLOSEF
	CALL	DOS_CLOSE
	JP	NZ,FAILED
	RET
;
SENDFILES
	LD	HL,M_SF
	CALL	LOG_MSG_2
	LD	HL,P_COUNT
	LD	(HL),4
	XOR	A
	LD	(P_COUNT+1),A
	LD	B,2
	CALL	SENDHS
;
	LD	A,(P_COUNT+1)
	OR	A
	RET	Z
	LD	B,A
SF_1	PUSH	BC
	CALL	PUTFILES
	POP	BC
	DJNZ	SF_1
	RET
;
GETNEWS
;
	LD	HL,NPREFIX
	LD	DE,FILENAME
	CALL	STRCPY
;
	LD	HL,HS_BUF+1
	CALL	STRCAT		;append NNNN
;
	LD	HL,NSUFFIX
	CALL	STRCAT
;
	LD	HL,FILENAME
	CALL	FILERECV
	JP	NZ,FAILED
	LD	HL,FILENAME
	LD	DE,FCB_NNEWS
	CALL	MESS_0
	LD	A,CR
	CALL	$PUT
	RET
;
PUTNEWS
	;Fix up the filename
	LD	HL,P_FNAME
	LD	B,6
	CALL	SENDHS
	JP	NZ,FAILED
	;Send the file
	LD	HL,FILENAME
	CALL	FILESEND
	RET
;
GETMAIL
	LD	HL,MPREFIX
	LD	DE,MSUFFIX
	CALL	GETFNAME
;
	LD	HL,FILENAME
	CALL	FILERECV
	JP	NZ,FAILED
	LD	HL,FILENAME
	LD	DE,FCB_NMAIL
	CALL	MESS_0
	RET
;
PUTMAIL
	;Fix up the filename
	LD	HL,P_FNAME
	LD	B,6
	CALL	SENDHS
	JP	NZ,FAILED
	;Send the file
	LD	HL,FILENAME
	CALL	FILESEND
	RET
;
GETFILES
	LD	HL,FPREFIX
	LD	DE,FSUFFIX
	CALL	GETFNAME
;
	LD	HL,FILENAME
	CALL	FILERECV
	JP	NZ,FAILED
	LD	HL,FILENAME
	LD	DE,FCB_NFILES
	CALL	MESS_0
	RET
;
PUTFILES
	;Fix up the filename
	LD	HL,P_FNAME
	LD	B,6
	CALL	SENDHS
	JP	NZ,FAILED
	;Send the file
	LD	HL,FILENAME
	CALL	FILESEND
	RET
;
GETFNAME
	PUSH	DE
	PUSH	HL
	CALL	RECVHS
	JP	NZ,FAILED
;
	LD	A,(HS_BUF+0)
	CP	2
	JP	NZ,OOSYNC
;
	POP	HL		;prefix
	LD	DE,FILENAME
	CALL	STRCPY
;
	LD	HL,HS_BUF+1
	CALL	STRCAT		;append NNNN
;
	POP	HL		;suffix
	CALL	STRCAT
	RET
;
PROCECHO
	LD	A,(ECHONAME)
	OR	A
	RET	Z		;None received.
	LD	HL,M_PROCE
	CALL	LOG_MSG_2
	LD	HL,PROCE
	CALL	CALL_PROG
	RET
;
OOSYNC	LD	HL,M_OOSYNC
	CALL	LOG_MSG_2
	JP	EXIT
;
SET_1200
	LD	A,82H
	OUT	(WRSTAT),A
	LD	A,40H
	OUT	(WRSTAT),A
	LD	A,(MODEM_STAT1)
	AND	0FCH
	OR	02H		;set to 1200 baud
	LD	(MODEM_STAT1),A
	OUT	(WRSTAT),A
	LD	A,(MODEM_STAT2)
	RES	RTS,A		;reset "double speed"
	LD	(MODEM_STAT2),A
	OUT	(WRSTAT),A
	RET
;
LOG_MSG_2
	PUSH	HL
	CALL	LOG_MSG
	POP	HL
	LD	DE,$DO
	CALL	MESS_0
	RET
;
FAILED
	LD	HL,M_FAILED
	CALL	LOG_MSG_2
	JP	EXIT
FAILMSG
	CALL	LOG_MSG_2
	JR	FAILED
;
RET_NZ	OR	A
	RET	NZ
	CP	1
	RET
;
;=
;
*GET	ACSNET1
*GET	ROUTINES
;
M_FAIL1	DEFM	'Could not receive echonews',CR,0
M_FAIL2	DEFM	'Failed to receive pre-echonews packet',CR,0
M_OOSYNC
	DEFM	'Out of sync with other side',CR,0
M_END
	DEFM	'Acsnet program terminating',CR,0
;
M_RN	DEFM	'--> Getting news items',CR,0
M_SN	DEFM	'--> Sending news items',CR,0
M_RM	DEFM	'--> Getting mail',CR,0
M_SM	DEFM	'--> Sending mail',CR,0
M_RF	DEFM	'--> Getting files',CR,0
M_SF	DEFM	'--> Sending files',CR,0
M_RE	DEFM	'--> Getting news as echo',CR,0
;
M_PROCE
	DEFM	'Processing news cum echomail',CR,0
M_FAILED
	DEFM	'Acsnet program failed',CR,0
M_CONNECT
	DEFM	'-> ACSnet site connected to Zeta',CR,0
;
NPREFIX	DEFM	'news',0
NSUFFIX	DEFM	'.nws',0
MPREFIX	DEFM	'mail',0
MSUFFIX	DEFM	'.acs',0
FPREFIX	DEFM	'file',0
FSUFFIX	DEFM	'.acs',0
;
ECHONAME
	DEFM	'echonews',0
PROCE	DEFM	'pktdis echonews',0
FILENAME
	DEFS	32
STRING	DEFS	256
;
BUF_NEW	DEFS	256	;Common buffer
FCB_NNEWS DEFM	'newnews.zms',CR,0
	DC	32-13,0
FCB_NMAIL DEFM	'newmail.zms',CR,0
	DC	32-13,0
FCB_NFILES DEFM	'newfiles.zms',CR,0
	DC	32-14,0
FCB_ACS	DEFM	'acsnet.net/poof',CR,0
	DC	32-17,0
ACSFILE	DEFM	'0000',0
;
P_READY
	DEFB	0
P_COUNT
	DEFB	1	; 1= News, 3=mail, 4=files
	DEFB	0	; Actual value 0 - 255.
;
P_FNAME
	DEFB	2	; 2= 'File number follows'
	DEFM	'0000'	; File number 4 digits 0-fill
	DEFB	0
;
M_DONE	DEFM	'--> ACSnet connection done',CR,0
;
NITEMS	DEFB	0
;
THIS_PROG_END	EQU	$
;
	END	START
