{ ROSMACTK.INC for the teletek sbc-I and Hayes Smart Modem 1200   }
(* The clock code will only work if you are running  the MDZ
 multi user operating system. This code is based on the ROSMACKP
 include file. I don't know who wrote it so I cannot give them
 the credit they are due. I will however, leave my name so you
 may moan, groan, complain or offer solutions.
 Steve Davis. Sysop of Dragon RCP/M (505) 344-3171
 04/23/85 added procedure mdsend to eliminate about a dozen
 for loops.
 Also added PutStat, System_init and mdbusy to be compatible
 with ROS 3.2.
                                     1  2  3  4  5  6  7  8
Hayes Smart Moden switch settings : UP UP DN UP DN UP UP DN   *)

     {** Time and date routines }

procedure GetTAD(var t: tad_array);
{ Return a 6 element integer array of the current system time in
  seconds, minutes, hours, day, month, and year. }
var
    cmdbuffer: array[0..32] of byte absolute $E7A0;
begin
  fillchar(cmdbuffer,33,0); { Zero the Command Buffer }
  cmdbuffer[0]:=$0C;  { DOSCOMMAND TIME OF DAY }
  cmdbuffer[1]:=$00;   { MASTER TO SLAVE GET TIME }
  INLINE($11/$A0/$E7);{ ld de,(address of 32 byte command buffer }
  INLINE($CD/$58/$F0);{ call system master doscommand }
  t[0]:=cmdbuffer[2];      { seconds }
  t[1]:=cmdbuffer[3];      { minutes }
  t[2]:=cmdbuffer[4];      { hours   }
  t[3]:=cmdbuffer[6];      { day     }
  t[4]:=cmdbuffer[7];      { month   }
  t[5]:=cmdbuffer[5];      { year    }
end;

procedure SetTAD(var t: tad_array);
{ Set the system time using a 6 element integer array which contains
  seconds, minutes, hours, day, month, and year. }
var
    cmdbuffer: array[0..32] of byte absolute $E7A0;
begin
  fillchar(cmdbuffer,33,0);{ZERO BUFFER }
  cmdbuffer[0]:=$0C;  { DOSCOMMAND TIME OF DAY }
  cmdbuffer[1]:=$01;   { MASTER TO SLAVE SET TIME }
  cmdbuffer[2] := t[0]; { fill the buffer with the current time }
  cmdbuffer[3] := t[1];
  cmdbuffer[4] := t[2];
  cmdbuffer[6] := t[3];
  cmdbuffer[7] := t[4];
  cmdbuffer[5] := t[5];
  INLINE($11/$A0/$E7);{ LD DE,(ADDRESS OF 32 BYTE MASTER BUFFER }
  INLINE($CD/$58/$F0);{ CALL F058H MASTER EXECUTE DOSCMD        }
end;

procedure SpecialBell(bell_on: boolean);
{ Signal sysop from chat with special bell (if available) }
begin
  if bell_on
    then port[$C8] := $0F
    else port[$C8] := $07
end;

const
{ Machine specific constants }

  DataPort   = $00;          { Data port }
  StatusPort = $01;          { Status port }
  RatePort   = $08;          { Data rate (bps) port }

  RESCHN     = $18;          { reset channel }
  RESSTA     = $14;          { reset ext/status }
  WRREG1     = $00;          { value to write to register 1 }
  WRREG3     = $C1;          { 8 bits/char, rx enable }
  WRREG4     = $44;          { 16x, 1 stop bit, no parity }
  DTROFF     = $68;          { dtr off, rts off }
  DTRON      = $EA;          { dtr on, 8 bits/char, tx enable, rts on }
  ONINS      = $30;          { error reset }

{ StatusPort status masks }

  DAV        = $01;          { data available }
  TRDY       = $04;          { transmit buffer empty }
  DCD        = $20;          { data carrier detect }
  PE         = $10;          { parity error }
  OE         = $20;          { overrun error }
  FE         = $40;          { framing error }
  ERR        = $60;          { parity, overrun and framing error }

{ Smartmodem result codes }

  OKAY        = '0';         { Command executed with no errors }
  CONNECT300  = '1';         { Carrier detect at 300 bps }
  RING        = '2';         { Ring signal detected }
  NOCARRIER   = '3';         { Carrier lost or never heard }
  ERROR       = '4';         { Error in command execution }
  CONNECT1200 = '5';         { Carrier detect at 1200 bps }

{ Rate setting commands }
  BDSET1200  = 71;
  BDSET300   = 7;
  BD300      = 52;            { 300 bps }
  BD1200     = 64;            { 1200 bps }

procedure putstat(st: StrStd);
{ Put 'st' on status line and return to normal display }
  const
    status_line    =  1;                    { Line used for system status }
    last_line      = 25;                    { Last line on screen }
  begin
    GotoXY(1, status_line);
    ClrEol;
    LowVideo;
    write(st);
    HighVideo;
    GotoXY(1, last_line)
  end;

procedure mdout(b: byte);
{ Output a byte to modem - wait until ready }
begin
  repeat
  until ((TRDY and port[StatusPort]) <> 0);
  port[DataPort] := b
end;

function mdinp: byte;
{ Input a byte from modem - no wait - assumed ready }
const
  NOPAR = $7F;
var
  bt: byte;
begin
  bt := port[DataPort];
  mdinp := NOPAR and bt
end;


procedure mdsend(mstr: StrStd;lstr: Integer);
{ Send a command string to the modem w/ CR and delay }
var
  i           :  integer;
  bt          :  byte;
begin
  for i := 1 to lstr do
  begin
    bt := ord(mstr[i]);
    mdout(bt)
  end;
  bt := ord(CR);
  mdout(bt);
  delay(2000);
end;


procedure mdinit;
{ Initialize the sio channel and the Hayes Smartmodem 1200 }
const
  sio_init: array[1..9] of byte = (RESCHN, 4, WRREG4, 1, WRREG1, 3, WRREG3, 5, DTROFF);
var
  i: integer;
  mdmstr   : StrStd;
  bt       : byte;
begin
  for i := 1 to 9 do
    port[StatusPort] := sio_init[i];        { initialize the SIO channel }
  port[StatusPort] := 5;                    { pull DTR high }
  port[StatusPort] := DTRON;
  port[RatePort] := BDSET1200;
  port[RatePort] := BD1200;                 {set the ZSIO to 1200 baud}
  delay (500);                         {let the modem settle for a bit}
  mdmstr := 'ATZ';
  mdsend(mdmstr,3);
  mdmstr := 'AT';
  mdsend(mdmstr,2);            {force the modem to 1200 baud}
  mdmstr :=  'ATE0Q0V0M0X1 S0=0 S2=3 S4=255 S5=255';
  mdsend(mdmstr,41);
  bt := mdinp;                              { clear any previous rings }
  bt := mdinp
end;

function mdinprdy: boolean;
{ Check for ready to input from modem }
var
  bt: byte;
begin
  if ((DAV and port[StatusPort]) <> 0) then
    begin
      port[StatusPort] := 1;
      if ((ERR and port[StatusPort]) <> 0) then
        begin
          port[StatusPort] := ONINS;
          bt := port[DataPort];
          mdinprdy := FALSE
        end
      else mdinprdy := TRUE
    end
  else mdinprdy := FALSE
end;

function mdring: boolean;
{ Determine if the phone is ringing }
var
  code: char;
begin
  if mdinprdy then
    begin
      code := chr(mdinp);
      if code = RING then mdring := TRUE
      else mdring := FALSE
    end
  else mdring := FALSE
end;


function mdcarck: boolean;
{ Check to see if carrier is present }
begin
  port[StatusPort] := RESSTA;
  mdcarck := ((DCD and port[StatusPort]) <> 0)
end;


procedure mdhangup;
{ Hangup modem }
var
  mdmstr   : StrStd;
begin
  repeat
    port[StatusPort] := 5;             { setup to write register 5 }
    port[StatusPort] := DTROFF;        { clear DTR, causing hangup }
    delay(2000);
    port[StatusPort] := 5;
    port[StatusPort] := DTRON;
    if mdcarck then
      begin
        mdmstr := chr(3)+chr(3)+chr(3);
        mdsend(mdmstr,3);             { get modems attention }
        mdmstr := 'ATH0';
        mdsend(mdmstr,4);             { hang up phone }
      end;
  until not mdcarck
end;

procedure mdans;
{ Detect and set system to rate at which modem answered phone }
var
  mdmstr   : StrStd;
  code     : char;
  bt       : byte;
begin
  repeat
  until mdinprdy;
  bt := mdinp;
  mdmstr := 'ATA';
  mdsend(mdmstr,3);
  repeat
  until mdinprdy;
  code := chr(mdinp);
  if code = CONNECT1200 then
    begin
      port[RatePort] := BDSET1200;
      port[RatePort] := BD1200;
      rate := 50;
      delay(500);
      bt := mdinp;
      bt := mdinp
    end;
  if code = CONNECT300 then
    begin
      port[RatePort] := BDSET300;
      port[RatePort] := BD300;
      rate := 200;
      delay(500);
      bt := mdinp;
      bt := mdinp
    end;
  if code = NOCARRIER then mdhangup
end;

procedure system_init;
{ System particular initialization to be done once (when ROS first starts) }
  begin
  end;



procedure mdbusy;
{ Take modem off hook to present a busy signal to incoming callers }
var
  mdmstr :  String[4];
begin
  mdmstr := 'ATH1'; { take modem off hook to give busy signal }
  mdsend(mdmstr,4);
end;
