{ ROSMAC.INC - Remote Operating System Machine Dependent Routines }

     {** Time and date routines - Xerox 820-II code by Steve Fox }

function find_clock: integer; external $F039;
{ Find the address of the 820's clock buffer which stores system time
  in the following order:
    day, month, year, hour, minute, second. }

procedure GetTAD(var t: tad_array);
{ Return a 6 element byte array of the current system time in
    seconds, minutes, hours, day, month, and year. }
  var
    clock: integer;
  begin
    clock := find_clock;
    t[0] := mem[clock + 5];
    t[1] := mem[clock + 4];
    t[2] := mem[clock + 3];
    move(clock, t[3], 3)
  end;

procedure SetTAD(var t: tad_array);
{ Set the system time using a 6 element byte array which contains
    seconds, minutes, hours, day, month, and year. }
  var
    clock: integer;
  begin
    clock := find_clock;
    mem[clock + 5] := t[0];
    mem[clock + 4] := t[1];
    mem[clock + 3] := t[2];
    move(t[3], clock, 3)
  end;

