{ ROSUTL.INC - Remote Operating System Utility Sub-system }

overlay procedure display_users;
{ Display user file }
  const
    col_width = 19;
  var
    i, colbeg, colend, len: integer;
    ch, disp_case, disp_nois: char;
    t: tad_array;
    key: StrName;
    str: StrTAD;
    temp_user_rec: user_list;
  begin
    if (user_rec.access >= 250) or (not remote_copy)
      then
        repeat
          ch := select('Type of list', 'AllExceptionalQuickUnvalidated');
          if ch = '?'
            then Writeln(USR, '<A>ll, <E>xceptional, <Q>uick, <U>nvalidated');
        until ch in ['A', 'E', 'Q', 'U']
      else ch := 'Q';
    Writeln(USR);
    Writeln(USR, 'The user list will be alphabetic by last name,');
    Writeln(USR, 'starting with a character or string you specify.');
    Writeln(USR);
    key := prompt('Start [C/R for all names]', len_name, 'ES');
    if key = ''
      then
        begin
          ClearKey(IdxF);
          NextKey(IdxF, i, key)
        end
      else
        begin
          SearchKey(IdxF, i, key);
          if not OK
            then
              begin
                ClearKey(IdxF);
                NextKey(IdxF, i, key)
              end
        end;
    GetTAD(t);
    str := FormTAD(t);
    if ch = 'E'
      then Write(USR, 'Exceptional ')
    else if ch = 'U'
      then Write(USR, 'Unvalidated ');
    Writeln(USR, 'Users As Of: ', str);
    Writeln(USR);
    if (user_rec.access >= 250) or (not remote_copy)
      then Write(USR, FileLen(DatF), ' records, ');
    Writeln(USR, UsedRecs(DatF), ' users in file.');
    colend := 999;
    while (not brk) and OK do
      with temp_user_rec do
        begin
          GetRec(DatF, i, temp_user_rec);
          if (ch = 'Q') and (fn <> 'SYSOP') and (access >= val_acc)
            then
              begin
                key := fn + ' ' + ln;
                colbeg := succ(colend);
                while 0 <> colbeg mod col_width do
                  colbeg := succ(colbeg);
                len := colbeg - colend;
                colend := colbeg + length(key);
                if colend > user_rec.columns
                  then
                    begin
                      Writeln(USR);
                      colend := length(key)
                    end
                  else Write(USR, ' ':len);
                Write(USR, key)
              end
          else if (ch = 'A')
               or ((ch = 'U') and (access < val_acc))
               or ((ch = 'E') and ((access > val_acc) or (limit > val_time)))
            then
              begin
                Writeln(USR,
                  pad(ln, succ(len_ln)),
                  pad(fn, succ(len_fn)),
                  pad(cy, succ(len_cy)),
                  pad(st, succ(len_st)),
                  pad(ph, succ(len_ph)));
                if shift_lock
                  then disp_case := 'U'
                  else disp_case := 'L';
                if noisy
                  then disp_nois := 'N'
                  else disp_nois := 'Q';
                str := FormTAD(laston);
                Writeln(USR,
                  '    ',
                  access:4,
                  limit:4,
                  nulls:2,
                  disp_case:2,
                  disp_nois:2,
                  help_level:2,
                  columns:3,
                  lines:3,
                  str:28,
                  time_today:3,
                  time_total:5,
                  lasthi:5,
                  upload:3,
                  download:4)
              end;
          NextKey(IdxF, i, key)
        end
  end;

overlay function chat: boolean;
{ Chat with sysop }
  var
    ch: char;
    i: integer;
    count: real;
    t: tad_array;
    str: StrStd;
  begin
    OK := op_chat;
    if op_chat
      then Writeln(USR, 'Chat requested by Sysop...', BEL, BEL)
      else
        begin
          GetTAD(t);
          if (t[2] < ChatStart) or (t[2] > pred(ChatEnd))
            then Writeln(USR, 'Sorry, the hours to chat are ', ChatStart, ':00 to ', ChatEnd, ':00.')
            else
              begin
                Writeln(USR);
                Writeln(USR, 'Please standby ', user_rec.fn, ' ', user_rec.ln, '.');
                Writeln(USR, 'Will ring for 30 seconds.  Type ^C to cancel.');
                Writeln(USR);
                Write(USR, '|-------------------------------|', CR, '|');
                i := 15;
                repeat
                  Write(BEL, BEL, BEL);           { BEL is not normally sent to console }
                  Write(USR, '-+', BEL);
                  count := 1.6 * lps;
                  repeat
                    ch := GetChar;
                    count := count - 1.0
                  until (not online) or (count < 0.0) or (ch in [ETX, ESC]);
                  i := pred(i)
                until (not online) or (i <= 0) or (ch in [ETX, ESC]);
                Writeln(USR);
                if ch = ETX
                  then Writeln(USR, 'Cancelled.')
                  else if ch = ESC
                    then
                      begin
                        Writeln(USR, 'Sysop is available.  Type ^C to exit CHAT...');
                        OK := TRUE
                      end
                    else Writeln(USR, 'Sorry, the sysop is not available.')
              end
        end;
    if OK
      then
        begin
          Writeln(USR);
          next_inpstr := '';
          repeat
            str := next_inpstr;
            GetStr(str, ch, len_msg, 'AEW');
            Writeln(USR)
          until (not online) or (ch = ETX);
          chat := FALSE
        end
      else chat := ask('Would you care to leave a message')
  end;

overlay procedure display_time;
{ Display current system time and date }
  var
    t: tad_array;
    str: StrTAD;
  begin
    GetTAD(t);
    str := FormTAD(t);
    Writeln(USR, str);
    if (user_rec.access >= 250) or (not remote_copy)
      then if ask('Do you want to reset the time')
             then
               begin
                 Writeln(USR);              { Change login time so system doesn't hang up on us }
                 login_t[5] := strint(prompt('Year  ', 2, 'E'));
                 login_t[4] := strint(prompt('Month ', 2, 'E'));
                 login_t[3] := strint(prompt('Day   ', 2, 'E'));
                 login_t[2] := strint(prompt('Hour  ', 2, 'E'));
                 login_t[1] := strint(prompt('Minute', 2, 'E'));
                 login_t[0] := strint(prompt('Second', 2, 'E'));
                 SetTAD(login_t);
                 str := FormTAD(login_t);
                 Writeln(USR, str)
               end
  end;

overlay procedure display_stats;
  var
    i, days, max: integer;
    t: tad_array;
    day_array: array[0..23] of integer;

  procedure show_graph(title: StrPr);
    var
      i, j: integer;
      factor, scale: real;
      line: StrStd;
    begin
      Writeln(USR, ' ':8, title, ' for the Last ', days, ' Days');
      Writeln(USR);
      factor := max / 15.0;
      for j := 15 downto 1 do
        begin
          line := '                                                                       ';
          scale := factor * j;
          for i := 0 to 23 do
            if day_array[i] > scale
              then
                begin
                  line[1 + 3 * i] := '*';
                  line[2 + 3 * i] := '*'
                end;
          Write(USR, scale:3:0);
          i := length(line);
          while line[i] = ' ' do
            i := pred(i);
          Writeln(USR, ' ', copy(line, 1, i))
        end;
      Writeln(USR, '    12  1  2  3  4  5  6  7  8  9 10 11 12  1  2  3  4  5  6  7  8  9 10 11');
      Writeln(USR, '    |------------- A. M. ---------------|------------- P. M. -------------|')
    end;

  begin { show_stats }
    GetTAD(t);
    days := round(greg_to_jul(t[3], t[4], t[5]) - greg_to_jul(stat_rec.date[3],
      stat_rec.date[4], stat_rec.date[5]));
    if days = 0
      then days := 1;
    max := 0;
    for i := 0 to 23 do
      begin
        day_array[i] := round((100.0 * stat_rec.busy_per_hour[i]) / (60.0 * days));
        if max < day_array[i]
          then max := day_array[i]
      end;
    show_graph('Percent of Average System Usage by Hour')
  end;

overlay procedure alter_user_params;
{ Get new user parameters }
  var
    valid, continue: boolean;
    ch: char;
    i: integer;
    temp: string[2];
  begin
    repeat
      continue := TRUE;
      ch := select('Parameter', 'BellCharactersHelpLinesNullsPasswordShiftlock');
      case ch of
        'B': begin
               user_rec.noisy := not user_rec.noisy;
               if user_rec.noisy
                 then Writeln(USR, 'Prompt bell on.')
                 else Writeln(USR, 'Prompt bell off.')
             end;
        'C': begin
               Writeln(USR, 'Current characters-per-line setting is ', user_rec.columns, '.');
               temp := prompt('New setting [20-80]', 2, 'ES');
               i := strint(temp);
               if (temp = '') or (not i in [20..80])
                 then Writeln(USR, 'Characters-per-line unchanged.')
                 else user_rec.columns := i
             end;
        'H': begin
               Writeln(USR, 'Current help level: ', user_rec.help_level);
               temp := prompt('New level [0-3]', 1, 'AES');
               i := strint(temp);
               if (temp = '') or (not i in [0..3])
                 then Writeln(USR, 'Help level unchanged.')
                 else user_rec.help_level := i
             end;
        'L': begin
               Writeln(USR, 'Current lines-per-page setting is ', user_rec.lines, '.');
               temp := prompt('New setting [10-48 or 99 to inhibit pause]', 2, 'ES');
               i := strint(temp);
               if (temp = '') or (not i in [10..48, 99])
                 then Writeln(USR, 'Lines-per-page unchanged.')
                 else user_rec.lines := i
             end;
        'N': begin
               Writeln(USR, 'Currently using ', user_rec.nulls, ' nulls.');
               get_nulls
             end;
        'P': begin
               get_old_password('Please enter current password', valid);
               if valid
                 then get_new_password
                 else Writeln(USR, 'Password unchanged.')
             end;
        'S': get_case;
        '?': begin
               list('C');
               continue := FALSE
             end
      end
    until continue
  end;


