{ ROSMAIN.INC - Remote Operating System mainline code }

begin { ROS }
  system_init;
  cold_start;
  setup;
  local_online := TRUE;
  display_time;
  local_online := FALSE;
  wait_for_user;
  while not fini do
    begin
      login;
      if online and in_use
        then
          begin
            if user_rec.access >= 250
              then
                begin
                  mesg_area_change('SYSTEM');
                  file_area_change('NEWIN')
                end
              else
                begin
                  mesg_area_change('POST');
                  file_area_change('LOGIN')
                end;
            list('B')
          end;
      while online and in_use do
        begin
          if op_chat
            then op_chat := chat;
          timer(time_on, time_left);
          st := intstr(time_left, 1) + '-';
          if user_rec.help_level > 0
            then st := st + pr_msg[mode]
            else st := st + pr_msg[mode][1];
          case mode of
            message_mode: st := st + ' ' + AreaReq;
            files_mode  : begin
                            st := st + ' ' + SectReq;
                            if in_library
                              then st := st + ' [' + LibReq + ']';
                            if new_dir
                              then directory;
                            if up_down_display
                              then
                                begin
                                  writeln(USR, user_rec.upload, ' uploads, ',
                                    user_rec.download, ' downloads to date.');
                                  up_down_display := FALSE
                                end
                          end
          end;
          if time_left <= 0
            then
              begin
                writeln(USR, 'Access time expired.  Please call back tomorrow.', BEL, BEL, BEL);
                remote_online := FALSE
              end
          else if time_left <= 2
                 then writeln(USR, 'Less than 2 minutes of access time left.  Please finish up.', BEL);
          writeln(USR);
          putstat(user_rec.fn + ' ' + user_rec.ln + '  ' + user_rec.cy + ', ' +
            user_rec.st + '  Access: ' + intstr(user_rec.access, 1) + '  On: ' +
            intstr(time_on, 1) + '  Heap: ' + intstr(MaxAvail, 1));
          ch := select(st, rep_msg[mode]);
              case mode of
                message_mode:
                  case ch of
                    'A': mesg_enter('A');
                    'C': mesg_area_change('');
                    'E': mesg_enter(' ');
                    'F': mode := files_mode;
                    'G': in_use := FALSE;
                    'K': mesg_kill;
                    'Q': mesg_quick_scan;
                    'R': mesg_read;
                    'S': mesg_summary;
                    'U': mode := utility_mode;
                    'X': if (user_rec.access >= 250) or (not remote_copy)
                           then mode := sysop_mode;
                    'B', 'I', 'O', '1'..'9': list(ch);
                    '?': list('M')
                  end;
                files_mode:
                  case ch of
                    'C': begin
                           if in_library
                             then library;
                           file_area_change('')
                         end;
                    'D': directory;
                    'F': toggle_st_switch;
                    'G': in_use := FALSE;
                    'L': library;
                    'M': mode := message_mode;
                    'N': newin_list;
                    'R': RecvXmodem;
                    'S': SendXmodem;
                    'T': SendText;
                    'U': mode := utility_mode;
                    'X': if (user_rec.access >= 250) or (not remote_copy)
                           then mode := sysop_mode;
                    '?': list('F')
                  end;
                utility_mode:
                  case ch of
                    'A': alter_user_params;
                    'C': if chat
                           then mesg_enter('S');
                    'F': mode := files_mode;
                    'G': in_use := FALSE;
                    'M': mode := message_mode;
                    'S': display_stats;
                    'T': display_time;
                    'U': display_users;
                    'X': if (user_rec.access >= 250) or (not remote_copy)
                           then mode := sysop_mode;
                    '?': list('U')
                  end;
                sysop_mode:
                  case ch of
                    'A': toggle_audit;
                    'D': delete_user;
                    'E': edit_user;
                    'F': mode := files_mode;
                    'G': in_use := FALSE;
                    'I': rebuild_index;
                    'L': print_log;
                    'M': mode := message_mode;
                    'N': process_newin;
                    'O': process_macro;
                    'P': purge_files;
                    'R': print_messages;
                    'S': sys_dir;
                    'T': toggle_printer;
                    'U': mode := utility_mode;
                    'V': validate_user;
                    'X': if user_rec.access = 255
                           then extended_commands;
                    '?': list('X')
                  end
              end
        end;
      if connected
        then
          begin
            if in_library
              then library;
            if audit_on
              then toggle_audit;
            if user_rec.fn <> 'SYSOP'
              then if not valid_pw
                     then mesg_enter('S')
                     else if ask('Do you have a message for the sysop')
                            then mesg_enter('S');
            wrapup;
            setup
          end;
      wait_for_user
    end;
  system_de_init
end.
