{ ROSFIL.INC - Remote Operating System: File Sub-system }

overlay procedure toggle_st_switch;
{ Toggle file size display }
  begin
    writeln(USR);
    st_switch := not st_switch;
    write(USR, 'File sizes will be shown in ');
    if st_switch
      then writeln(USR, 'bytes, where "k" is 1024.')
      else writeln(USR, 'minutes and seconds of transfer time.')
  end;

overlay procedure newin_list;
{ List new uploads }
  var
    i, line_count: integer;
    str: StrTAD;
    temp_user_rec: user_list;
  begin
    line_count := 0;
    i := pred(FileSize(nwin_file));
    while (not brk) and (i >= 0) do
      begin
        seek(nwin_file, i);
        read(nwin_file, nwin_rec);
        with nwin_rec do
          begin
            if status = public
              then
                begin
                  str := FormTAD(date);
                  GetRec(DatF, user, temp_user_rec);
                  writeln(USR);
                  writeln(USR, pad(name, 15), descr);
                  writeln(USR, '   ', pad(str, 30),
                    temp_user_rec.fn, ' ', temp_user_rec.ln);
                  if user_rec.lines <> 99
                    then
                      begin
                        line_count := succ(line_count);
                        if line_count mod (user_rec.lines div 3) = 0
                        then pause
                      end
                end
          end;
        i := pred(i)
      end
  end;

overlay procedure file_area_change(req: Str10);
{ View and set up file area for use }
  const
    col_width = 12;
  var
    col_count, col_limit, Drive, User: integer;
    this: SectPtr;
    pr: StrPr;
  begin
    col_limit := max(1, user_rec.columns div col_width);
    if req = ''
      then
        begin
          pr := 'File area';
          if user_rec.help_level > 1
            then pr := pr + ' [press "?" for menu]';
          req := prompt(pr, 10, 'ES?')
        end;
    while (not new_dir) and (req <> '') do
      begin
        this := SectBase;
        if req = '?'
          then
            begin
              writeln(USR, 'Available file areas:');
              writeln(USR);
              while (not brk) and (this <> nil) do
                begin
                  if user_rec.access >= this^.SectAccs
                    then writeln(USR, pad(this^.SectName, 14), this^.SectDesc);
                  this := this^.next
                end;
              writeln(USR);
              req := prompt(pr, 10, 'ES?')
            end
        else if req <> ''
          then
            begin
              FindSect(req, Drive, User, OK);
              if OK
                then
                  begin
                    SectReq := req;
                    SetDrv  := Drive;
                    SetUsr  := User;
                    ReadDir(DirEntries, DirSpace, DirBase)
                  end
                else
                  begin
                    writeln(USR, '"', req, '" not found.  Available file areas:');
                    writeln(USR);
                    col_count := 0;
                    this := SectBase;
                    while (not brk) and (this <> nil) do
                      begin
                        if user_rec.access >= this^.SectAccs
                          then
                            begin
                              write(USR, pad(this^.SectName, col_width));
                              col_count := succ(col_count);
                              if 0 = col_count mod col_limit
                                then writeln(USR)
                            end;
                        this := this^.next
                      end;
                    if 0 <> col_count mod col_limit
                      then writeln(USR);
                    writeln(USR);
                    req := prompt(pr, 10, 'ES?')
                  end
            end
      end
  end;

overlay procedure library;
{ Open and close a library }
  var
    i: integer;
    this: FilePtr;
  begin { library }
    if in_library
      then
        begin
          SetSect(SetDrv, SetUsr);          { Close file }
          Close(libr_file);
          SetSect(HomDrv, HomUsr);
          while LibBase <> nil do           { Clean out old list }
            begin
              this := LibBase;
              LibBase := LibBase^.Next;     { Go to next on chain }
              dispose(this)                 { Reclaim space }
            end;
          in_library := FALSE;
          writeln(USR, 'Library ', LibReq, ' closed.')
        end
      else
        begin
          LibReq := prompt('Library', 12, 'ES');
          delete(LibReq, 1, pos(':', LibReq));
          if LibReq <> ''
            then
              begin
                if pos('.', LibReq) = 0
                  then LibReq := LibReq + '.LBR';
                if copy(LibReq, succ(pos('.', LibReq)), 3) = 'LBR'
                  then LibReadDir(LibEntries, LibSpace, LibBase);
                if not in_library
                  then writeln(USR, 'Cannot open ', LibReq, '.')
              end
        end
  end;

overlay procedure directory;
{ Display file area or library directory }
  const
    col_width = 19;
  var
    i, j, k, entries, rows, mm, ss, size, col_count, col_limit, line_count: integer;
    this: FilePtr;
    nodes: array[1..4] of FilePtr;
    st: Str10;
    fn: FileName;
  begin
    col_limit := max(1, user_rec.columns div col_width);
    writeln(USR);
    new_dir := FALSE;
    if in_library
      then
        begin
          this := LibBase;
          entries := LibEntries;
          if entries = 0
            then writeln(USR, '   Library: ', LibReq, ' is empty.')
            else writeln(USR, '   Library: ', LibReq, '   Files: ', entries,
                 '   Space used: ', LibSpace, 'k')
        end
      else
        begin
          this := DirBase;
          entries := DirEntries;
          if entries = 0
            then writeln(USR, '   File area: ', SectReq, ' is empty.')
            else write(USR, '   File area: ', SectReq, '   Files: ', entries,
                 '   Space used: ', DirSpace, 'k');
          if user_rec.access >= 250
            then writeln(USR, '   Free: ', free_space, 'k')
            else writeln(USR)
        end;
    line_count := 2;
    if entries > 0
      then
        begin
          rows := entries div col_limit;
          if 0 <> entries mod col_limit
            then rows := succ(rows);
          nodes[1] := this;
          for i := 2 to col_limit do
            begin
              for j := 1 to rows do
                this := this^.next;
              nodes[i] := this
            end;
          i := 1;
          while (not brk) and (i <= rows) do
            begin
              for j := 1 to col_limit do
                begin
                  this := nodes[j];
                  if (i + rows * pred(j)) <= entries
                    then
                      begin
                        if st_switch
                          then
                            begin
                              size := this^.fsize shr 3;
                              if (this^.fsize mod 8) <> 0
                                then size := succ(size);
                              st := intstr(size, 4) + 'k '
                            end
                          else
                            begin
                              send_time(this^.fsize, mm, ss);
                              st := intstr(mm, 3) + ':' + intstr(ss, 2);
                              for k := 3 to length(st) do
                                if st[k] = ' '
                                  then st[k] := '0'
                            end;
                        fn := this^.fname;
                        if ($80 and ord(fn[11])) <> 0
                          then
                            begin
                              fn[9] := '*'; { Indicate $SYS file }
                              fn[11] := chr($7F and ord(fn[11]))
                            end;
                        write(USR, fn, st);
                        if j < col_limit
                          then write(USR, fence, ' ')
                          else writeln(USR)
                      end
                    else writeln(USR);
                  nodes[j] := nodes[j]^.next   { Go to next on list }
                end;
              if user_rec.lines <> 99
                then
                  begin
                    line_count := succ(line_count);
                    if line_count mod user_rec.lines = 0
                      then pause
                  end;
              i := succ(i)
            end
        end;
    if j <> col_limit
      then writeln(USR)
  end;

