{ ROSDEF.INC - Remote Operating System Definitions }

const
  version        = 'ROS v3.4';
  ver_date       = '10/19/85';

{ User settable constants }

  def_acc        = 10;                      { Default access level }
  def_time       = 20;                      { Default time limit }
  def_chars      = 80;                      { Default characters per line }
  def_lines      = 23;                      { Default lines per page }

  val_acc        = 20;                      { Access level for validated users }
  val_time       = 45;                      { Time limit for validated users }

  ChatStart      = 19;                      { Chat hours }
  ChatEnd        = 22;
  fence          = '|';                     { Character between directory columns }

  unv_days       = 14;                      { Days to retain unvalidated user }
  val_days       = 180;                     { Days to retain validated user }

  unr_days       = 90;                      { Days to retain unread, undeleted messages }
  rea_days       = 14;                      { Days to retain read, undeleted messages }

  Max_Tries      =  3;                      { Max number of tries for password }

  lps            = 1252.0 ;                 { Loops per second }

  BufBlocks      = 1;                       { Blocks in transfer buffer }
  BufSize        = 128;                     { Bytes in transfer buffer }

{ File names }

  user_data      = 'USERDAT';               { User data }
  user_indx      = 'USERIDX';               { Index to user data }
  logr_name      = 'LOG';                   { Log file }
  mesg_name      = 'MESSAGE';               { Messages }
  summ_name      = 'SUMMARY';               { Summaries }
  sysm_name      = 'SYSMSG';                { System messages }
  sect_name      = 'SECTION';               { Section names }
  stat_name      = 'STATS';                 { Statistics }
  nwin_name      = 'NEWIN';                 { New uploads list }

  ext            = '.BB#';                  { File type }

{ ASCII constants }

  NUL            = #$00;
  SOH            = #$01;
  ETX            = #$03;
  EOT            = #$04;
  ACK            = #$06;
  BEL            = #$07;
  BS             = #$08;
  TAB            = #$09;
  LF             = #$0A;
  FF             = #$0C;
  CR             = #$0D;
  DC1            = #$11;                    { XON }
  DC3            = #$13;                    { XOFF }
  NAK            = #$15;
  CAN            = #$18;
  ESC            = #$1B;
  RUB            = #$7F;

{ Turbo Toolbox constants }

  MaxDataRecSize = 123;                     { max record size }
  MaxKeyLen      = 26;                      { max key size }
  PageSize       = 16;                      { page size }
  Order          = 8;                       { half page size }
  PageStackSize  = 5;                       { page buffer size }
  MaxHeight      = 5;                       { max B-tree height }

{ CP/M-80 constants }

  seldrive       = 14;                      { BDOS drive select }
  findfirst      = 17;                      { BDOS search for first file }
  findnext       = 18;                      { BDOS search for next file }
  getdrive       = 25;                      { BDOS get default drive }
  setdma         = 26;                      { BDOS set DMA buffer address }
  getallocvec    = 27;                      { BDOS get allocation vector }
  getdiskparm    = 31;                      { BDOS get disk parameters }
  getseluser     = 32;                      { BDOS get/select user area }

  fcb            = $80;                     { Default DMA buffer address }

{ ROS constants }

  len_fn         = 10;                      { length of firstname }
  len_ln         = 15;                      { length of lastname }
  len_name       = 25;                      {   sum of above }
  len_ad         = 20;                      { length of address }
  len_cy         = 20;                      { length of city }
  len_st         =  2;                      { length of state abbreviation }
  len_ph         = 13;                      { length of phone number }
  len_pw         = 10;                      { length of password }
  len_subj       = 56;                      { length of subject }
  len_msg        = 72;                      { length of message }

  message_mode   = 1;
  files_mode     = 2;
  utility_mode   = 3;
  sysop_mode     = 4;
  pr_msg    : array[1..4] of string[7] =
    ('Message',
     'Files',
     'Utility',
     'Sysop');
  rep_msg   : array[1..4] of string[94] =
    ('AnswerChangeEnterFilesGoodbyeKillQuick-scanReadSummaryUtilityInfoOthers',
     'ChangeDirectoryFilesizeGoodbyeLibraryMessageNewinReceiveSendTypeUtility',
     'AlterChatFilesGoodbyeMessageStatsTimeUsers',
     'AuditDeleteEditFilesGoodbyeIndexLogMessageNewinMacroPurgeReadSys_dirToggleUtilityValidateXtend');

type
  record_status  = (deleted, read, private, public);

  Str3           = string[3];
  Str10          = string[10];
  FileName       = string[12];
  Str14          = string[14];
  StrTAD         = string[27];
  StrPr          = string[50];
  StrStd         = string[80];
  Str100         = string[100];
  StrName        = string[len_name];
  firstname      = string[len_fn];
  lastname       = string[len_ln];
  address        = string[len_ad];
  city           = string[len_cy];
  state          = string[len_st];
  phone          = string[len_ph];
  password       = string[len_pw];
  subject        = string[len_subj];
  message        = string[len_msg];

  tad_array      = array[0..5] of byte;
  name_array     = array[1..11] of byte;
  hour_array     = array[0..23] of integer;
  day_array      = array[0..6] of integer;

  SysmPtr        = ^SysmRecord;
  SysmRecord     =
    record
      key        : char;                    { Key value }
      loc        : integer;                 { Location of record in file }
      next       : SysmPtr                  { Pointer to next element on list }
    end;

  MesgPtr        = ^MesgRecord;
  MesgRecord     =
    record
      MesgNo,                               { Message number }
      SummLoc    : integer;                 { Summary index }
      TypMsg     : byte;                    { Message type }
      next       : MesgPtr                  { Pointer to next element on list }
    end;

  FilePtr        = ^FileRecord;
  FileRecord     =
    record
      fname      : FileName;                { Name of a matching file }
      index,                                { Libraries only: location of file }
      fsize      : integer;                 { Size of file }
      next       : FilePtr                  { Pointer to next element on list }
    end;

  SectPtr        = ^SectRecord;
  SectRecord     =
    record
      SectDrive,                            { Drive }
      SectUser,                             { User area }
      SectAccs   : integer;                 { Access level required }
      SectName   : Str10;                   { Section name }
      SectDesc   : StrPr;                   { Description }
      next       : SectPtr                  { Pointer to next element on list }
    end;

  AreaPtr        = ^AreaRecord;
  AreaRecord     =
    record
      Area,                                 { Area number }
      AreaAccs   : integer;                 { Access level required }
      AreaName   : Str10;                   { Message area name }
      AreaDesc   : StrPr;                   { Description }
      next       : AreaPtr                  { Pointer to next element on list }
    end;

  FileBlock      =
    record
      drive      : byte;                    { Byte code }
      fname      : name_array;              { File name }
      extent,                               { Current extent }
      s1, s2, reccount: byte;               { Used to compute file size }
      map        : array[16..31] of byte    { Data map }
    end;

  EntryBlock =
    record
      status     : byte;
      fname      : name_array;
      index,
      fsize,
      CRC,
      CreationDate,
      LastChangeDate,
      CreationTime,
      LastChangeTime: integer;
      PadCount   : byte;
      filler     : array[27..31] of byte
    end;

  user_list      =
    record
      used       : integer;                 {  2 }
{ Personal information }
      fn         : firstname;               { 11 }
      ln         : lastname;                { 16 }
      ad         : address;                 { 21 }
      cy         : city;                    { 21 }
      st         : state;                   {  3 }
      ph         : phone;                   { 14 }
      pw         : password;                { 11 }
{ User access }
      access     : byte;                    {  1 }
      limit      : byte;                    {  1 }
{ User configuration }
      nulls      : byte;                    {  1 }
      shift_lock : boolean;                 {  1 }
      noisy      : boolean;                 {  1 }
      help_level : byte;                    {  1 }
      columns    : byte;                    {  1 }
      lines      : byte;                    {  1 }
{ User stats }
      laston     : tad_array;               {  6 }
      time_today : integer;                 {  2 }
      time_total : integer;                 {  2 }
      lasthi     : integer;                 {  2 }
      upload     : integer;                 {  2 }
      download   : integer                  {  2 }
    end;                             { Total 123 }

  logr_list      =
    record
      date       : tad_array;               {  6 }
      action     : byte;                    {  1 }
      user       : integer;                 {  2 }
      text       : FileName                 { 13 }
    end;                             { Total  22 }

  summ_list      =
    record
      date       : tad_array;               {  6 }
      status     : record_status;           {  1 }
      area       : byte;                    {  1 }
      num,                                  {  2 }
      num_prev,                             {  2 }
      num_next,                             {  2 }
      user_from,                            {  2 }
      user_to    : integer;                 {  2 }
      subject    : subject;                 { 56 }
      st_rec,                               {  2 }
      size       : integer                  {  2 }
    end;                             { Total  80 }

  stat_list      =
    record
      date       : tad_array;               {  6 }
      busy_per_hour : hour_array;           { 48 }
      busy_per_day  : day_array;            { 14 }
    end;                             { Total  68 }

  nwin_list      =
    record
      date       : tad_array;               {  6 }
      status     : record_status;           {  1 }
      name       : FileName;                { 13 }
      user       : integer;                 {  2 }
      descr      : StrPr                    { 51 }
    end;                             { Total  73 }

  sysm_list      = StrStd;           { Total  81 }
  mesg_list      = message;          { Total  73 }

  untype_file    = file;

var

{ System message global }

  SysmBase       : SysmPtr;                 { Start of linked list }

{ Section globals }

  SectBase       : SectPtr;                 { Start of linked list }
  SectReq        : Str10;                   { Section name }

{ Message area globals }

  AreaBase       : AreaPtr;                 { Start of linked list }
  AreaReq        : Str10;                   { Message area name }
  AreaSet        : integer;                 { Current message area }

{ Directory globals }

  DirBase        : FilePtr;                 { Start of linked list }
  DirEntries,                               { Count of directory entries }
  DirSpace       : integer;                 { Disk space used }

{ Library globals }

  LibBase        : FilePtr;                 { Start of linked list }
  LibEntries,                               { Count of library entries }
  LibSpace       : integer;                 { Space used }
  LibReq         : FileName;                { Library name }

{ Message system globals }

  MesgBase, MesgLast, MesgCurr: MesgPtr;    { Pointers }
  msg_all,                                  { Public message count }
  msg_ind,                                  { Private message count }
  msg_aut,                                  { Authored message count }
  msg_sys,                                  { Sysop viewable message count }
  msg_hi         : integer;                 { High message number }

{ System globals }

  audit_on,                                 { Audit file enabled }
  case_lock,                                { Convert output to upper case }
  cold,                                     { Cold start }
  connected,                                { Connection established }
  delay_down,                               { Shutdown between users }
  fini,                                     { Finished with ROS }
  in_library,                               { Library/section switch }
  in_use,                                   { Successful login }
  local_copy,                               { Console display }
  local_online,                             { Local use allowed }
  new_dir,                                  { New section or library selected }
  noisy,                                    { Prompt bell enable }
  op_chat,                                  { Operator requested chat }
  printer_copy,                             { Printer display }
  remote_copy,                              { Remote display }
  remote_online,                            { Remote use allowed }
  st_switch,                                { Size/time switch }
  up_down_display,                          { Up/download display }
  valid_pw       : boolean;                 { Correct password flag }

  ch             : char;                    { Input character }

  HomDrv, HomUsr,                           { Default drive/user }
  RcvDrv, RcvUsr,                           { Upload drive/user }
  SetDrv, SetUsr,                           { User selected drive/user }
  user_loc,                                 { Location in data file of user record }
  time_on, time_left, extra_time,           { Timers }
  timeout,
  mode,                                     { Current mode of operation }
  macro_ptr,
  free_space,                               { Space remaining on current drive }
  rate           : integer;                 { Current bps rate }

  st,
  macro          : StrPr;                   { Automatic 'keyboard' input }

  next_inpstr    : StrStd;                  { Input string - used for word wrap }

  global_date,                              { For systems without real time clock }
  login_t        : tad_array;               { Login time }

  Buffer: array[1..BufSize] of byte;        { Transfer buffer }

{ Files }

  user_rec       :         user_list;

  sysm_rec       :         sysm_list;
  sysm_file      : file of sysm_list;

  summ_rec       :         summ_list;
  summ_file      : file of summ_list;

  mesg_rec       :         mesg_list;
  mesg_file      : file of mesg_list;

  logr_rec       :         logr_list;
  logr_file      : file of logr_list;

  stat_rec       :         stat_list;
  stat_file      : file of stat_list;

  nwin_rec       :         nwin_list;
  nwin_file      : file of nwin_list;

  libr_file      : file;

  AuditFile      : text;

