{ ROS33-34.PAS - Remote Operating System File Update Program
  Converts files in version 3.3 format to that expected by version 3.4.
}

{$I ROSDEF.INC}

type
  old_user_list      =
    record
      used       : integer;                 {  2 }
      fn         : firstname;               { 11 }
      ln         : lastname;                { 16 }
      ad         : address;                 { 21 }
      pw         : password;                { 11 }
      access     : byte;                    {  1 }
      help_level : byte;                    {  1 }
      reserved   : byte;                    {  1 }
      limit      : byte;                    {  1 }
      upload     : integer;                 {  2 }
      download   : integer;                 {  2 }
      nulls      : byte;                    {  1 }
      case_sw    : boolean;                 {  1 }
      laston     : tad_array;               {  6 }
      lasthi     : integer;                 {  2 }
      time_today : integer;                 {  2 }
      time_total : integer                  {  2 }
    end;

  old_logr_list      =
    record
      time_stamp : tad_array;
      action     : byte;
      user       : integer;
      text       : FileName;
      reserved   : integer
    end;

  old_summ_list      =
    record
      summ_area  : byte;
      summ_num   : integer;
      summ_date  : tad_array;
      summ_from_num,
      summ_to_num: integer;
      summ_subject: subject;
      summ_st_rec,
      summ_size  : integer
    end;

  old_stat_list      =
    record
      t          : tad_array;
      users_per_hour: hour_array;
      users_per_day : day_array;
      busy_per_hour : hour_array;
      busy_per_day  : day_array
    end;

  old_nwin_list      =
    record
      status     : byte;
      name       : FileName;
      reserved   : integer;
      t          : tad_array;
      user       : integer;
      descr      : StrPr
    end;

  old_sysm_list      = StrStd;
  old_mesg_list      = message;

var
{ Files and file variables }

  user_file          : file of user_list;

  old_user_rec       :         old_user_list;
  old_user_file      : file of old_user_list;

  old_sysm_rec       :         old_sysm_list;
  old_sysm_file      : file of old_sysm_list;

  old_summ_rec       :         old_summ_list;
  old_summ_file      : file of old_summ_list;

  old_logr_rec       :         old_logr_list;
  old_logr_file      : file of old_logr_list;

  old_stat_rec       :         old_stat_list;
  old_stat_file      : file of old_stat_list;

  old_nwin_rec       :         old_nwin_list;
  old_nwin_file      : file of old_nwin_list;

  begin
    ClrScr;
    GotoXY(9, 9);
    writeln('Remote Operating System (ROS) File Conversion Utility');
    GotoXY(1, 11);
    writeln('Converts files in version 3.3 format to that expected by version 3.4');
    GotoXY(4, 13);
    writeln('This program should be run only ONCE on the version 3.3 files');
    writeln;
    writeln;

    Assign(old_user_file, user_data + ext);
    Assign(user_file, user_data + '.$$$');
    {$I-} Reset(old_user_file) {$I+};
    if IOresult = 0
      then
        begin
          write('Converting user file...');
          Rewrite(user_file);
          while not EOF(old_user_file) do
            begin
              read(old_user_file, old_user_rec);
              user_rec.used       := old_user_rec.used;
              user_rec.fn         := old_user_rec.fn;
              user_rec.ln         := old_user_rec.ln;
              user_rec.ad         := '';
              user_rec.cy         := old_user_rec.ad;
              user_rec.st         := '';
              user_rec.ph         := '';
              user_rec.pw         := old_user_rec.pw;
              user_rec.access     := old_user_rec.access;
              user_rec.limit      := old_user_rec.limit;
              user_rec.nulls      := old_user_rec.nulls;
              user_rec.shift_lock := not old_user_rec.case_sw;
              user_rec.noisy      := FALSE;
              user_rec.help_level := old_user_rec.help_level;
              user_rec.columns    := def_chars;
              user_rec.lines      := def_lines;
              user_rec.laston     := old_user_rec.laston;
              user_rec.time_today := old_user_rec.time_today;
              user_rec.time_total := old_user_rec.time_total;
              user_rec.lasthi     := old_user_rec.lasthi;
              user_rec.upload     := old_user_rec.upload;
              user_rec.download   := old_user_rec.download;
              write(user_file, user_rec)
            end;
          Close(user_file);
          Close(old_user_file);

          Rename(old_user_file, user_data + '.BAK');
          Rename(user_file, user_data + ext);
          writeln
        end
      else writeln('User file not found.');

    Assign(old_summ_file, summ_name + ext);
    Assign(summ_file, summ_name + '.$$$');
    {$I-} Reset(old_summ_file) {$I+};
    if IOresult = 0
      then
        begin
          write('Converting message summary file...');
          Rewrite(summ_file);
          while not EOF(old_summ_file) do
            begin
              read(old_summ_file, old_summ_rec);
              summ_rec.date := old_summ_rec.summ_date;
              case old_summ_rec.summ_to_num of
                -1: begin
                      summ_rec.status := public;
                      summ_rec.user_to := 0
                    end;
                -2: begin
                      summ_rec.status := deleted;
                      summ_rec.user_to := 0
                    end;
                else summ_rec.status := private
              end;
              summ_rec.area      := old_summ_rec.summ_area;
              summ_rec.num       := old_summ_rec.summ_num;
              summ_rec.num_prev  := 0;
              summ_rec.num_next  := 0;
              summ_rec.user_from := old_summ_rec.summ_from_num;
              if old_summ_rec.summ_to_num >= 0
                then summ_rec.user_to := old_summ_rec.summ_to_num
                else summ_rec.user_to := 0;
              summ_rec.subject   := old_summ_rec.summ_subject;
              summ_rec.st_rec    := old_summ_rec.summ_st_rec;
              summ_rec.size      := old_summ_rec.summ_size;
              write(summ_file, summ_rec)
            end;
          Close(summ_file);
          Close(old_summ_file);

          Rename(old_summ_file, summ_name + '.BAK');
          Rename(summ_file, summ_name + ext);
          writeln
        end
      else writeln('Summary file not found.');

    Assign(old_logr_file, logr_name + ext);
    Assign(logr_file, logr_name + '.$$$');
    {$I-} Reset(old_logr_file) {$I+};
    if IOresult = 0
      then
        begin
          write('Converting log file...');
          Rewrite(logr_file);
          while not EOF(old_logr_file) do
            begin
              read(old_logr_file, old_logr_rec);
              logr_rec.date   := old_logr_rec.time_stamp;
              logr_rec.action := old_logr_rec.action;
              logr_rec.user   := old_logr_rec.user;
              logr_rec.text   := old_logr_rec.text;
              write(logr_file, logr_rec)
            end;
          Close(logr_file);
          Close(old_logr_file);

          Rename(old_logr_file, logr_name + '.BAK');
          Rename(logr_file, logr_name + ext);
          writeln
        end
      else writeln('Summary file not found.');

    Assign(old_stat_file, stat_name + ext);
    Assign(stat_file, stat_name + '.$$$');
    {$I-} Reset(old_stat_file) {$I+};
    if IOresult = 0
      then
        begin
          write('Converting statistics file...');
          Rewrite(stat_file);
          read(old_stat_file, old_stat_rec);
          stat_rec.date          := old_stat_rec.t;
          stat_rec.busy_per_hour := old_stat_rec.busy_per_hour;
          stat_rec.busy_per_day  := old_stat_rec.busy_per_day;
          write(stat_file, stat_rec);
          Close(stat_file);
          Close(old_stat_file);

          Rename(old_stat_file, stat_name + '.BAK');
          Rename(stat_file, stat_name + ext);
          writeln
        end
      else writeln('Statistics file not found.');

    Assign(old_nwin_file, nwin_name + ext);
    Assign(nwin_file, nwin_name + '.$$$');
    {$I-} Reset(old_nwin_file) {$I+};
    if IOresult = 0
      then
        begin
          write('Converting newin file...');
          Rewrite(nwin_file);
          while not EOF(old_nwin_file) do
            begin
              read(old_nwin_file, old_nwin_rec);
              nwin_rec.date   := old_nwin_rec.t;
              case old_nwin_rec.status of
                0: nwin_rec.status := private;
                1: nwin_rec.status := public;
                2: nwin_rec.status := deleted;
                else write('Invalid status encountered: ', old_nwin_rec.status)
              end;
              nwin_rec.name   := old_nwin_rec.name;
              nwin_rec.user   := old_nwin_rec.user;
              nwin_rec.descr  := old_nwin_rec.descr;
              write(nwin_file, nwin_rec)
            end;
          Close(nwin_file);
          Close(old_nwin_file);

          Rename(old_nwin_file, nwin_name + '.BAK');
          Rename(nwin_file, nwin_name + ext);
          writeln
        end
      else writeln('Newin file not found.');
    writeln;
    writeln('Conversion complete.')
  end.
