{ Translate ROS version 2 user file to version 3 }

program ros2-30;
{$C-}

{$I ROSDEF.INC}                   { Definitions }
{$I ACCESS.BOX}                   { Turbo Toolbox files }

var
  DatF: DataFile;
  IdxF: IndexFile;

{$I ROSMAC.INC}                   { Machine dependent routines }
{$I ROSKER.INC}                   { Kernel - not overlayed }
{$I ROSOV0.INC}                   { Kernel - overlay .000 }
  type dummy = char;                 { Force overlay .001 }
{$I ROSINI.INC}                   { System initialization }

type
  old_user_list = record
    used          : integer;                {  2 }
    fn            : firstname;              { 11 }
    ln            : lastname;               { 16 }
    ad            : address;                { 21 }
    pw            : password;               { 11 }
    access        : byte;                   {  1 }
    maxdrv        : byte;                   {  1 }
    maxusr        : byte;                   {  1 }
    limit         : byte;                   {  1 }
    upload        : integer;                {  2 }
    download      : integer;                {  2 }
    nulls         : byte;                   {  1 }
    case_sw       : byte;                   {  1 }
    laston        : tad_array;              {  6 }
    lasthi        : integer;                {  2 }
    time_today    : integer;                {  2 }
    time_total    : integer;                {  2 }
  end;

var
  i: integer;
  old_user_rec: old_user_list;
begin
  setup;
  for i := 1 to pred(FileLen(DatF)) do
    begin
      GetRec(DatF, i, old_user_rec);
      if old_user_rec.used = 0
        then
          begin
            old_user_rec.limit := def_time;
            if old_user_rec.case_sw = 0
              then old_user_rec.case_sw := -1    { TRUE }
              else old_user_rec.case_sw := 0;   { FALSE }
            PutRec(DatF, i, old_user_rec)
          end
    end
end.
