(*****************************************************************************)
(*                                                                           *)
(*                       ROS - Remote Operating System                       *)
(*                                                                           *)
(*                           Copyright (c) 1985 by                           *)
(*                                                                           *)
(*                                Steven Fox                                 *)
(*                                                                           *)
(*                      All commercial rights reserved.                      *)
(*                                                                           *)
(*****************************************************************************)

program ros;
{$C-}

  { System definitions }
{$I ROSDEF.INC}

  { Turbo Toolbox }
{$I ACCESS.BOX}
{$I GETKEY.BOX}

var
  DatF: DataFile;
  IdxF: IndexFile;

  { Machine dependent code }
{$I ROS.MCH}                                { Computer and channel routines }
{$I ROS.MDM}                                { Modem routines }
{$I ROS.CLK}                                { Clock routines }

  { System kernel }
{$I ROSKIO.INC}                             { I/O drivers - resident }
{$I ROSKMS.INC}                             { Miscellaneous - resident }
{$I ROSKOV.INC}                             { Miscellaneous - overlayed }

  { Turbo Toolbox }
{$I ADDKEY.BOX}
{$I DELKEY.BOX}

  { Force a new overlay }
type dummy = char;

{$I ROSMSG.INC}                             { Message sub-system }
{$I ROSFIL.INC}                             { File sub-system }
{$I ROSSND.INC}                             { File send routines }
{$I ROSRCV.INC}                             { File receive routines }
{$I ROSUTL.INC}                             { Utility sub-system }
{$I ROSSYU.INC}                             { Sysop sub-system, user file routines }
{$I ROSSYM.INC}                             { Sysop sub-system, miscellaneous routines }
{$I ROSSYP.INC}                             { Sysop sub-system, purge routines }
{$I ROSSYX.INC}                             { Sysop sub-system, extended routines }
{$I ROSINI.INC}                             { System initialization/shutdown }

{$I ROSMAIN.INC}
