{ ROSUTL.INC - Remote Operating System Utility Sub-system }

overlay procedure display_users;
{ Display "user" file }
  var
    i, colbeg, colend, len: integer;
    ch, disp_case: char;
    t: tad_array;
    key: StrName;
    temp_user_rec: user_list;
  begin
    if user_rec.access = 255
      then ch := select('<A>ll, <U>nvalidated, or <Q>uick:', 'AllUnvalidatedQuick')
      else ch := 'Q';
    GetTAD(t);
    if ch = 'U'
      then writeln(USR, 'Unvalidated users as of: ', FormTAD(t))
      else writeln(USR, 'User file as of: ', FormTAD(t));
    writeln(USR);
    if user_rec.access = 255
      then write(USR, FileLen(DatF), ' records, ');
    writeln(USR, UsedRecs(DatF), ' users in file.');
    colend := len_msg;
    ClearKey(IdxF);
    repeat
      NextKey(IdxF, i, key);
      if OK
        then with temp_user_rec do
          begin
            GetRec(DatF, i, temp_user_rec);
            if (ch = 'Q') and (fn <> 'SYSOP') and (access >= 20)
              then
                begin
                  key := fn + ' ' + ln;
                  colbeg := colend + 2;
                  while 0 <> colbeg mod 4 do
                    colbeg := succ(colbeg);
                  len := colbeg - colend;
                  colend := colbeg + length(key);
                  if colend > len_msg
                    then
                      begin
                        writeln(USR);
                        colend := length(key)
                      end
                    else write(USR, ' ':len);
                  write(USR, key)
                end
            else if (ch = 'A') or ((ch = 'U') and (access < 20))
              then
                begin
                  if case_sw
                    then disp_case := 'L'
                    else disp_case := 'U';
                  writeln(USR,
                    pad(ln, len_ln), ' ',
                    pad(fn, len_fn), ' ',
                    pad(ad, len_ad), ' ',
                    pad(pw, len_pw), ' ',
                    access:3, ' ',
                    nulls:2, ' ',
                    disp_case, ' ',
                    FormTAD(laston):35, ' ',
                    time_today:2, ' ',
                    time_total:4, ' ',
                    lasthi:4, ' ',
                    upload:3, ' ',
                    download:3)
                end
          end
    until (not OK) or brk
  end;

overlay function chat: boolean;
{ Chat with sysop }
  var
    ch: char;
    i: integer;
    count: real;
    t: tad_array;
    st: StrStd;
  begin
    OK := FALSE;
    GetTAD(t);
    if (t[2] < ChatStart) or (t[2] > ChatEnd - 1)
      then writeln(USR, 'Sorry, the hours to chat are ', ChatStart, ':00 to ', ChatEnd, ':00.')
      else
        begin
          writeln(USR);
          writeln(USR, 'Please standby ', user_rec.fn, ' ', user_rec.ln, '.');
          writeln(USR, 'Will ring for 30 seconds.  Type ^C to cancel.');
          writeln(USR);
          write(USR, '>------------------------------<', CR, '>');
          i := 15;
          repeat
            write(BEL, BEL, BEL);           { BEL is not normally sent to console }
            write(USR, '->', BEL);
            count := 1.6 * lps;
            repeat
              ch := GetChar;
              count := count - 1.0
            until (not online) or (count < 0.0) or (ch in [ETX, ESC]);
            i := pred(i)
          until (not online) or (i <= 0) or (ch in [ETX, ESC]);
          writeln(USR);
          if ch = ETX
            then writeln(USR, 'Cancelled.')
          else if ch = ESC
            then
              begin
                OK := TRUE;
                writeln(USR, 'Sysop is available.  Go ahead (type ^C to exit)...');
                writeln(USR);
                repeat
                  GetStr(st, ch, len_msg, 'EA');
                  writeln(USR)
                until (not online) or (ch = ETX)
              end
            else writeln(USR, 'Sorry, the sysop is not available.')
        end;
    if OK
      then chat := FALSE
      else chat := ask('Would you care to leave a message')
  end;

overlay procedure display_time;
{ Display current system time and date, time on system, and time remaining. }
  var
    time_on: integer;
    t: tad_array;
    st: StrStd;
  begin
    GetTAD(t);
    st := FormTAD(t);
    writeln(USR, st);
    time_on := 60 * t[2] + t[1] - login_time;
    if time_on < 0
      then time_on := time_on + 1440;
    writeln(USR, 'Time on system: ', time_on, '   ', 'time remaining: ', user_rec.limit - time_on);
    if user_rec.access = 255
      then if ask('Do you want to reset the time')
        then
          begin
            writeln(USR);
            writeln(USR, 'Time and date set routine.  Enter exactly 2 digits, please:');
            writeln(USR);
            t[5] := strint(prompt('Year  : ', 2, 'AE'));
            writeln(USR);
            t[4] := strint(prompt('Month : ', 2, 'AE'));
            writeln(USR);
            t[3] := strint(prompt('Day   : ', 2, 'AE'));
            writeln(USR);
            t[2] := strint(prompt('Hour  : ', 2, 'AE'));
            writeln(USR);
            t[1] := strint(prompt('Minute: ', 2, 'AE'));
            writeln(USR);
            t[0] := strint(prompt('Second: ', 2, 'AE'));
            writeln(USR);
            GetTAD(t);
            st := FormTAD(t);
            writeln(USR, st)
          end
  end;

