{ ROSOV0.INC - Remote Operating System Overlay Zero }

overlay procedure list(ch: char);
{ List a portion of the system message file }
  var
    i: integer;
    line: StrStd;
  begin
    writeln(USR);
    Reset(sysm_file);
    repeat
      readln(sysm_file, line)
    until EOF(sysm_file) or ((line[1] = ':') and (line[2] = ch));
    readln(sysm_file, line);
    i := 0;
    while not (EOF(sysm_file) or (line[1] = ':') or brk) do
      begin
        writeln(USR, line);
        readln(sysm_file, line);
        i := succ(i);
        if 0 = i mod DispLines
          then pause
      end;
    Close(sysm_file)
  end;

overlay procedure toggle_st_switch;
{ Toggle file size display }
  begin
    writeln(USR);
    st_switch := not st_switch;
    write(USR, 'File sizes will be shown in ');
    if st_switch
      then writeln(USR, 'bytes, where "k" is 1024.')
      else writeln(USR, 'minutes and seconds of transfer time.')
  end;

overlay procedure get_nulls_and_case;
{ Get nulls and case switch from user }
  begin
    user_rec.case_sw := ask('Can your terminal display lower case');
    user_rec.nulls := strint(select('How many nulls do you need [0-9]? ', ''))
  end;

overlay procedure get_name(var fn: firstname; var ln: lastname);
{ Get user name }
  begin
    writeln(USR);
    repeat
      fn := trim(prompt('FIRST name: ', len_fn, 'ES'));
      writeln(USR)
    until (not online) or (fn <> '');
    if fn = 'SYSOP'
      then ln := ''
      else
        repeat
          ln := trim(prompt(' LAST name: ', len_ln, 'ES'));
          writeln(USR)
        until (not online) or (ln <> '')
  end;

overlay function mesg_start(pr: StrPr): integer;
{ Get starting message number from user }
  var
    i, lo, hi: integer;
  begin
    if MesgBase = nil
      then
        begin
          lo := 0;
          hi := 0
        end
      else
        begin
          lo := MesgBase^.MesgNo;
          hi := MesgLast^.MesgNo
        end;
    i := strint(prompt(pr + ' [' + intstr(lo, 1) + '-' + intstr(hi, 1) + ']? ', 5, 'E'));
    writeln(USR);
    if (i < lo) or (i > hi)
      then
        begin
          writeln(USR, 'Starting after last high message...');
          i := succ(user_rec.lasthi)
        end;
    mesg_start := i
  end;

overlay procedure mesg_delete(num: integer);
{ Delete message indicated by 'num' or the current message if 'num' is 0. }
  var
    this: MesgPtr;
  begin
    if num <> 0
      then
        begin
          mesg_find(num);
          seek(summ_file, MesgCurr^.SummLoc);
          read(summ_file, summ_rec)
        end;
    summ_rec.summ_to_num := mesg_era;
    seek(summ_file, pred(FilePos(summ_file)));
    write(summ_file, summ_rec);
    if MesgCurr = MesgBase
      then
        begin
          MesgBase := MesgBase^.next;
          dispose(MesgCurr)
        end
    else if MesgCurr <> nil
      then
        begin
          this := MesgBase;                 { Find previous record }
          while this^.next <> MesgCurr do
            this := this^.next;
          this^.next := MesgCurr^.next;     { Make it point to next record }
          if MesgLast = MesgCurr
            then MesgLast := this;
          dispose(MesgCurr)
        end;
    writeln(USR, 'Message #', summ_rec.summ_num, ' erased.')
  end;

overlay procedure mesg_header_list(var start, last_line: integer);
{ Display message header }
  var
    to_fn, fr_fn: firstname;
    to_ln, fr_ln: lastname;
    st: StrTAD;
    temp_user_rec: user_list;
  begin
    seek(summ_file, MesgCurr^.SummLoc);
    read(summ_file, summ_rec);
    with summ_rec do
      begin
        if summ_to_num = mesg_pub
          then
            begin
              to_fn := 'ALL';
              to_ln := ''
            end
        else if summ_to_num = mesg_era
          then
            begin
              to_fn := 'MESSAGE';
              to_ln := 'ERASED'
            end
        else if summ_to_num = user_loc
          then
            begin
              to_fn := user_rec.fn;
              to_ln := user_rec.ln
            end
          else
            begin
              GetRec(DatF, summ_to_num, temp_user_rec);
              to_fn := temp_user_rec.fn;
              to_ln := temp_user_rec.ln
            end;
        if summ_from_num = user_loc
          then
            begin
              fr_fn := user_rec.fn;
              fr_ln := user_rec.ln
            end
          else
            begin
              GetRec(DatF, summ_from_num, temp_user_rec);
              fr_fn := temp_user_rec.fn;
              fr_ln := temp_user_rec.ln
            end;
        st := FormTAD(summ_date);
        writeln(USR);
        writeln(USR, 'Message number ', summ_num, '  ', st);
        writeln(USR, 'From: ', fr_fn, ' ', fr_ln);
        writeln(USR, '  To: ', to_fn, ' ', to_ln);
        writeln(USR, '  Re: ', summ_subject);
        start := summ_st_rec;
        last_line := summ_size
      end
  end;

