{ ROSOPS.INC - Remote Operating System Operating Routines }

overlay procedure login;
{ Log user into system }
  var
    valid, continue: boolean;
    key: StrName;

  procedure get_password(var valid: boolean);
  { Accept and validate password.  Everyone gets 'Max_Tries' to get their
    password right.  If it is still wrong they will be logged out. }
    var
      tries: integer;
    begin
      tries := 1;
      repeat
        valid := (user_rec.pw = prompt('  Password: ', len_pw, 'S'));
        writeln(USR);
        tries := succ(tries)
      until (not online) or valid or (tries > Max_Tries);
      if not valid
        then
          begin
            writeln(USR, 'Only ', Max_Tries, ' tries allowed.');
            list('P')
          end
    end;

  procedure get_new_user(var continue: boolean);
  { Get new user information }
    var
      i: integer;
      trial_pw: password;
    begin
      continue := FALSE;
      writeln(USR);
      writeln(USR, 'Name not found.');
      list('A');
      writeln(USR);
      if ask('Are you a new user')
        then with user_rec do
          begin
            get_nulls_and_case;
            ad := prompt('From what CITY and STATE are you calling: ', len_ad, 'E');
            writeln(USR);
            writeln(USR);
            writeln(USR, 'You are ', fn, ' ', ln, ' from ', ad);
            writeln(USR);
            if ask('Is that correct')
              then
                begin
                  continue := TRUE;
                  writeln(USR);
                  writeln(USR, 'Please select and enter a password of 4-', len_pw, ' characters');
                  writeln(USR, 'to ensure that no one else uses your name on the system.');
                  writeln(USR);
                  repeat
                    repeat
                      trial_pw := prompt('Password (will NOT display as you type): ', len_pw, 'S');
                      writeln(USR);
                      i := length(trial_pw);
                      if (i < 4) or (i > len_pw)
                        then writeln(USR, 'Length must be 4-', len_pw, ' characters.');
                    until (not online) or ((4 <= i) and (i <= len_pw));
                    pw := prompt(' Please enter it again for verification: ', len_pw, 'S');
                    writeln(USR);
                    if pw <> trial_pw
                      then writeln(USR, 'No match.  Try again.');
                  until (not online) or (pw = trial_pw);
                  writeln(USR);
                  writeln(USR, 'Please remember your password.');
                  writeln(USR, 'It will be required for all future calls.');
                  used          := 0;       { Defaults }
                  if fn = 'SYSOP'
                    then access := 255
                    else access := def_acc;
                  reserved      := 0;
                  limit         := def_time;
                  for i := 0 to 5 do
                    laston[i]   := 0;
                  time_today    := 0;
                  time_total    := 0;
                  lasthi        := 0;
                  upload        := 0;
                  download      := 0;
                  key := pad(ln, len_ln) + pad(fn, len_fn);
                  AddRec(DatF, user_loc, user_rec);
                  AddKey(IdxF, user_loc, key);
                  list('I');
                  pause;
                  list('D');
                  pause
                end
          end
    end;

  procedure init_user;
  { Initialize user }
    begin
      log(2, '');
      GetTAD(login_t);
      if (login_t[3] <> user_rec.laston[3]) or
         (login_t[4] <> user_rec.laston[4]) or
         (login_t[5] <> user_rec.laston[5]) then user_rec.time_today := 0;
      login_time := 60 * login_t[2] + login_t[1];

      Seek(logr_file, 0);
      Read(logr_file, logr_rec);
      logr_rec.user := succ(logr_rec.user);
      Seek(logr_file, 0);
      Write(logr_file, logr_rec);

      if user_rec.access < 10               { Hang up on twit }
        then remote_online := FALSE
        else
          begin
            writeln(USR);
            writeln(USR, 'Login             : ', FormTAD(login_t));
            writeln(USR);
            writeln(USR, 'Caller number     : ', logr_rec.user);
            writeln(USR, 'Access time today : ', user_rec.time_today);
            writeln(USR, 'Access time total : ', user_rec.time_total);
            writeln(USR, 'Last on system    : ', FormTAD(user_rec.laston));
            writeln(USR, 'Last high message : ', user_rec.lasthi)
          end
    end;

  begin { login }
    timeout := 120;                         { Give 'em two minutes to do something }
    writeln(USR, version);
    list('W');
    repeat
      get_name(user_rec.fn, user_rec.ln);
      key := pad(user_rec.ln, len_ln) + pad(user_rec.fn, len_fn);
      FindKey(IdxF, user_loc, key);
      if OK
        then
          begin
            GetRec(DatF, user_loc, user_rec);
            get_password(valid);
            continue := TRUE
          end
        else
          begin
            valid := TRUE;
            get_new_user(continue)
          end
    until (not online) or continue;
    in_use := online and valid;
    if in_use
      then
        begin
          init_user;
          timeout := 300                    { Now let 'em have 5 minutes }
        end
      else user_loc := 0                    { User not initialized }
  end;

