{ ROSMAC.INC - Remote Operating System Machine Dependent Routines }
{ Modified for Kaypro 10 w/Legacy Time Clock by Chris DeBracy     }
{ 05/04/85. Also removed a 'RING DETECT' bug.  SetTAD is included }
{ but not  called everytime the system is booted up.              }

procedure GetTAD(var t: tad_array);
{ Return a 6 element integer array of the current system time in
  seconds, minutes, hours, day, month, and year. }
var z1,z2,r1,d1,result,temp1,temp2,temp3,temp4,temp5,temp6 : integer;
    aaa                : array[0..12] of integer;
begin
for r1 := 0 to 12 do
 begin
   z1 := $79;
   z2 := $7b;

   port[z1] := 0;
   port[z2] := $cf;
   port[z2] := 0;
   port[z1] := r1;
   port[z1] := r1+128;
   port[z1] := r1;
   {set input mode}
   port[z1] := $20;
   port[z2] := $cf;
   port[z2] := $f;
   port[z1] := $20;
   {read data}
   d1 := port[z1] and $f;
   aaa[r1] := d1;
 end;

  val(chr(aaa[1]+48)+chr(aaa[0]+48),temp1,result);
  val(chr(aaa[3]+48)+chr(aaa[2]+48),temp2,result);
  val(chr(aaa[5]+40)+chr(aaa[4]+48),temp3,result);
  val(chr(aaa[8]+48)+chr(aaa[7]+48),temp4,result);
  val(chr(aaa[10]+48)+chr(aaa[9]+48),temp5,result);
  val(chr(aaa[12]+48)+chr(aaa[11]+48),temp6,result);

t[0] := temp1;
t[1] := temp2;
t[2] := temp3;
t[3] := temp4;
t[4] := temp5;
t[5] := 85;

end;


procedure SetTAD(var t: tad_array);
{ Set the system time using a 6 element integer array which contains
  seconds, minutes, hours, day, month, and year. }
begin
  mem[$FF7C] := t[0];
  mem[$FF7D] := t[1];
  mem[$FF7E] := t[2];
  mem[$FF7F] := pred(t[3]);
  mem[$FF80] := pred(t[4]);
  mem[$FF81] := t[5]
end;



const
{ Machine specific constants }

  DataPort   = $04;          { Data port }
  StatusPort = $06;          { Status port }
  RatePort   = $00;          { Data rate (bps) port }

{ StatusPort commands }

  RESCHN     = $18;          { reset channel }
  RESSTA     = $10;          { reset ext/status }
  WRREG1     = $00;          { value to write to register 1 }
  WRREG3     = $C1;          { 8 bits/char, rx enable }
  WRREG4     = $44;          { 16x, 1 stop bit, no parity }
  DTROFF     = $68;          { dtr off, rts off }
  DTRON      = $EA;          { dtr on, 8 bits/char, tx enable, rts on }
  ONINS      = $30;          { error reset }

{ StatusPort status masks }

  DAV        = $01;          { data available }
  TRDY       = $04;          { transmit buffer empty }
  DCD        = $08;          { data carrier detect }
  PE         = $10;          { parity error }
  OE         = $20;          { overrun error }
  FE         = $40;          { framing error }
  ERR        = $60;          { parity, overrun and framing error }

{ Smartmodem result codes }

  OKAY        = '0';         { Command executed with no errors }
  CONNECT300  = '1';         { Carrier detect at 300 bps }
  RING        = '2';         { Ring signal detected }
  NOCARRIER   = '3';         { Carrier lost or never heard }
  ERROR       = '4';         { Error in command execution }
  CONNECT1200 = '5';         { Carrier detect at 1200 bps }

{ Rate setting commands }

  BD300      = 5;            { 300 bps }
  BD1200     = 7;            { 1200 bps }

function mdcarck: boolean;
{ Check to see if carrier is present }
begin
  port[StatusPort] := RESSTA;
  mdcarck := ((DCD and port[StatusPort]) <> 0)
end;

function mdinprdy: boolean;
{ Check for ready to input from modem }
var
  bt: byte;
begin
  if (DAV and port[StatusPort]) <> 0
    then
      begin
        port[StatusPort] := 1;
        if (ERR and port[StatusPort]) <> 0
          then
            begin
              port[StatusPort] := ONINS;
              bt := port[DataPort];
              mdinprdy := FALSE
            end
          else mdinprdy := TRUE
      end
    else mdinprdy := FALSE
end;

function mdinp: byte;
{ Input a byte from modem - no wait - assumed ready }
begin
  mdinp := port[DataPort]
end;

procedure mdout(b: byte);
{ Output a byte to modem - wait until ready }
begin
  repeat
  until (TRDY and port[StatusPort]) <> 0;
  port[DataPort] := b
end;

procedure mdinit;
{ Initialize the sio channel and the Hayes Smartmodem 1200 }
const
  sio_init: array[1..9] of byte = (RESCHN, 4, WRREG4, 1, WRREG1, 3, WRREG3, 5, DTROFF);
var
  i: integer;
  mdm_attn : string[2];
  mdm_init : string[38];
  bt       : byte;
begin
  for i := 1 to 9 do
    port[StatusPort] := sio_init[i];        { initialize the SIO channel }
  port[StatusPort] := 5;                    { pull DTR high }
  port[StatusPort] := DTRON;
  mdm_attn := 'AT';
  mdm_init := 'ATH0E0Q0V0M0X1 S0=0 S2=3 S4=255 S5=255';
  port[RatePort] := BD1200;                 {set the 8116 to 1200 baud}
  delay (500);                              {let the modem settle for a bit}
  for i := 1 to 2 do
    begin
      bt := ord(mdm_attn[i]);               {force the modem to 1200 baud}
      mdout(bt)
    end;
  bt := ord(CR);
  mdout(bt);
  delay (2000);                             {wait a sec...}
  for i := 1 to 38 do
    begin
      bt := ord(mdm_init[i]);               {initialize the modem}
      mdout(bt)
    end;
  bt := ord(CR);
  mdout(bt);
  bt := mdinp;                              { clear any previous rings }
  bt := mdinp
end;

PROCEDURE MDBUSY;
const
  sio_init: array[1..9] of byte = (RESCHN, 4, WRREG4, 1, WRREG1, 3, WRREG3, 5, DTROFF);
var
  i: integer;
  mdm_attn  : string[2];
  mdm_local : string[6];
  bt        : byte;
begin
  for i := 1 to 9 do
    port[StatusPort] := sio_init[i];        { initialize the SIO channel }
  port[StatusPort] := 5;                    { pull DTR high }
  port[StatusPort] := DTRON;
  mdm_attn := 'AT';
  mdm_local := 'ATM0H1';
  delay (500);                              {let the modem settle for a bit}
  for i := 1 to 2 do
    begin
      bt := ord(mdm_attn[i]);               {force the modem to 1200 baud}
      mdout(bt)
    end;
  bt := ord(CR);
  mdout(bt);
  delay (2000);                             {wait a sec...}
  for i := 1 to 6 do
    begin
      bt := ord(mdm_local[i]);               {initialize the modem}
      mdout(bt)
    end;
  bt := ord(CR);
  mdout(bt);
end;

function mdring: boolean;
{ Determine if the phone is ringing }
begin
  if mdinprdy
    then mdring := (RING = chr(mdinp))
    else mdring := FALSE
end;

procedure mdhangup;
{ Hangup modem }
var
  i        : integer;
  mdm_hang : string[4];
  bt       : byte;
begin
  repeat
    port[StatusPort] := 5;             { setup to write register 5 }
    port[StatusPort] := DTROFF;        { clear DTR, causing hangup }
    delay(2000);
    port[StatusPort] := 5;
    port[StatusPort] := DTRON;
    if mdcarck
      then
        begin
          mdm_hang := 'ATH0';
          for i := 1 to 3 do
            begin
              bt := ord(ETX);
              mdout(bt)
            end;
          delay(1500);
          for i := 1 to 4 do
            begin
              bt := ord(mdm_hang[i]);
              mdout(bt)
            end;
          bt := ord(CR);
          mdout(bt)
        end;
  until not(mdcarck)
end;

procedure mdans;
{ Detect and set system to rate at which modem answered phone }
var
  mdm_answ : string[3];
  code     : char;
  i        : integer;
  bt       : byte;
begin
  repeat
  until mdinprdy;
  bt := mdinp;
  mdm_answ := 'ATA';
  for i := 1 to 3 do
    begin
      bt := ord(mdm_answ[i]);
      mdout(bt)
    end;
  bt := ord(CR);
  mdout(bt);
  repeat
  until mdinprdy;
  code := chr(mdinp);
  if code = CONNECT1200
    then
      begin
        port[RatePort] := BD1200;
        rate := 0.02075;
        delay(500);
        bt := mdinp;
        bt := mdinp
      end;
  if code = CONNECT300
    then
      begin
        port[RatePort] := BD300;
        rate := 0.083;
        delay(500);
        bt := mdinp;
        bt := mdinp
      end;
  if code = NOCARRIER
    then mdhangup
end;

     {** System routines **}

procedure system_init;
{ System particular initialization to be done once (when ROS first starts) }
  begin
  end;

procedure putstat(st: StrStd);
{ Put 'st' on status line and return to normal display }
  const
    status_line    =  1;                    { Line used for system status }
    last_line      = 25;                    { Last line on screen }
  begin
    WRITE (CHR(27), 'C',7);
    WRITE(CHR(27), 'B',0);
    WRITE(CHR(27), 'B',6); WRITE(CHR(27), 'B',7); WRITE(CHR(27), '=8 ');
    ClrEol;
    LowVideo;
    write(st);
    HighVideo;
    Delay(1500); DelLine;
    WRITE(CHR(27), 'C',0); WRITE(CHR(27), 'C',6);
  end;
