{ ROSINI.INC - Remote Operating System initialization routine }

overlay procedure cold_start;
{ One-time initialization routine }
  var
    SDrive: char;
    SUser, SAccs: integer;
    Sthis, SectLast: SectPtr;
    Athis, AreaLast: AreaPtr;
    SName: Str10;
    SDesc: StrPr;

  begin
    HomDrv := BDOS(getdrive);               { Assume system files are }
    HomUsr := BDOS(getseluser, $FF);        {   in the startup area }
    UsrOutPtr := addr(putchar);             { Initialize output driver }
    MesgBase := nil;                        { Start with empty message, }
    DirBase  := nil;                        {   directory, }
    LibBase  := nil;                        {   library, }
    SectBase := nil;                        {   section, }
    AreaBase := nil;                        {   and message area lists }
    delay_down := FALSE;                    { Don't shut down yet }
    in_library := FALSE;                    { Start in non-library mode }
    area_assign := FALSE;                   { Area reassignment off }

    Assign(sect_file, sect_name + ext);     { Build file and message section lists }
    {$I-} reset(sect_file) {$I+};
    OK := (IOresult = 0);
    if OK
      then
        begin
          while not EOF(sect_file) do
            begin
              readln(sect_file, SDrive, SUser, SAccs, SName, SDesc);
              if SDrive = ' '
                then
                  begin
                    new(Athis);
                    if AreaBase = nil
                      then AreaBase := Athis
                      else AreaLast^.next := Athis;
                    AreaLast := Athis;
                    AreaLast^.Area := SUser;
                    AreaLast^.AreaAccs := SAccs;
                    AreaLast^.AreaName := trim(SName);
                    AreaLast^.AreaDesc := trim(SDesc);
                    AreaLast^.next := nil
                  end
                else
                  begin
                    new(Sthis);
                    if SectBase = nil
                      then SectBase := Sthis
                      else SectLast^.next := Sthis;
                    SectLast := Sthis;
                    SectLast^.SectDrive := ord(SDrive) - ord('A');
                    SectLast^.SectUser := SUser;
                    SectLast^.SectAccs := SAccs;
                    SectLast^.SectName := trim(SName);
                    SectLast^.SectDesc := trim(SDesc);
                    SectLast^.next := nil
                  end
            end;
          Close(sect_file);
          Sthis := SectBase;                { Find UPLOAD section }
          repeat
            Sthis := Sthis^.next
          until (Sthis = nil) or (Sthis^.SectName = 'UPLOAD');
          if Sthis^.SectName = 'UPLOAD'
            then
              begin
                RcvDrv := Sthis^.SectDrive;
                RcvUsr := Sthis^.SectUser
              end
            else Writeln(BEL, 'UPLOAD section not found.')
        end
      else Writeln(BEL, 'Section file missing.');

    Assign(sysm_file, sysm_name + ext);
    Assign(summ_file, summ_name + ext);
    Assign(mesg_file, mesg_name + ext);

    Assign(logr_file, logr_name + ext);
    {$I-} reset(logr_file) {$I+};
    OK := (IOresult = 0);
    if not OK
      then
        begin
          Writeln(BEL, 'Log file missing.  Creating ', logr_name, ext);
          Rewrite(logr_file);
          logr_rec.user := 0;
          Write(logr_file, logr_rec)
        end;
    log(0, '');
    Close(logr_file)
  end;

overlay procedure setup;
{ Initialize variables and open files }
  begin
    mdinit;                                 { Get modem ready }
    fini             := FALSE;
    local_online     := FALSE;
    remote_online    := FALSE;
    local_copy       := TRUE;
    printer_copy     := FALSE;              { Sysop can turn on printer }
    remote_copy      := FALSE;

    user_loc         := 0;                  { In case disconnect before login }
    user_rec.case_sw := FALSE;              { Upper case only }
    user_rec.nulls   := 2;                  {   and 2 nulls until recognition }
    st_switch        := TRUE;               { Default file size display - in 'k' }
    mode             := message_mode;       { Start system in message mode }
    noisy            := FALSE;              { Prompt bell initially off }

    InitIndex;                              { Get files ready for use }

    OpenFile(DatF, user_data + ext, SizeOf(user_rec));
    if OK
      then OpenIndex(IdxF, user_indx + ext, len_ln + len_fn, 0);
    if not OK
      then
        begin
          Write(BEL, 'User files missing.  Creating ', user_data, ext);
          MakeFile(DatF, user_data + ext, SizeOf(user_rec));
          Writeln(', ', user_indx, ext);
          MakeIndex(IdxF, user_indx + ext, len_ln + len_fn, 0)
        end;

    {$I-} reset(logr_file) {$I+};
    OK := (IOresult = 0);

    {$I-} Reset(summ_file) {$I+};
    OK := (IOresult = 0);
    if OK
      then
        begin
          {$I-} Reset(mesg_file) {$I+};
          OK := (IOresult = 0)
        end;
    if not OK
      then
        begin
          Write(BEL, 'Message files missing.  Creating ', summ_name, ext);
          Rewrite(summ_file);
          summ_rec.summ_num := 0;
          Write(summ_file, summ_rec);
          Writeln(', ', mesg_name, ext);
          Rewrite(mesg_file)
        end
  end;

overlay procedure wrapup;
{ Disconnect, update and close all files}
  var
    t: tad_array;
  begin
    write(USR, 'Goodbye, please call again...');
    if mdcarck
      then mdhangup;
    if user_loc > 0                         { Don't update files if user not initialized }
      then
        begin
          if MesgBase = nil                 { Get last message }
            then user_rec.lasthi := 0
            else user_rec.lasthi := MesgLast^.MesgNo;
          GetTAD(t);
          user_rec.laston := t;
          time_on := 60 * t[2] + t[1] - login_time;
          if time_on < 0
            then time_on := time_on + 1440;
          user_rec.time_today := user_rec.time_today + time_on;
          user_rec.time_total := user_rec.time_total + time_on;

          PutRec(DatF, user_loc, user_rec);

          log(3, '')
        end;

    CloseFile(DatF);
    CloseIndex(IdxF);
    Close(summ_file);
    Close(mesg_file);
    Close(logr_file)
  end;

overlay procedure wait_for_user;
{ Wait for call or console interrupt }
  var
    ch: char;
    count: integer;
  begin
    if delay_down
      then mdbusy;
    ClrScr;
    putstat(version + ' ready.  Heap: ' + intstr(MaxAvail, 6));
    count := 15000;
    repeat
      if count > 0
        then
          begin
            count := pred(count);
            if count = 0
              then
                begin
                  ClrScr;
                  GotoXY(Random(80), Random(24));
                  count := 15000
                end
          end;
      if delay_down
        then write(BEL);
      ch := GetChar;
      if ch = ETX
        then
          begin
            putstat('ROS completed.');
            mdbusy;
            fini := TRUE;
            log(1, '');
            CloseFile(DatF);
            CloseIndex(IdxF);
            Close(summ_file);
            Close(mesg_file);
            Close(logr_file)
          end
      else if ch = CR
        then
          begin
            putstat('Local use requested.');
            WRITELN(USR, CR);
            mdbusy;
            rate := 0.02075;                { Pretend we're running at 1200 bps }
            local_online := TRUE
          end
      else if mdring
        then
          begin
            putstat('Ring detected.');
            WRITELN(USR, CR);
            mdans;
            ch := chr(mdinp);               { Clear any garbage characters }
            ch := chr(mdinp);
            remote_online := mdcarck;
            remote_copy   := TRUE
          end
    until fini or local_online or remote_online;
    delay_down := FALSE
  end;

