{ ROSFIL.INC - Remote Operating System File Sub-system }

overlay procedure section(req: Str10);
{ View and set up section for use }
  var
    i: integer;
    this: SectPtr;

  procedure ReadDir(var entries: integer; var first: FilePtr);
  { Create an alphabetized list of files in the current section }
    var
      i, off: integer;
      this: FilePtr;
      searchblk: FileBlock;                 { Buffer to define search params }
      answerblk: array[0..3] of FileBlock;  { Buffer to receive file names }
    begin
      new_dir := TRUE;
      while first <> nil do                 { Clean out any old directory list }
        begin
          this := first;
          first := first^.Next;             { Go to next on chain }
          dispose(this)                     { Reclaim space }
        end;
      DirEntries := 0;
      with searchblk do
        begin
          drive := 0;
          for i := 1 to 11 do
            fname[i] := ord('?');
          extent := ord('?');
          s1     := ord('?');
          s2     := ord('?');
          reccount := 0;
          for i := 16 to 31 do
            map[i] := 0
        end;
      BDOS(setdma, addr(answerblk));
      BDOS(seldrive, SetDrv);               { 'Log in' drive/user }
      BDOS(getseluser, SetUsr);
      off := BDOS(findfirst, addr(searchblk));
      while off <> 255 do
        begin
          with answerblk[off] do
            if (ord(fname[10]) and $80) = 0 { Non-system? }
              then InsertFile(fname, 0, reccount + (extent + (s2 shl 5)) shl 7,
                              entries, first);
          off := BDOS(findnext, addr(searchblk))
        end;
      BDOS(seldrive, HomDrv);               { Restore default drive/user }
      BDOS(getseluser, HomUsr);
      BDOS(setdma, fcb)                     { Restore DMA buffer }
    end;

  begin { section }
    if req = ''
      then req := compress(prompt('Section (? for MENU): ', 10, 'ES'));
    writeln(USR);
    while (not new_dir) and (req <> '') do
      begin
        this := SectBase;
        if req = '?'
          then
            begin
              writeln(USR, 'Available file sections:');
              writeln(USR);
              while (not brk) and (this <> nil) do
                begin
                  if user_rec.access >= this^.SectAccs
                    then writeln(USR, pad(this^.SectName, 14), this^.SectDesc)
                  else if this^.SectAccs < 100
                    then writeln(USR, pad(this^.SectName, 14), 'Validation required');
                  this := this^.next
                end;
              writeln(USR);
              req := compress(prompt('Section (? for MENU): ', 10, 'AES'));
              writeln(USR)
            end
        else if req <> ''
          then
            begin
              while (req <> this^.SectName) and (this <> nil) do
                this := this^.next;
              if (req = this^.SectName) and (user_rec.access >= this^.SectAccs)
                then
                  begin
                    SectReq := req;
                    SetDrv  := this^.SectDrive;
                    SetUsr  := this^.SectUser;
                    ReadDir(DirEntries, DirBase)
                  end
              else if (req = this^.SectName) and (this^.SectAccs < 100)
                then
                  begin
                    writeln(USR, 'Validation required');
                    writeln(USR);
                    req := compress(prompt('Section (? for MENU): ', 10, 'AES'));
                    writeln(USR)
                  end
                else
                  begin
                    writeln(USR, '"', req, '" not found.  Available file sections:');
                    writeln(USR);
                    i := 0;
                    this := SectBase;
                    while (not brk) and (this <> nil) do
                      begin
                        if user_rec.access >= this^.SectAccs
                          then
                            begin
                              write(USR, pad(this^.SectName, 12));
                              i := succ(i);
                              if 0 = i mod 6
                                then writeln(USR)
                            end;
                        this := this^.next
                      end;
                    if 0 <> i mod 6
                      then writeln(USR);
                    writeln(USR);
                    req := compress(prompt('Section (? for MENU): ', 10, 'AES'));
                    writeln(USR)
                  end
            end
      end
  end;

overlay procedure library;
{ Open and close a library }
  var
    i: integer;

  procedure LibReadDir(var entries: integer; var first: FilePtr);
  { Read library directory }
    var
      i, off: integer;
      this: FilePtr;
      LibBlock: array[0..3] of EntryBlock;
    begin
      new_dir := TRUE;
      in_library := TRUE;
      while first <> nil do                 { Clean out any old library list }
        begin
          this := first;
          first := first^.Next;             { Go to next on chain }
          dispose(this)                     { Reclaim space }
        end;
      LibEntries := 0;
      blockread(LibFile, LibBlock, 1);
      for i := 1 to pred(LibBlock[0].fsize shl 2) do
        begin
          off := i mod 4;
          if off = 0
            then blockread(LibFile, LibBlock, 1);
          with LibBlock[off] do
            if status < $FE
              then InsertFile(fname, index, fsize, entries, first)
        end
    end;

  begin { library }
    if in_library
      then
        begin
          BDOS(seldrive, SetDrv);           { 'Log in' drive/user }
          BDOS(getseluser, SetUsr);
          Close(LibFile);
          BDOS(seldrive, HomDrv);           { Restore default drive/user }
          BDOS(getseluser, HomUsr);
          writeln(USR, 'Library ', LibReq, ' closed.');
          in_library := FALSE
        end
      else
        begin
          LibReq := compress(prompt('Library: ', 12, 'ES'));
          writeln(USR);
          if LibReq <> ''
            then
              begin
                if pos('.', LibReq) = 0
                  then LibReq := LibReq + '.LBR';
                if copy(LibReq, succ(pos('.', LibReq)), 3) = 'LBR'
                  then
                    begin
                      BDOS(seldrive, SetDrv);    { 'Log in' drive/user }
                      BDOS(getseluser, SetUsr);
                      Assign(LibFile, LibReq);
                      {$I-} reset(LibFile) {$I+};
                      if IOresult = 0
                        then LibReadDir(LibEntries, LibBase)
                        else writeln(USR, 'Cannot open ', LibReq);
                      BDOS(seldrive, HomDrv);    { Restore default drive/user }
                      BDOS(getseluser, HomUsr)
                    end
                  else writeln(USR, LibReq, ' is not a library file.')
              end
        end
  end;

overlay procedure directory;
{ Display section or library directory }

  procedure DispDir(entries: integer; this: FilePtr);
  { Display list }
    var
      i, j, mm, ss, size: integer;
      st: Str10;
    begin
      if entries = 0
        then writeln(USR, ' is empty.')
        else
          begin
            writeln(USR, ' contains ', entries, ' files:');
            i := 1;
            while (not brk) and (this <> nil) do
              begin                         { Scan the whole list }
                if st_switch
                  then
                    begin
                      size := this^.fsize shr 3;
                      if (this^.fsize mod 8) <> 0
                        then size := succ(size);
                      st := intstr(size, 4) + 'k '
                    end
                  else
                    begin
                      send_time(this^.fsize, mm, ss);
                      st := intstr(mm, 3) + ':' + intstr(ss, 2);
                      for j := 3 to length(st) do
                        if st[j] = ' '
                          then st[j] := '0'
                    end;
                write(USR, this^.fname, st);
                this := this^.next;         { Go to next on list }
                if 0 = i mod columns
                  then writeln(USR)
                  else write(USR, fence, ' ');
                i := succ(i)
              end
          end;
      if 0 <> pred(i) mod columns
        then writeln(USR)
    end;

  begin { directory }
    new_dir := FALSE;
    writeln(USR);
    if in_library
      then
        begin
          write(USR, '  Library ', LibReq);
          DispDir(LibEntries, LibBase)
        end
      else
        begin
          write(USR, '  Section ', SectReq);
          DispDir(DirEntries, DirBase)
        end
  end;

