{ ROSDEF.INC - Remote Operating System Definitions }

const
  version        = 'ROS v3.2 - 5/03/85';

{ User settable constants }

  def_acc        = 10;                      { Default access level }
  def_time       = 60;                      { Default time limit }
  ChatStart      = 12;                      { Chat hours }
  ChatEnd        = 22;
  columns        = 4;                       { Columns in directory }
  fence          = '|';                     { Character between directory columns }

  unv_days       = 5;                       { Days to retain unvalidated user }
  val_days       = 120;                     { Days to retain validated user }

  Max_Tries      =  3;                      { Max number of tries for password }
  DispLines      = 22;                      { Lines to display before pausing }

  Max_Lines      = 18;                      { Max number of lines in message }

  user_data      = 'USERDAT';               { User data }
  user_indx      = 'USERIDX';               { Index to user data }
  logr_name      = 'LOG';                   { Log file }
  mesg_name      = 'MESSAGE';               { Message file }
  summ_name      = 'SUMMARY';               { Summary file }
  sysm_name      = 'SYSMSG';                { System messages }
  sect_name      = 'SECTION';               { File section name file }

  ext            = '.B'#$C2'#';             { 'BB#' file type with 'system' bit set }

  len_fn         = 10;                      { length of firstname }
  len_ln         = 15;                      { length of lastname }
  len_name       = 25;                      { sum of above }
  len_ad         = 20;                      { length of address }
  len_pw         = 10;                      { length of password }
  len_subj       = 56;                      { length of subject }
  len_msg        = 72;                      { length of message }

  lps            = 850.0 ;                  { Loops per second }
  maxerr         = 15;                      { Block transfer errors allowed }
  BufBlocks      = 8;                       { Blocks in transfer buffer }
  BufSize        = 1024;                    { Bytes in transfer buffer }

{ ROS constants }

  mesg_pub       = -1;                      { public message flag }
  mesg_era       = -2;                      { erased message flag }

{ TURBO-access constants }

  MaxDataRecSize = 83;                      { max record Size }
  MaxKeyLen      = 26;                      { max key Size }
  PageSize       = 16;                      { page Size }
  Order          = 8;                       { half page Size }
  PageStackSize  = 5;                       { page buffer Size }
  MaxHeight      = 5;                       { max B-tree height }

{ ASCII constants }

  NUL            = #$00;
  SOH            = #$01;
  ETX            = #$03;
  EOT            = #$04;
  ACK            = #$06;
  BEL            = #$07;
  BS             = #$08;
  TAB            = #$09;
  LF             = #$0A;
  FF             = #$0C;
  CR             = #$0D;
  DC1            = #$11;                    { XON }
  DC3            = #$13;                    { XOFF }
  NAK            = #$15;
  CAN            = #$18;
  ESC            = #$1B;
  RUB            = #$7F;

{ CP/M-80 constants }

  seldrive  = 14;                           { BDOS drive select function }
  findfirst = 17;                           { BDOS search for first file function }
  findnext  = 18;                           { BDOS search for next file function }
  getdrive  = 25;                           { BDOS get default drive function }
  setdma    = 26;                           { BDOS set dma buffer address function }
  getseluser= 32;                           { BDOS get/select user area }
  fcb       = $80;                          { Default dma buffer address }

  message_mode = 1;
  files_mode   = 2;
  utility_mode = 3;
  sysop_mode   = 4;
  pr_msg    : array[1..4] of string[7] =
    ('Message', 'Files', 'Utility', 'Sysop');
  rep_msg   : array[1..4] of string[80] =
    ('ChangeEnterFilesGoodbyeKillQuick-scanReadSummaryUtilityBulletinInfoNewinOthers',
     'ChangeDirectoryFilesizeGoodbyeReceiveSendTypeLibraryMessageUtility',
     'AlterChatFilesGoodbyeMessagePromptTimeUsers',
     'AssignDeleteEditFilesGoodbyeIndexKrunchLogMessagePurgeReadToggleUtility');

type
  Str10          = string[10];
  FileName       = string[14];              { d:filename.ext }
  StrTAD         = string[30];
  StrPr          = string[45];
  StrStd         = string[80];
  StrPrint       = string[132];
  StrName        = string[len_name];
  firstname      = string[len_fn];
  lastname       = string[len_ln];
  address        = string[len_ad];
  password       = string[len_pw];
  subject        = string[len_subj];
  message        = string[len_msg];

  tad_array      = array[0..5] of byte;
  name_array     = array[1..11] of byte;
  untype_file    = file;

  MesgPtr        = ^MesgRecord;
  MesgRecord     =
    record
      MesgNo,                               { Message number }
      SummLoc    : integer;                 { Summary index }
      TypMsg     : byte;                    { Message type }
      next       : MesgPtr                  { Pointer to next element on list }
    end;

  FilePtr        = ^FileDescr;
  FileDescr      =
    record
      fname      : FileName;                { Name of a matching file }
      index,                                { Libraries only: location of file }
      fsize      : integer;                 { Size of file }
      next       : FilePtr                  { Pointer to next element on list }
    end;

  SectPtr        = ^SectRecord;
  SectRecord     =
    record
      SectDrive,                            { Drive }
      SectUser,                             { User area }
      SectAccs   : integer;                 { Access level required }
      SectName   : Str10;                   { Section name }
      SectDesc   : string[50];              { Description }
      next       : SectPtr                  { Pointer to next element on list }
    end;

  AreaPtr        = ^AreaRecord;
  AreaRecord     =
    record
      Area,                                 { Area number }
      AreaAccs   : integer;                 { Access level required }
      AreaName   : Str10;                   { Message area name }
      AreaDesc   : string[50];              { Description }
      next       : AreaPtr                  { Pointer to next element on list }
    end;

  FileBlock      =
    record
      drive      : byte;                    { Byte code }
      fname      : name_array;              { File name }
      extent,                               { Current extent }
      s1, s2, reccount: byte;               { Used to compute file size }
      map        : array[16..31] of byte    { Data map }
    end;

  EntryBlock =
    record
      status     : byte;
      fname      : name_array;
      index,
      fsize,
      CRC,
      CreationDate,
      LastChangeDate,
      CreationTime,
      LastChangeTime: integer;
      PadCount   : byte;
      filler     : array[27..31] of byte;
    end;

  user_list      =
    record
      used       : integer;                 {  2 }
      fn         : firstname;               { 11 }
      ln         : lastname;                { 16 }
      ad         : address;                 { 21 }
      pw         : password;                { 11 }
      access     : byte;                    {  1 }
      reserved   : integer;                 {  2 }
      limit      : byte;                    {  1 }
      upload     : integer;                 {  2 }
      download   : integer;                 {  2 }
      nulls      : byte;                    {  1 }
      case_sw    : boolean;                 {  1 }
      laston     : tad_array;               {  6 }
      lasthi     : integer;                 {  2 }
      time_today : integer;                 {  2 }
      time_total : integer;                 {  2 }
    end;

  logr_list      =
    record
      time_stamp : tad_array;
      action     : byte;
      user       : integer;
      text       : FileName;
    end;

  summ_list      =
    record
      summ_area  : byte;
      summ_num   : integer;
      summ_date  : tad_array;
      summ_from_num,
      summ_to_num: integer;
      summ_subject: subject;
      summ_st_rec,
      summ_size  : integer;
    end;

  mesg_list      =
    record
      mesg_text  : message;
    end;

var

{ Section globals }

  SectReq        : Str10;                   { Section name }
  SectBase       : SectPtr;                 { Start of linked list }

{ Message area globals }

  AreaReq        : Str10;                   { Message area name }
  AreaSet        : integer;                 { Current message area }
  AreaBase       : AreaPtr;                 { Start of linked list }

{ Directory globals }

  DirEntries     : integer;                 { Count of directory entries }
  mask           : FileName;                { Directory mask }
  DirBase        : FilePtr;                 { Start of linked list }

{ Library globals }

  LibEntries     : integer;                 { Count of library entries }
  LibReq         : FileName;                { Library name }
  LibBase        : FilePtr;                 { Start of linked list }

{ Message system globals }

  msg_all,                                  { Public message count }
  msg_ind,                                  { Private message count }
  msg_aut,                                  { Authored message count }
  msg_sys,                                  { Sysop viewable message count }
  msg_hi         : integer;                 { High message number }
  MesgBase, MesgLast, MesgCurr: MesgPtr;    { Pointers }

{ System globals }

  delay_down,                               { Shutdown between users }
  fini,                                     { Finished with ROS }
  in_use,                                   { Successful login }
  remote_online,                            { Remote use allowed }
  local_online,                             { Local use allowed }
  local_copy,                               { Console display }
  remote_copy,                              { Remote display }
  printer_copy,                             { Printer display }
  noisy,                                    { Prompt bell enable }
  st_switch,                                { Size/time switch }
  new_dir,                                  { New section or library selected }
  area_assign,                              { Message area reassignment switch }
  in_library     : boolean;                 { Library/section switch }

  ch             : char;                    { Input character }

  HomDrv, HomUsr,                           { Default drive/user }
  RcvDrv, RcvUsr,                           { Upload drive/user }
  SetDrv, SetUsr,                           { User selected drive/user }
  user_loc,                                 { User location in data file }
  login_time,                               { Login time }
  time_on,                                  { Time logged in }
  timeout,
  mode,                                     { Current mode of operation }
  temp_access    : integer;                 { Temporary access level }

  rate           : real;                    { Factor used to compute send time }

  login_t        : tad_array;               { Login time }

{ Files }

  user_rec       :         user_list;

  logr_rec       :         logr_list;
  logr_file      : file of logr_list;

  summ_rec       :         summ_list;
  summ_file      : file of summ_list;

  mesg_rec       :         mesg_list;
  mesg_file      : file of mesg_list;

  sysm_file,
  sect_file      : text;

  LibFile        : file;                    { Library file }

