{ ROS - Remote Operating System Summary File Update Program
  Converts ROS message summary files for pre-3.2 versions
  to 3.2 format which supports multiple message areas. }

  const
    old_name       = 'OLDSUMM';             { Old summary file }
    summ_name      = 'SUMMARY';             { Summary file }
    ext            = '.B'#$C2'#';           { 'BB#' file type with 'system' bit set }
    len_subj       = 56;                    { Length of subject }

  type
    subject        = string[len_subj];
    tad_array      = array[0..5] of byte;

    old_list       =
      record
        summ_num   : integer;
        summ_date  : tad_array;
        summ_from_num,
        summ_to_num: integer;
        summ_subject: subject;
        summ_st_rec,
        summ_size  : integer;
      end;

    summ_list      =
      record
        summ_area  : byte;                  { This byte is added with 3.2 }
        summ_num   : integer;
        summ_date  : tad_array;
        summ_from_num,
        summ_to_num: integer;
        summ_subject: subject;
        summ_st_rec,
        summ_size  : integer;
      end;

  var
    old_rec        :         old_list;
    old_file       : file of old_list;
    summ_rec       :         summ_list;
    summ_file      : file of summ_list;

  begin
    Assign(old_file, summ_name + ext);
    Rename(old_file, old_name + ext);
    Assign(summ_file, summ_name + ext);
    {$I-} Reset(old_file) {$I+};
    if IOresult = 0
      then
        begin
          Rewrite(summ_file);
          while not EOF(old_file) do
            begin
              read(old_file, old_rec);
              summ_rec.summ_area     := 1;
              summ_rec.summ_num      := old_rec.summ_num;
              summ_rec.summ_date     := old_rec.summ_date;
              summ_rec.summ_from_num := old_rec.summ_from_num;
              summ_rec.summ_to_num   := old_rec.summ_to_num;
              summ_rec.summ_subject  := old_rec.summ_subject;
              summ_rec.summ_st_rec   := old_rec.summ_st_rec;
              summ_rec.summ_size     := old_rec.summ_size;
              write(summ_file, summ_rec)
            end;
          Close(old_file);
          Close(summ_file);
          writeln('Conversion complete.')
        end
      else writeln('Summary file not found.')
  end.
